/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.parser;

import io.hyperfoil.api.config.Benchmark;
import io.hyperfoil.api.config.BenchmarkBuilder;
import io.hyperfoil.api.config.BenchmarkData;
import io.hyperfoil.core.api.Plugin;
import io.hyperfoil.core.parser.AbstractMappingParser;
import io.hyperfoil.core.parser.AgentsParser;
import io.hyperfoil.core.parser.Context;
import io.hyperfoil.core.parser.ErgonomicsParser;
import io.hyperfoil.core.parser.ParserException;
import io.hyperfoil.core.parser.PhasesParser;
import io.hyperfoil.core.parser.PropertyParser;
import io.hyperfoil.core.parser.RunHooksParser;
import io.hyperfoil.core.parser.ScenarioParser;
import io.hyperfoil.core.parser.StaircaseParser;
import io.hyperfoil.core.util.Util;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.events.DocumentEndEvent;
import org.yaml.snakeyaml.events.DocumentStartEvent;
import org.yaml.snakeyaml.events.Event;
import org.yaml.snakeyaml.events.MappingEndEvent;
import org.yaml.snakeyaml.events.MappingStartEvent;
import org.yaml.snakeyaml.events.SequenceEndEvent;
import org.yaml.snakeyaml.events.SequenceStartEvent;
import org.yaml.snakeyaml.events.StreamEndEvent;
import org.yaml.snakeyaml.events.StreamStartEvent;

public class BenchmarkParser
extends AbstractMappingParser<BenchmarkBuilder> {
    private static final Logger log = LoggerFactory.getLogger(BenchmarkParser.class);
    private static final BenchmarkParser INSTANCE = new BenchmarkParser();
    private static final boolean DEBUG_PARSER = Boolean.getBoolean("io.hyperfoil.parser.debug");

    public static BenchmarkParser instance() {
        return INSTANCE;
    }

    private BenchmarkParser() {
        this.register("$schema", new PropertyParser.String<BenchmarkBuilder>(this::checkSchema));
        this.register("name", new PropertyParser.String<BenchmarkBuilder>(BenchmarkBuilder::name));
        this.register("agents", new AgentsParser());
        this.register("ergonomics", new ErgonomicsParser());
        this.register("phases", new PhasesParser());
        this.register("threads", new PropertyParser.Int<BenchmarkBuilder>(BenchmarkBuilder::threads));
        this.register("statisticsCollectionPeriod", new PropertyParser.Int<BenchmarkBuilder>(BenchmarkBuilder::statisticsCollectionPeriod));
        this.register("usersPerSec", new PropertyParser.Double<BenchmarkBuilder>((bb, value) -> bb.singleConstantRatePhase().usersPerSec((double)value)));
        this.register("duration", new PropertyParser.String<BenchmarkBuilder>((bb, value) -> bb.singleConstantRatePhase().duration(Util.parseToMillis(value))));
        this.register("maxDuration", new PropertyParser.String<BenchmarkBuilder>((bb, value) -> bb.singleConstantRatePhase().maxDuration(Util.parseToMillis(value))));
        this.register("maxSessions", new PropertyParser.Int<BenchmarkBuilder>((bb, value) -> bb.singleConstantRatePhase().maxSessions((int)value)));
        this.register("scenario", (ctx, target) -> new ScenarioParser().parse(ctx, target.singleConstantRatePhase().scenario()));
        this.register("staircase", new StaircaseParser());
        this.register("triggerUrl", new PropertyParser.String<BenchmarkBuilder>(BenchmarkBuilder::triggerUrl));
        this.register("pre", new RunHooksParser(BenchmarkBuilder::addPreHook));
        this.register("post", new RunHooksParser(BenchmarkBuilder::addPostHook));
        ServiceLoader.load(Plugin.class).forEach(instance -> this.register(instance.name(), instance.parser()));
    }

    private void checkSchema(BenchmarkBuilder builder, String schema) {
        if (schema.startsWith("http") && !schema.startsWith("http://hyperfoil.io/schema") && !schema.startsWith("https://hyperfoil.io/schema")) {
            log.warn((Object)"Unexpected schema: should start with `http://hyperfoil.io/schema`!");
        }
    }

    public Benchmark buildBenchmark(String source, BenchmarkData data) throws ParserException {
        return this.builder(source, data).build();
    }

    public BenchmarkBuilder builder(String source, BenchmarkData data) throws ParserException {
        Yaml yaml = new Yaml();
        Iterator<Event> events = yaml.parse((Reader)new StringReader(source)).iterator();
        if (DEBUG_PARSER) {
            events = new DebugIterator<Event>(events);
        }
        Context ctx = new Context(events);
        ctx.expectEvent(StreamStartEvent.class);
        ctx.expectEvent(DocumentStartEvent.class);
        BenchmarkBuilder benchmarkBuilder = new BenchmarkBuilder(source, data);
        this.parse(ctx, benchmarkBuilder);
        ctx.expectEvent(DocumentEndEvent.class);
        ctx.expectEvent(StreamEndEvent.class);
        return benchmarkBuilder;
    }

    public Benchmark buildBenchmark(InputStream inputStream, BenchmarkData data) throws ParserException, IOException {
        return this.buildBenchmark(Util.toString(inputStream), data);
    }

    private static class DebugIterator<T>
    implements Iterator<T> {
        private final Iterator<T> it;
        private String indent = "";

        private DebugIterator(Iterator<T> it) {
            this.it = it;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public T next() {
            T event = this.it.next();
            if (event instanceof MappingEndEvent || event instanceof SequenceEndEvent) {
                this.indent = this.indent.substring(2);
            }
            StackTraceElement[] stackTrace = new Exception().fillInStackTrace().getStackTrace();
            System.out.println(this.indent + event + " fetched from " + stackTrace[1] + "\t" + stackTrace[2] + "\t" + stackTrace[3]);
            if (event instanceof MappingStartEvent || event instanceof SequenceStartEvent) {
                this.indent = this.indent + "| ";
            }
            return event;
        }
    }
}

