/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.parser;

import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.Rewritable;
import io.hyperfoil.core.parser.Parser;
import io.hyperfoil.core.parser.ParserException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.yaml.snakeyaml.events.AliasEvent;
import org.yaml.snakeyaml.events.Event;
import org.yaml.snakeyaml.events.MappingEndEvent;
import org.yaml.snakeyaml.events.MappingStartEvent;
import org.yaml.snakeyaml.events.ScalarEvent;
import org.yaml.snakeyaml.events.SequenceEndEvent;
import org.yaml.snakeyaml.events.SequenceStartEvent;

public class Context {
    private final Map<String, Anchor> anchors = new HashMap<String, Anchor>();
    private final Iterator<Event> events;
    private Event peeked;
    private final Stack<Object> vars = new Stack();

    Context(Iterator<Event> events) {
        this.events = events;
    }

    private ParserException transformException(org.yaml.snakeyaml.parser.ParserException e) {
        StringBuilder sb = new StringBuilder("YAML is malformed at line ").append(e.getProblemMark().getLine() + 1).append(", column ").append(e.getProblemMark().getColumn() + 1).append(": ").append(e.getProblem());
        return new ParserException(sb.toString());
    }

    private String translate(Class<? extends Event> clazz) {
        if (clazz == MappingStartEvent.class) {
            return "<start of mapping>";
        }
        if (clazz == MappingEndEvent.class) {
            return "<end of mapping>";
        }
        if (clazz == SequenceStartEvent.class) {
            return "<start of sequence>";
        }
        if (clazz == SequenceEndEvent.class) {
            return "<end of sequence>";
        }
        if (clazz == ScalarEvent.class) {
            return "<scalar value>";
        }
        return clazz.getSimpleName();
    }

    public boolean hasNext() throws ParserException {
        try {
            return this.events.hasNext();
        }
        catch (org.yaml.snakeyaml.parser.ParserException e) {
            throw this.transformException(e);
        }
    }

    public Event next() throws ParserException {
        if (this.peeked == null) {
            try {
                return this.events.next();
            }
            catch (org.yaml.snakeyaml.parser.ParserException e) {
                throw this.transformException(e);
            }
        }
        Event tmp = this.peeked;
        this.peeked = null;
        return tmp;
    }

    public Event peek() throws ParserException {
        if (this.peeked == null) {
            try {
                this.peeked = this.events.next();
            }
            catch (org.yaml.snakeyaml.parser.ParserException e) {
                throw this.transformException(e);
            }
        }
        return this.peeked;
    }

    public void consumePeeked(Event event) throws ParserException {
        Event peekedEvent = this.next();
        assert (peekedEvent == event);
    }

    public void setAnchor(Event event, String anchor, Object object) throws ParserException {
        Objects.requireNonNull(anchor);
        Objects.requireNonNull(object);
        Anchor prev = this.anchors.putIfAbsent(anchor + ":" + object.getClass().getName(), new Anchor(event, object));
        if (prev != null) {
            throw new ParserException(event, "Anchor '" + anchor + "' already defined on '" + ParserException.location(prev.source) + "'");
        }
    }

    public <T> T getAnchor(Event event, String alias, Class<T> clazz) throws ParserException {
        Objects.requireNonNull(alias);
        Anchor anchor = this.anchors.get(alias + ":" + clazz.getName());
        if (anchor == null) {
            String prefix = alias + ":";
            for (String key : this.anchors.keySet()) {
                if (!key.startsWith(prefix)) continue;
                Anchor similar = this.anchors.get(key);
                throw new ParserException(event, "There is no anchor for '" + alias + "' with type '" + clazz + "' but there is another anchor '" + key + "' on '" + ParserException.location(similar.source) + "'");
            }
            throw new ParserException(event, "There's no anchor for '" + alias + "', available are '" + this.anchors.keySet().stream().sorted().collect(Collectors.toList()) + "'");
        }
        if (!clazz.isInstance(anchor.object)) {
            throw new ParserException(event, "'" + alias + "' is anchored to unexpected type '" + anchor.object.getClass() + "' while we expect '" + clazz + "'; anchor is defined on '" + ParserException.location(anchor.source) + "'");
        }
        Object object = anchor.object;
        return (T)object;
    }

    public <E extends Event> E expectEvent(Class<E> eventClazz) throws ParserException {
        if (this.hasNext()) {
            Event event = this.next();
            if (!eventClazz.isInstance(event)) {
                throw new ParserException(event, "Expected " + this.translate(eventClazz) + ", got " + this.translate(event.getClass()) + ": " + event);
            }
            Event expectedEvent = event;
            return (E)expectedEvent;
        }
        throw this.noMoreEvents(eventClazz);
    }

    @SafeVarargs
    public final ParserException noMoreEvents(Class<? extends Event> ... eventClazzes) {
        String expected = Stream.of(eventClazzes).map(this::translate).collect(Collectors.joining(", "));
        return new ParserException("Expected one of [" + expected + "] but there are no more events.");
    }

    public ParserException unexpectedEvent(Event event) {
        return new ParserException(event, "Unexpected " + this.translate(event.getClass()) + ": " + event);
    }

    public <LI> void parseList(LI target, Parser<LI> consumer) throws ParserException {
        if (!this.hasNext()) {
            throw this.noMoreEvents(SequenceStartEvent.class, ScalarEvent.class);
        }
        Event event = this.next();
        if (event instanceof SequenceStartEvent) {
            String anchor = ((SequenceStartEvent)event).getAnchor();
            if (anchor != null) {
                this.setAnchor(event, anchor, target);
            }
            while (this.hasNext()) {
                Event itemEvent = this.peek();
                if (itemEvent instanceof SequenceEndEvent) {
                    this.consumePeeked(itemEvent);
                    break;
                }
                try {
                    consumer.parse(this, target);
                }
                catch (ParserException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new ParserException(itemEvent, "Benchmark parsing error", e);
                }
            }
        } else if (event instanceof ScalarEvent) {
            String value = ((ScalarEvent)event).getValue();
            if (value != null && !value.isEmpty()) {
                throw new ParserException(event, "Expected a sequence, got '" + value + "'");
            }
        } else {
            throw this.unexpectedEvent(event);
        }
    }

    public <A extends Rewritable<A>> void parseAliased(Class<A> aliasType, A target, Parser<A> parser) throws ParserException {
        block5: {
            Event event = this.peek();
            try {
                if (event instanceof MappingStartEvent) {
                    String anchor = ((MappingStartEvent)event).getAnchor();
                    if (anchor != null) {
                        this.setAnchor(event, anchor, target);
                    }
                    parser.parse(this, target);
                    break block5;
                }
                if (event instanceof AliasEvent) {
                    String anchor = ((AliasEvent)event).getAnchor();
                    Rewritable aliased = (Rewritable)this.getAnchor(event, anchor, aliasType);
                    target.readFrom((Rewritable)aliased);
                    this.consumePeeked(event);
                    break block5;
                }
                throw this.unexpectedEvent(event);
            }
            catch (BenchmarkDefinitionException e) {
                throw new ParserException(event, "Error in benchmark builders", e);
            }
        }
    }

    public <S> void parseMapping(S target, BuilderProvider<S> builderProvider) throws ParserException {
        this.expectEvent(MappingStartEvent.class);
        while (this.hasNext()) {
            Event next = this.next();
            if (next instanceof MappingEndEvent) {
                return;
            }
            if (next instanceof ScalarEvent) {
                ScalarEvent event = (ScalarEvent)next;
                Parser<S> builder = builderProvider.apply(event);
                builder.parse(this, target);
                continue;
            }
            throw this.unexpectedEvent(next);
        }
        throw this.noMoreEvents(MappingEndEvent.class);
    }

    public void pushVar(Object var) {
        this.vars.push(var);
    }

    public <T> T popVar(Class<T> clazz) {
        Object top = this.vars.peek();
        if (clazz != null && top != null && !clazz.isInstance(top)) {
            throw new IllegalStateException("On the top of the stack is '" + top + "'");
        }
        Object popped = this.vars.pop();
        return (T)popped;
    }

    public <T> T peekVar(Class<T> clazz) {
        Object top = this.vars.peek();
        if (clazz != null && top != null && !clazz.isInstance(top)) {
            throw new IllegalStateException("On the top of the stack is '" + top + "'");
        }
        Object peeked = top;
        return (T)peeked;
    }

    private static class Anchor {
        final Event source;
        final Object object;

        private Anchor(Event source, Object object) {
            this.source = source;
            this.object = object;
        }
    }

    @FunctionalInterface
    public static interface BuilderProvider<S> {
        public Parser<S> apply(ScalarEvent var1) throws ParserException;
    }
}

