/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.parser;

import io.hyperfoil.api.config.ScenarioBuilder;
import io.hyperfoil.api.config.SequenceBuilder;
import io.hyperfoil.core.parser.Context;
import io.hyperfoil.core.parser.Parser;
import io.hyperfoil.core.parser.ParserException;
import io.hyperfoil.core.parser.SequenceParser;
import org.yaml.snakeyaml.events.MappingEndEvent;
import org.yaml.snakeyaml.events.MappingStartEvent;
import org.yaml.snakeyaml.events.ScalarEvent;

class OrderedSequenceParser
implements Parser<ScenarioBuilder> {
    OrderedSequenceParser() {
    }

    @Override
    public void parse(Context ctx, ScenarioBuilder target) throws ParserException {
        ctx.pushVar(null);
        ctx.parseList(target, this::parseSequence);
        ctx.popVar(null);
    }

    private void parseSequence(Context ctx, ScenarioBuilder target) throws ParserException {
        ctx.expectEvent(MappingStartEvent.class);
        ScalarEvent sequenceNameEvent = ctx.expectEvent(ScalarEvent.class);
        SequenceBuilder lastBuilder = ctx.popVar(SequenceBuilder.class);
        String name = sequenceNameEvent.getValue();
        SequenceBuilder sequenceBuilder = lastBuilder == null ? target.initialSequence(name) : target.sequence(name);
        SequenceParser.parseSequence(ctx, sequenceBuilder);
        if (lastBuilder != null) {
            lastBuilder.nextSequence(name);
        }
        ctx.pushVar(sequenceBuilder);
        ctx.expectEvent(MappingEndEvent.class);
    }
}

