/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.parser;

import io.hyperfoil.api.config.Phase;
import io.hyperfoil.api.config.PhaseBuilder;
import io.hyperfoil.api.config.ScenarioBuilder;
import io.hyperfoil.core.parser.AbstractParser;
import io.hyperfoil.core.parser.Adapter;
import io.hyperfoil.core.parser.Context;
import io.hyperfoil.core.parser.IncrementPropertyParser;
import io.hyperfoil.core.parser.ParserException;
import io.hyperfoil.core.parser.PhaseForkParser;
import io.hyperfoil.core.parser.PropertyParser;
import io.hyperfoil.core.parser.ScenarioParser;
import io.hyperfoil.core.parser.StartAfterParser;
import io.hyperfoil.core.util.Util;
import java.util.function.Predicate;

abstract class PhaseParser
extends AbstractParser<PhaseBuilder.Catalog, PhaseBuilder<?>> {
    PhaseParser() {
        this.register("startTime", new PropertyParser.String<PhaseBuilder>((pb, time) -> pb.startTime(Util.parseToMillis(time))));
        this.register("startAfter", new StartAfterParser(PhaseBuilder::startAfter));
        this.register("startAfterStrict", new StartAfterParser(PhaseBuilder::startAfterStrict));
        this.register("duration", new PropertyParser.String<PhaseBuilder>((pb, duration) -> pb.duration(Util.parseToMillis(duration))));
        this.register("maxDuration", new PropertyParser.String<PhaseBuilder>((pb, duration) -> pb.maxDuration(Util.parseToMillis(duration))));
        this.register("maxIterations", new PropertyParser.Int<PhaseBuilder>(PhaseBuilder::maxIterations));
        this.register("scenario", new Adapter<PhaseBuilder, ScenarioBuilder>(PhaseBuilder::scenario, new ScenarioParser()));
        this.register("forks", new PhaseForkParser());
    }

    @Override
    public void parse(Context ctx, PhaseBuilder.Catalog target) throws ParserException {
        this.callSubBuilders(ctx, this.type(target));
    }

    protected abstract PhaseBuilder<?> type(PhaseBuilder.Catalog var1);

    static class ConstantRate
    extends OpenModel {
        ConstantRate() {
            this.register("usersPerSec", new IncrementPropertyParser.Double<PhaseBuilder>((builder, base, inc) -> ((PhaseBuilder.ConstantRate)builder).usersPerSec((double)base, (double)inc)));
        }

        protected PhaseBuilder.ConstantRate type(PhaseBuilder.Catalog catalog) {
            return catalog.constantRate(-1);
        }
    }

    static class RampRate
    extends OpenModel {
        Predicate<Phase.RampRate> constraint;
        String constraintMessage;

        RampRate() {
            this.register("initialUsersPerSec", new IncrementPropertyParser.Double<PhaseBuilder>((builder, base, inc) -> ((PhaseBuilder.RampRate)builder).initialUsersPerSec((double)base, (double)inc)));
            this.register("targetUsersPerSec", new IncrementPropertyParser.Double<PhaseBuilder>((builder, base, inc) -> ((PhaseBuilder.RampRate)builder).targetUsersPerSec((double)base, (double)inc)));
        }

        protected PhaseBuilder.RampRate type(PhaseBuilder.Catalog catalog) {
            return catalog.rampRate(-1, -1).constraint(this.constraint, this.constraintMessage);
        }

        RampRate constraint(Predicate<Phase.RampRate> constraint, String message) {
            this.constraint = constraint;
            this.constraintMessage = message;
            return this;
        }
    }

    static abstract class OpenModel
    extends PhaseParser {
        OpenModel() {
            this.register("maxSessions", new PropertyParser.Int<PhaseBuilder>((builder, sessions) -> ((PhaseBuilder.OpenModel)builder).maxSessions((int)sessions)));
            this.register("variance", new PropertyParser.Boolean<PhaseBuilder>((builder, variance) -> ((PhaseBuilder.OpenModel)builder).variance((boolean)variance)));
            this.register("sessionLimitPolicy", new PropertyParser.Enum((Enum[])Phase.SessionLimitPolicy.values(), (builder, policy) -> ((PhaseBuilder.OpenModel)builder).sessionLimitPolicy((Phase.SessionLimitPolicy)((Object)policy))));
        }
    }

    static class Always
    extends PhaseParser {
        Always() {
            this.register("users", new IncrementPropertyParser.Int<PhaseBuilder>((builder, base, inc) -> ((PhaseBuilder.Always)builder).users((int)base, (int)inc)));
        }

        protected PhaseBuilder.Always type(PhaseBuilder.Catalog catalog) {
            return catalog.always(-1);
        }
    }

    static class AtOnce
    extends PhaseParser {
        AtOnce() {
            this.register("users", new IncrementPropertyParser.Int<PhaseBuilder>((builder, base, inc) -> ((PhaseBuilder.AtOnce)builder).users((int)base, (int)inc)));
        }

        protected PhaseBuilder.AtOnce type(PhaseBuilder.Catalog catalog) {
            return catalog.atOnce(-1);
        }
    }
}

