/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.parser;

import io.hyperfoil.api.config.BenchmarkBuilder;
import io.hyperfoil.api.config.PhaseBuilder;
import io.hyperfoil.core.parser.AbstractParser;
import io.hyperfoil.core.parser.Context;
import io.hyperfoil.core.parser.Parser;
import io.hyperfoil.core.parser.ParserException;
import io.hyperfoil.core.parser.PhaseParser;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import org.yaml.snakeyaml.events.Event;
import org.yaml.snakeyaml.events.MappingEndEvent;
import org.yaml.snakeyaml.events.MappingStartEvent;
import org.yaml.snakeyaml.events.ScalarEvent;

class PhasesParser
extends AbstractParser<BenchmarkBuilder, PhaseBuilder.Catalog> {
    private static Logger log = LoggerFactory.getLogger(PhasesParser.class);

    PhasesParser() {
        this.register("atOnce", new PhaseParser.AtOnce());
        this.register("always", new PhaseParser.Always());
        this.register("rampPerSec", new PhaseParser.RampRate(){

            @Override
            public void parse(Context ctx, PhaseBuilder.Catalog target) throws ParserException {
                log.warn((Object)"Phase type 'rampPerSec' was deprecated; use 'increasingRate' or 'decreasingRate' instead.");
                super.parse(ctx, target);
            }
        });
        this.register("increasingRate", new PhaseParser.RampRate().constraint(p -> p.initialUsersPerSec < p.targetUsersPerSec, "'increasingRate' must have 'initialUsersPerSec' lower than 'targetUsersPerSec'"));
        this.register("decreasingRate", new PhaseParser.RampRate().constraint(p -> p.initialUsersPerSec > p.targetUsersPerSec, "'decreasingRate' must have 'initialUsersPerSec' higher than 'targetUsersPerSec'"));
        this.register("constantPerSec", new PhaseParser.ConstantRate(){

            @Override
            public void parse(Context ctx, PhaseBuilder.Catalog target) throws ParserException {
                log.warn((Object)"Phase type 'constantPerSec' was deprecated; use 'constantRate' instead.");
                super.parse(ctx, target);
            }
        });
        this.register("constantRate", new PhaseParser.ConstantRate());
    }

    @Override
    public void parse(Context ctx, BenchmarkBuilder target) throws ParserException {
        ctx.parseList(target, this::parsePhase);
    }

    private void parsePhase(Context ctx, BenchmarkBuilder target) throws ParserException {
        ctx.expectEvent(MappingStartEvent.class);
        ScalarEvent event = ctx.expectEvent(ScalarEvent.class);
        String name = event.getValue();
        ctx.expectEvent(MappingStartEvent.class);
        event = ctx.expectEvent(ScalarEvent.class);
        Parser builder = (Parser)this.subBuilders.get(event.getValue());
        if (builder == null) {
            throw new ParserException((Event)event, "Invalid phase type: '" + event.getValue() + "', expected one of " + this.subBuilders.keySet());
        }
        builder.parse(ctx, target.addPhase(name));
        ctx.expectEvent(MappingEndEvent.class);
        ctx.expectEvent(MappingEndEvent.class);
    }
}

