/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.parser;

import io.hyperfoil.api.config.ScenarioBuilder;
import io.hyperfoil.core.parser.AbstractParser;
import io.hyperfoil.core.parser.Context;
import io.hyperfoil.core.parser.OrderedSequenceParser;
import io.hyperfoil.core.parser.ParserException;
import io.hyperfoil.core.parser.PropertyParser;
import io.hyperfoil.core.parser.SequenceParser;
import io.hyperfoil.core.parser.VarParser;
import org.yaml.snakeyaml.events.AliasEvent;
import org.yaml.snakeyaml.events.MappingStartEvent;
import org.yaml.snakeyaml.events.SequenceStartEvent;

class ScenarioParser
extends AbstractParser<ScenarioBuilder, ScenarioBuilder> {
    ScenarioParser() {
        this.register("initialSequences", new SequenceParser(ScenarioBuilder::initialSequence));
        this.register("sequences", new SequenceParser(ScenarioBuilder::sequence));
        this.register("orderedSequences", new OrderedSequenceParser());
        this.register("intVars", new VarParser(ScenarioBuilder::intVar));
        this.register("objectVars", new VarParser(ScenarioBuilder::objectVar));
        this.register("maxSequences", new PropertyParser.Int<ScenarioBuilder>(ScenarioBuilder::maxSequences));
        this.register("maxRequests", new PropertyParser.Int<ScenarioBuilder>(ScenarioBuilder::maxRequests));
    }

    @Override
    public void parse(Context ctx, ScenarioBuilder target) throws ParserException {
        if (!ctx.hasNext()) {
            throw ctx.noMoreEvents(MappingStartEvent.class, AliasEvent.class, SequenceStartEvent.class);
        }
        if (ctx.peek() instanceof SequenceStartEvent) {
            new OrderedSequenceParser().parse(ctx, target);
        } else {
            ctx.parseAliased(ScenarioBuilder.class, target, this::callSubBuilders);
        }
    }
}

