/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.parser;

import io.hyperfoil.api.config.ScenarioBuilder;
import io.hyperfoil.api.config.SequenceBuilder;
import io.hyperfoil.core.parser.Context;
import io.hyperfoil.core.parser.Parser;
import io.hyperfoil.core.parser.ParserException;
import io.hyperfoil.core.parser.StepParser;
import java.util.function.BiFunction;
import org.yaml.snakeyaml.events.AliasEvent;
import org.yaml.snakeyaml.events.Event;
import org.yaml.snakeyaml.events.MappingEndEvent;
import org.yaml.snakeyaml.events.MappingStartEvent;
import org.yaml.snakeyaml.events.ScalarEvent;
import org.yaml.snakeyaml.events.SequenceStartEvent;

class SequenceParser
implements Parser<ScenarioBuilder> {
    private final BiFunction<ScenarioBuilder, String, SequenceBuilder> builderFunction;

    SequenceParser(BiFunction<ScenarioBuilder, String, SequenceBuilder> builderFunction) {
        this.builderFunction = builderFunction;
    }

    @Override
    public void parse(Context ctx, ScenarioBuilder target) throws ParserException {
        ctx.parseList(target, this::parseSequence);
    }

    private void parseSequence(Context ctx, ScenarioBuilder target) throws ParserException {
        ctx.expectEvent(MappingStartEvent.class);
        ScalarEvent sequenceNameEvent = ctx.expectEvent(ScalarEvent.class);
        SequenceBuilder sequenceBuilder = this.builderFunction.apply(target, sequenceNameEvent.getValue());
        SequenceParser.parseSequence(ctx, sequenceBuilder);
        ctx.expectEvent(MappingEndEvent.class);
    }

    static void parseSequence(Context ctx, SequenceBuilder sequenceBuilder) throws ParserException {
        Event event = ctx.peek();
        if (event instanceof SequenceStartEvent) {
            ctx.parseList(sequenceBuilder, StepParser.instance());
        } else {
            if (event instanceof ScalarEvent) {
                String value = ((ScalarEvent)event).getValue();
                if (value == null || value.isEmpty()) {
                    throw new ParserException(event, "The sequence must not be empty.");
                }
                throw new ParserException(event, "Expected sequence of steps but got '" + value + "'");
            }
            if (event instanceof AliasEvent) {
                String anchor = ((AliasEvent)event).getAnchor();
                SequenceBuilder sequence = ctx.getAnchor(event, anchor, SequenceBuilder.class);
                sequenceBuilder.readFrom(sequence);
                ctx.consumePeeked(event);
            } else {
                throw ctx.unexpectedEvent(event);
            }
        }
    }
}

