/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.print;

import io.hyperfoil.api.config.Visitor;
import io.hyperfoil.api.session.Access;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;

public class ReflectionAcceptor {
    private static final Class<?>[] BOXING_TYPES = new Class[]{Boolean.class, Integer.class, Long.class, Double.class, Byte.class, Character.class, Short.class, Float.class, Void.class};

    public static int accept(Object target, Visitor visitor) {
        int written = 0;
        for (Field f : ReflectionAcceptor.getAllFields(target)) {
            f.setAccessible(true);
            try {
                Visitor.Invoke invoke = f.getAnnotation(Visitor.Invoke.class);
                if (invoke == null) {
                    Object value = f.get(target);
                    if (!visitor.visit(f.getName(), value, f.getGenericType())) continue;
                    ++written;
                    continue;
                }
                Method method = f.getDeclaringClass().getMethod(invoke.method(), new Class[0]);
                method.setAccessible(true);
                Object value = method.invoke(target, new Object[0]);
                if (!visitor.visit(f.getName(), value, method.getGenericReturnType())) continue;
                ++written;
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return written;
    }

    private static List<Field> getAllFields(Object target) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class<?> cls = target.getClass(); cls != null && cls != Object.class; cls = cls.getSuperclass()) {
            for (Field f : cls.getDeclaredFields()) {
                if (Modifier.isStatic(f.getModifiers()) || f.isSynthetic() || f.isAnnotationPresent(Visitor.Ignore.class) || "parent".equals(f.getName())) continue;
                fields.add(f);
            }
        }
        fields.sort(Comparator.comparing(Field::getName));
        return fields;
    }

    public static boolean isScalar(Object value) {
        if (value == null) {
            return true;
        }
        if (value instanceof CharSequence || value instanceof Access) {
            return true;
        }
        Class<?> cls = value.getClass();
        return cls.isPrimitive() || cls.isEnum() || cls.getSuperclass() != null && cls.getSuperclass().isEnum() || Stream.of(BOXING_TYPES).anyMatch(c -> c == cls);
    }
}

