/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.session;

import io.hyperfoil.api.session.Access;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.session.IntVar;
import io.hyperfoil.core.session.ObjectVar;
import io.hyperfoil.core.session.SessionImpl;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.lang.reflect.Array;
import java.util.List;

class SequenceScopedAccess
implements Access {
    private static final Logger log = LoggerFactory.getLogger(SequenceScopedAccess.class);
    private static final boolean trace = log.isTraceEnabled();
    private final Object key;
    private final int maxConcurrency;

    SequenceScopedAccess(Object key, int maxConcurrency) {
        this.key = key;
        this.maxConcurrency = maxConcurrency;
    }

    @Override
    public void declareObject(Session session) {
        SessionImpl impl = (SessionImpl)session;
        impl.declareObject(this.key);
        ObjectVar var = (ObjectVar)impl.getVar(this.key);
        if (!var.isSet() && var.objectValue(session) == null) {
            var.set(ObjectVar.newArray(session, this.maxConcurrency));
        }
    }

    @Override
    public void declareInt(Session session) {
        SessionImpl impl = (SessionImpl)session;
        impl.declareObject(this.key);
        ObjectVar var = (ObjectVar)impl.getVar(this.key);
        if (!var.isSet() && var.objectValue(session) == null) {
            var.set(IntVar.newArray(session, this.maxConcurrency));
        }
    }

    @Override
    public boolean isSet(Session session) {
        SessionImpl impl = (SessionImpl)session;
        Object var = impl.getVar(this.key);
        if (!var.isSet()) {
            return false;
        }
        Object o = this.getItemFromVar(session, (Session.Var)var);
        if (o instanceof Session.Var) {
            return ((Session.Var)o).isSet();
        }
        int index = session.currentSequence().index();
        throw new IllegalStateException("Variable " + this.key + "[" + index + "] should contain Session.Var but contains " + o);
    }

    @Override
    public Object getObject(Session session) {
        Object o = this.getItem(session);
        if (o instanceof ObjectVar) {
            ObjectVar ov = (ObjectVar)o;
            if (!ov.isSet()) {
                int index = session.currentSequence().index();
                throw new IllegalStateException("Variable " + this.key + "[" + index + "] was not set yet!");
            }
            return ov.objectValue(session);
        }
        int index = session.currentSequence().index();
        throw new IllegalStateException("Variable " + this.key + "[" + index + "] should contain ObjectVar but contains " + o);
    }

    @Override
    public void setObject(Session session, Object value) {
        Session.Var var = this.getVarToSet(session);
        Object o = this.getItemFromVar(session, var);
        if (o instanceof ObjectVar) {
            if (trace) {
                log.trace((Object)"#{} {}[{}] <- {}", new Object[]{session.uniqueId(), this.key, session.currentSequence().index(), value});
            }
        } else {
            int index = session.currentSequence().index();
            throw new IllegalStateException("Variable " + this.key + "[" + index + "] should contain ObjectVar but contains " + o);
        }
        ((ObjectVar)o).set(value);
    }

    @Override
    public int getInt(Session session) {
        Object o = this.getItem(session);
        if (o instanceof IntVar) {
            IntVar iv = (IntVar)o;
            if (!iv.isSet()) {
                int index = session.currentSequence().index();
                throw new IllegalStateException("Variable " + this.key + "[" + index + "] was not set yet!");
            }
            return iv.intValue(session);
        }
        int index = session.currentSequence().index();
        throw new IllegalStateException("Variable " + this.key + "[" + index + "] should contain IntVar but contains " + o);
    }

    @Override
    public void setInt(Session session, int value) {
        Session.Var var = this.getVarToSet(session);
        Object o = this.getItemFromVar(session, var);
        if (o instanceof IntVar) {
            if (trace) {
                log.trace((Object)"#{} {}[{}] <- {}", new Object[]{session.uniqueId(), this.key, session.currentSequence().index(), value});
            }
        } else {
            int index = session.currentSequence().index();
            throw new IllegalStateException("Variable " + this.key + "[" + index + "] should contain IntVar but contains " + o);
        }
        ((IntVar)o).set(value);
    }

    private Session.Var getVarToSet(Session session) {
        SessionImpl impl = (SessionImpl)session;
        Object var = impl.getVar(this.key);
        if (!(var instanceof ObjectVar)) {
            throw new IllegalStateException("Variable " + this.key + " does not hold an object variable (cannot hold array).");
        }
        ((ObjectVar)var).set = true;
        return var;
    }

    @Override
    public Session.Var getVar(Session session) {
        Object o = this.getItem(session);
        if (o instanceof Session.Var) {
            return (Session.Var)o;
        }
        int index = session.currentSequence().index();
        throw new IllegalStateException("Variable " + this.key + "[" + index + "] should contain Session.Var but contains " + o);
    }

    @Override
    public int addToInt(Session session, int delta) {
        Object o = this.getItem(session);
        if (o instanceof IntVar) {
            IntVar iv = (IntVar)o;
            if (!iv.isSet()) {
                int index = session.currentSequence().index();
                throw new IllegalStateException("Variable " + this.key + "[" + index + "] was not set yet!");
            }
            int prev = iv.intValue(session);
            if (trace) {
                log.trace((Object)"#{} {}[{}] += {}", new Object[]{session.uniqueId(), this.key, session.currentSequence().index(), delta});
            }
            iv.add(delta);
            return prev;
        }
        int index = session.currentSequence().index();
        throw new IllegalStateException("Variable " + this.key + "[" + index + "] should contain IntVar but contains " + o);
    }

    @Override
    public Object activate(Session session) {
        Object o = this.getItem(session);
        if (o instanceof ObjectVar) {
            ObjectVar ov = (ObjectVar)o;
            if (trace) {
                log.trace((Object)"#{} activate {}[{}]", new Object[]{session.uniqueId(), this.key, session.currentSequence().index()});
            }
            ov.set = true;
            return ov.objectValue(session);
        }
        int index = session.currentSequence().index();
        throw new IllegalStateException("Variable " + this.key + "[" + index + "] should contain ObjectVar but contains " + o);
    }

    @Override
    public void unset(Session session) {
        Session.Var var = this.getVarToSet(session);
        Object o = this.getItemFromVar(session, var);
        if (o instanceof Session.Var) {
            if (trace) {
                log.trace((Object)"#{} unset {}[{}] <- {}", new Object[]{session.uniqueId(), this.key, session.currentSequence().index()});
            }
        } else {
            int index = session.currentSequence().index();
            throw new IllegalStateException("Variable " + this.key + "[" + index + "] should contain Session.Var but contains " + o);
        }
        ((Session.Var)o).unset();
    }

    @Override
    public boolean isSequenceScoped() {
        return true;
    }

    public String toString() {
        return this.key + "[.]";
    }

    private Object getItem(Session session) {
        SessionImpl impl = (SessionImpl)session;
        Object var = impl.getVar(this.key);
        if (!var.isSet()) {
            throw new IllegalStateException("Variable " + this.key + " is not set!");
        }
        return this.getItemFromVar(session, (Session.Var)var);
    }

    private Object getItemFromVar(Session session, Session.Var var) {
        Object collection = var.objectValue(session);
        if (collection == null) {
            throw new IllegalStateException("Variable " + this.key + " is null!");
        }
        int index = session.currentSequence().index();
        if (index >= this.maxConcurrency) {
            throw new IllegalStateException("Variable " + this.key + " reads item at index " + index + " but the maximum concurrency is " + this.maxConcurrency);
        }
        if (collection.getClass().isArray()) {
            return Array.get(collection, index);
        }
        if (collection instanceof List) {
            return ((List)collection).get(index);
        }
        throw new IllegalStateException("Unknown type to access by index: " + collection);
    }
}

