/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.session;

import io.hyperfoil.api.config.Benchmark;
import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.Locator;
import io.hyperfoil.api.config.Phase;
import io.hyperfoil.api.config.Scenario;
import io.hyperfoil.api.config.Sequence;
import io.hyperfoil.api.session.Access;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.impl.PhaseInstanceImpl;
import io.hyperfoil.core.session.SequenceScopedAccess;
import io.hyperfoil.core.session.SessionImpl;
import io.hyperfoil.core.session.SimpleAccess;
import io.hyperfoil.core.session.SpecialAccess;
import io.hyperfoil.core.util.Unique;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.ImmediateEventExecutor;
import java.util.Collection;
import java.util.Collections;

public final class SessionFactory {
    private static final SpecialAccess[] SPECIAL = new SpecialAccess[]{new SpecialAccess.Int("hyperfoil.phase.iteration", s -> s.phase().iteration)};

    public static Session create(Scenario scenario, int agentId, int executorId, int uniqueId) {
        return new SessionImpl(scenario, agentId, executorId, uniqueId);
    }

    public static Session forTesting() {
        return SessionFactory.forTesting(new String[0], new String[0]);
    }

    public static Session forTesting(String[] objectVars, String[] intVars) {
        Scenario dummyScenario = new Scenario(new Sequence[0], new Sequence[0], objectVars, intVars, 16, 16);
        SessionImpl session = new SessionImpl(dummyScenario, 0, 0, 0);
        Phase dummyPhase = new Phase(() -> Benchmark.forTesting(), 0, 0, "dummy", dummyScenario, 0L, (Collection)Collections.emptyList(), (Collection)Collections.emptyList(), (Collection)Collections.emptyList(), 0L, -1L, null){

            @Override
            public String description() {
                return "dummy";
            }
        };
        session.resetPhase(new PhaseInstanceImpl<Phase>(dummyPhase, 0){

            @Override
            public void proceed(EventExecutorGroup executorGroup) {
            }

            @Override
            public void reserveSessions() {
            }
        });
        session.attach((EventExecutor)ImmediateEventExecutor.INSTANCE, null, null);
        session.reserve(dummyScenario);
        return session;
    }

    private SessionFactory() {
    }

    public static Access access(Object key) {
        assert (Locator.current() != null);
        if (key == null) {
            return null;
        }
        if (key instanceof String) {
            String expression = (String)key;
            if (expression.endsWith("[.]")) {
                return SessionFactory.sequenceScopedAccess(expression.substring(0, expression.length() - 3));
            }
            if (expression.startsWith("hyperfoil.")) {
                for (SpecialAccess access : SPECIAL) {
                    if (!access.name.equals(expression)) continue;
                    return access;
                }
                throw new BenchmarkDefinitionException("No special variable " + expression);
            }
            return new SimpleAccess(key);
        }
        if (key instanceof Unique) {
            if (((Unique)key).isSequenceScoped()) {
                return SessionFactory.sequenceScopedAccess(key);
            }
            return new SimpleAccess(key);
        }
        return new SimpleAccess(key);
    }

    public static Access sequenceScopedAccess(Object key) {
        Locator locator = Locator.current();
        assert (locator != null);
        int maxConcurrency = locator.sequence().rootSequence().concurrency();
        if (maxConcurrency <= 0) {
            throw new BenchmarkDefinitionException(locator.step() + " in sequence " + locator.sequence().name() + " uses sequence-scoped access but this sequence is not declared as concurrent.");
        }
        return new SequenceScopedAccess(key, maxConcurrency);
    }
}

