/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.session;

import io.hyperfoil.api.collection.LimitedPool;
import io.hyperfoil.api.config.Benchmark;
import io.hyperfoil.api.config.Phase;
import io.hyperfoil.api.config.Scenario;
import io.hyperfoil.api.config.Sequence;
import io.hyperfoil.api.connection.Request;
import io.hyperfoil.api.session.PhaseInstance;
import io.hyperfoil.api.session.SequenceInstance;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.api.session.SessionStopException;
import io.hyperfoil.api.session.SharedData;
import io.hyperfoil.api.statistics.SessionStatistics;
import io.hyperfoil.api.statistics.Statistics;
import io.hyperfoil.core.session.IntVar;
import io.hyperfoil.core.session.ObjectVar;
import io.hyperfoil.core.util.Util;
import io.netty.util.concurrent.EventExecutor;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Supplier;

class SessionImpl
implements Session {
    private static final Logger log = LoggerFactory.getLogger(SessionImpl.class);
    private static final boolean trace = log.isTraceEnabled();
    private final Map<Object, Session.Var> vars = new HashMap<Object, Session.Var>();
    private final Map<Session.ResourceKey<?>, Object> resources = new HashMap();
    private final List<Session.Var> allVars = new ArrayList<Session.Var>();
    private final List<Session.Resource> allResources = new ArrayList<Session.Resource>();
    private final LimitedPool<SequenceInstance> sequencePool;
    private final SequenceInstance[] runningSequences;
    private final BitSet usedSequences;
    private final Consumer<SequenceInstance> releaseSequence = this::releaseSequence;
    private PhaseInstance phase;
    private int lastRunningSequence = -1;
    private SequenceInstance currentSequence;
    private Request currentRequest;
    private boolean scheduled;
    private EventExecutor executor;
    private SharedData sharedData;
    private SessionStatistics statistics;
    private final int agentId;
    private final int threadId;
    private final int uniqueId;
    private final Callable<Void> deferredStart = this::deferredStart;

    SessionImpl(Scenario scenario, int agentId, int threadId, int uniqueId) {
        this.sequencePool = new LimitedPool<SequenceInstance>(scenario.maxSequences(), SequenceInstance::new);
        this.agentId = agentId;
        this.threadId = threadId;
        this.runningSequences = new SequenceInstance[scenario.maxSequences()];
        this.usedSequences = new BitSet(scenario.sumConcurrency());
        this.uniqueId = uniqueId;
    }

    @Override
    public void reserve(Scenario scenario) {
        Sequence[] sequences = scenario.sequences();
        for (int i = 0; i < sequences.length; ++i) {
            Sequence sequence = sequences[i];
            this.currentSequence(this.sequencePool.acquire().reset(sequence, 0, null, null));
            sequence.reserve(this);
            this.sequencePool.release(this.currentSequence);
            this.currentSequence = null;
        }
        for (String var : scenario.objectVars()) {
            this.declareObject(var);
        }
        for (String var : scenario.intVars()) {
            this.declareInt(var);
        }
    }

    @Override
    public int uniqueId() {
        return this.uniqueId;
    }

    @Override
    public int agentThreadId() {
        return this.threadId;
    }

    @Override
    public int agentThreads() {
        return this.phase.agentThreads();
    }

    @Override
    public int globalThreadId() {
        return this.phase.agentFirstThreadId() + this.threadId;
    }

    @Override
    public int globalThreads() {
        Benchmark benchmark = this.phase.definition().benchmark();
        return benchmark.totalThreads();
    }

    @Override
    public int agentId() {
        return this.agentId;
    }

    @Override
    public EventExecutor executor() {
        return this.executor;
    }

    @Override
    public SharedData sharedData() {
        return this.sharedData;
    }

    @Override
    public Phase phase() {
        return this.phase != null ? this.phase.definition() : null;
    }

    @Override
    public long phaseStartTimestamp() {
        return this.phase.absoluteStartTime();
    }

    void registerVar(Session.Var var) {
        this.allVars.add(var);
    }

    public Session declareObject(Object key) {
        if (!this.vars.containsKey(key)) {
            ObjectVar var = new ObjectVar(this);
            this.vars.put(key, var);
        }
        return this;
    }

    public Object getObject(Object key) {
        return ((ObjectVar)this.requireSet(key)).get();
    }

    public Session setObject(Object key, Object value) {
        if (trace) {
            log.trace((Object)"#{} {} <- {}", new Object[]{this.uniqueId, key, Util.prettyPrintObject(value)});
        }
        ObjectVar var = (ObjectVar)this.getVar(key);
        var.value = value;
        var.set = true;
        return this;
    }

    public Session declareInt(Object key) {
        if (!this.vars.containsKey(key)) {
            IntVar var = new IntVar(this);
            this.vars.put(key, var);
        }
        return this;
    }

    public int getInt(Object key) {
        IntVar var = (IntVar)this.requireSet(key);
        return var.get();
    }

    public void setInt(Object key, int value) {
        if (trace) {
            log.trace((Object)"#{} {} <- {}", new Object[]{this.uniqueId, key, value});
        }
        ((IntVar)this.getVar(key)).set(value);
    }

    public int addToInt(Object key, int delta) {
        IntVar var = (IntVar)this.requireSet(key);
        int prev = var.get();
        if (trace) {
            log.trace((Object)"#{} {} <- {}", new Object[]{this.uniqueId, key, prev + delta});
        }
        var.set(prev + delta);
        return prev;
    }

    @Override
    public <R extends Session.Resource> void declareResource(Session.ResourceKey<R> key, Supplier<R> resourceSupplier) {
        this.declareResource(key, resourceSupplier, false);
    }

    @Override
    public <R extends Session.Resource> void declareResource(Session.ResourceKey<R> key, Supplier<R> resourceSupplier, boolean singleton) {
        int concurrency;
        if (this.resources.containsKey(key)) {
            return;
        }
        int n = concurrency = this.currentSequence == null ? 0 : this.currentSequence.definition().concurrency();
        if (!singleton && concurrency > 0) {
            Session.Resource[] array = new Session.Resource[concurrency];
            for (int i = 0; i < concurrency; ++i) {
                Session.Resource resource;
                array[i] = resource = (Session.Resource)resourceSupplier.get();
                this.allResources.add(resource);
            }
            this.resources.put(key, array);
        } else {
            Session.Resource resource = (Session.Resource)resourceSupplier.get();
            this.resources.put(key, resource);
            this.allResources.add(resource);
        }
    }

    @Override
    public <R extends Session.Resource> void declareSingletonResource(Session.ResourceKey<R> key, R resource) {
        if (this.resources.containsKey(key)) {
            return;
        }
        this.resources.put(key, resource);
        this.allResources.add(resource);
    }

    @Override
    public <R extends Session.Resource> R getResource(Session.ResourceKey<R> key) {
        Object res = this.resources.get(key);
        if (res == null) {
            return null;
        }
        if (res instanceof Session.Resource[]) {
            Session.Resource[] array = (Session.Resource[])res;
            return (R)array[this.currentSequence.index()];
        }
        return (R)((Session.Resource)res);
    }

    public <V extends Session.Var> V getVar(Object key) {
        Session.Var var = this.vars.get(key);
        if (var == null) {
            throw new IllegalStateException("Variable " + key + " was not defined!");
        }
        return (V)var;
    }

    private <V extends Session.Var> V requireSet(Object key) {
        Session.Var var = this.vars.get(key);
        if (var == null) {
            throw new IllegalStateException("Variable " + key + " was not defined!");
        }
        if (!var.isSet()) {
            throw new IllegalStateException("Variable " + key + " was not set yet!");
        }
        return (V)var;
    }

    @Override
    public Void call() {
        block3: {
            this.scheduled = false;
            try {
                this.runSession();
            }
            catch (SessionStopException e) {
                log.trace((Object)"#{} Session was stopped.", new Object[]{this.uniqueId});
            }
            catch (Throwable t) {
                log.error((Object)"#{} Uncaught error", t, new Object[]{this.uniqueId});
                if (this.phase == null) break block3;
                this.phase.fail(t);
            }
        }
        return null;
    }

    public void runSession() {
        if (this.phase.status() == PhaseInstance.Status.TERMINATED) {
            if (trace) {
                log.trace((Object)"#{} Phase is terminated", new Object[]{this.uniqueId});
            }
            return;
        }
        if (this.lastRunningSequence < 0) {
            if (trace) {
                log.trace((Object)"#{} No sequences to run, ignoring.", new Object[]{this.uniqueId});
            }
            return;
        }
        if (trace) {
            log.trace((Object)"#{} Run ({} runnning sequences)", new Object[]{this.uniqueId, this.lastRunningSequence + 1});
        }
        int lastProgressedSequence = -1;
        while (this.lastRunningSequence >= 0) {
            boolean progressed = false;
            for (int i = 0; i <= this.lastRunningSequence; ++i) {
                if (this.phase.status() == PhaseInstance.Status.TERMINATING) {
                    if (trace) {
                        log.trace((Object)"#{} Phase {} is terminating", new Object[]{this.uniqueId, this.phase.definition().name()});
                    }
                    this.stop();
                    return;
                }
                if (lastProgressedSequence == i) break;
                SequenceInstance sequence = this.runningSequences[i];
                if (sequence == null || !sequence.progress(this)) continue;
                progressed = true;
                lastProgressedSequence = i;
                if (!sequence.isCompleted()) continue;
                if (trace) {
                    log.trace((Object)"#{} Completed {}({})", new Object[]{this.uniqueId, sequence, sequence.index()});
                }
                if (this.lastRunningSequence == -1) {
                    log.trace((Object)"#{} was stopped.");
                    return;
                }
                sequence.decRefCnt(this);
                if (i >= this.lastRunningSequence) {
                    this.runningSequences[i] = null;
                } else {
                    this.runningSequences[i] = this.runningSequences[this.lastRunningSequence];
                    this.runningSequences[this.lastRunningSequence] = null;
                }
                --this.lastRunningSequence;
                lastProgressedSequence = -1;
            }
            if (progressed || this.lastRunningSequence < 0) continue;
            if (trace) {
                log.trace((Object)"#{} ({}) no progress, not finished.", new Object[]{this.uniqueId, this.phase.definition().name()});
            }
            return;
        }
        if (trace) {
            log.trace((Object)"#{} Session finished", new Object[]{this.uniqueId});
        }
        this.reset();
        this.phase.notifyFinished(this);
    }

    private void releaseSequence(SequenceInstance sequence) {
        this.usedSequences.clear(sequence.definition().offset() + sequence.index());
        this.sequencePool.release(sequence);
    }

    @Override
    public void currentSequence(SequenceInstance current) {
        if (trace) {
            log.trace((Object)"#{} Changing sequence {} -> {}", new Object[]{this.uniqueId, this.currentSequence, current});
        }
        this.currentSequence = current;
    }

    @Override
    public SequenceInstance currentSequence() {
        return this.currentSequence;
    }

    @Override
    public void attach(EventExecutor executor, SharedData sharedData, SessionStatistics statistics) {
        assert (this.executor == null);
        this.executor = executor;
        this.sharedData = sharedData;
        this.statistics = statistics;
    }

    @Override
    public void start(PhaseInstance phase) {
        if (trace) {
            log.trace((Object)"#{} Session starting in {}", new Object[]{this.uniqueId, phase.definition().name});
        }
        this.resetPhase(phase);
        this.executor.submit(this.deferredStart);
    }

    private Void deferredStart() {
        for (Sequence sequence : this.phase.definition().scenario().initialSequences()) {
            this.startSequence(sequence, false, Session.ConcurrencyPolicy.FAIL);
        }
        this.call();
        return null;
    }

    @Override
    public SequenceInstance startSequence(String name, boolean forceSameIndex, Session.ConcurrencyPolicy policy) {
        return this.startSequence(this.phase.definition().scenario().sequence(name), forceSameIndex, policy);
    }

    private SequenceInstance startSequence(Sequence sequence, boolean forceSameIndex, Session.ConcurrencyPolicy policy) {
        int index = 0;
        if (forceSameIndex) {
            if (this.currentSequence == null) {
                this.fail(new IllegalStateException("Current sequence is not set!"));
            } else if (sequence.concurrency() != this.currentSequence.definition().concurrency()) {
                this.fail(new IllegalArgumentException("Sequence '" + sequence.name() + "' does not have the same concurrency factor (" + sequence.concurrency() + ") as the spawning sequence '" + this.currentSequence.definition().name() + "' (" + this.currentSequence.definition().concurrency() + ")"));
            }
            index = this.currentSequence.index();
        }
        SequenceInstance instance = this.sequencePool.acquire();
        while (true) {
            if (sequence.concurrency() == 0) {
                if (index >= 1) {
                    log.error((Object)"Cannot start sequence {} as it has already started and it is not marked as concurrent", new Object[]{sequence.name()});
                    if (sequence == this.currentSequence.definition()) {
                        log.info((Object)"Hint: maybe you intended only to restart the current sequence?");
                    }
                    this.sequencePool.release(instance);
                    this.fail(new IllegalStateException("Sequence is not concurrent"));
                }
            } else if (index >= sequence.concurrency()) {
                if (instance != null) {
                    this.sequencePool.release(instance);
                }
                if (policy == Session.ConcurrencyPolicy.WARN) {
                    log.warn((Object)"Cannot start sequence {}, exceeded maximum concurrency ({})", new Object[]{sequence.name(), sequence.concurrency()});
                } else {
                    log.error((Object)"Cannot start sequence {}, exceeded maximum concurrency ({})", new Object[]{sequence.name(), sequence.concurrency()});
                    this.fail(new IllegalStateException("Concurrency limit exceeded"));
                }
                return null;
            }
            if (!this.usedSequences.get(sequence.offset() + index)) break;
            if (forceSameIndex) {
                if (policy == Session.ConcurrencyPolicy.WARN) {
                    log.warn((Object)"Cannot start sequence {} with index {} as it is already executing.", new Object[]{sequence.name(), index});
                } else {
                    log.error((Object)"Cannot start sequence {} with index {} as it is already executing.", new Object[]{sequence.name(), index});
                    this.fail(new IllegalArgumentException("Cannot start sequence with forced index."));
                }
            }
            ++index;
        }
        if (instance == null) {
            log.error((Object)"Cannot instantiate sequence {}, no free instances.", new Object[]{sequence.name()});
            this.fail(new IllegalStateException("No free sequence instances"));
        } else {
            log.trace((Object)"#{} starting sequence {}({})", new Object[]{this.uniqueId(), sequence.name(), index});
            this.usedSequences.set(sequence.offset() + index);
            instance.reset(sequence, index, sequence.steps(), this.releaseSequence);
            if (this.lastRunningSequence >= this.runningSequences.length - 1) {
                throw new IllegalStateException("Maximum number of scheduled sequences exceeded!");
            }
            ++this.lastRunningSequence;
            assert (this.runningSequences[this.lastRunningSequence] == null);
            this.runningSequences[this.lastRunningSequence] = instance;
        }
        return instance;
    }

    @Override
    public void proceed() {
        if (!this.scheduled) {
            this.scheduled = true;
            this.executor.submit((Callable)this);
        }
    }

    @Override
    public Statistics statistics(int stepId, String name) {
        return this.statistics.getOrCreate(this.phase.definition(), stepId, name, this.phase.absoluteStartTime());
    }

    @Override
    public void pruneStats(Phase phase) {
        this.statistics.prune(phase);
    }

    @Override
    public void reset() {
        int i;
        for (i = 0; i < this.allVars.size(); ++i) {
            this.allVars.get(i).unset();
        }
        for (i = 0; i < this.allResources.size(); ++i) {
            Session.Resource r = this.allResources.get(i);
            r.onSessionReset(this);
        }
        assert (this.usedSequences.isEmpty());
        assert (this.sequencePool.isFull());
    }

    public void resetPhase(PhaseInstance newPhase) {
        if (this.phase == newPhase) {
            return;
        }
        assert (this.phase == null || newPhase.definition().scenario() == this.phase.definition().scenario());
        assert (this.phase == null || newPhase.definition().sharedResources.equals(this.phase.definition().sharedResources));
        assert (this.phase == null || this.phase.status().isTerminated());
        this.phase = newPhase;
    }

    @Override
    public void stop() {
        for (int i = 0; i <= this.lastRunningSequence; ++i) {
            SequenceInstance sequence = this.runningSequences[i];
            sequence.decRefCnt(this);
            this.runningSequences[i] = null;
        }
        this.lastRunningSequence = -1;
        this.currentSequence = null;
        if (trace) {
            log.trace((Object)"#{} Session stopped.", new Object[]{this.uniqueId});
        }
        this.reset();
        this.phase.notifyFinished(this);
        throw SessionStopException.INSTANCE;
    }

    @Override
    public void fail(Throwable t) {
        try {
            this.stop();
        }
        finally {
            this.phase.fail(t);
        }
    }

    @Override
    public boolean isActive() {
        return this.lastRunningSequence >= 0;
    }

    @Override
    public Request currentRequest() {
        return this.currentRequest;
    }

    @Override
    public void currentRequest(Request request) {
        this.currentRequest = request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("#").append(this.uniqueId).append(" (").append(this.phase != null ? this.phase.definition().name : null).append(") ").append(this.lastRunningSequence + 1).append(" sequences:");
        for (int i = 0; i <= this.lastRunningSequence; ++i) {
            sb.append(' ');
            this.runningSequences[i].appendTo(sb);
        }
        return sb.toString();
    }
}

