/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.session;

import io.hyperfoil.api.session.Access;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.session.ObjectVar;
import io.hyperfoil.core.session.SessionImpl;
import java.util.Objects;

class SimpleAccess
implements Access {
    private final Object key;

    SimpleAccess(Object key) {
        this.key = Objects.requireNonNull(key);
    }

    @Override
    public void declareObject(Session session) {
        SessionImpl impl = (SessionImpl)session;
        impl.declareObject(this.key);
    }

    @Override
    public void declareInt(Session session) {
        SessionImpl impl = (SessionImpl)session;
        impl.declareInt(this.key);
    }

    @Override
    public boolean isSet(Session session) {
        SessionImpl impl = (SessionImpl)session;
        return impl.getVar(this.key).isSet();
    }

    @Override
    public Object getObject(Session session) {
        SessionImpl impl = (SessionImpl)session;
        return impl.getObject(this.key);
    }

    @Override
    public void setObject(Session session, Object value) {
        SessionImpl impl = (SessionImpl)session;
        impl.setObject(this.key, value);
    }

    @Override
    public int getInt(Session session) {
        SessionImpl impl = (SessionImpl)session;
        return impl.getInt(this.key);
    }

    @Override
    public void setInt(Session session, int value) {
        SessionImpl impl = (SessionImpl)session;
        impl.setInt(this.key, value);
    }

    @Override
    public Session.Var getVar(Session session) {
        SessionImpl impl = (SessionImpl)session;
        return impl.getVar(this.key);
    }

    @Override
    public int addToInt(Session session, int delta) {
        SessionImpl impl = (SessionImpl)session;
        return impl.addToInt(this.key, delta);
    }

    @Override
    public Object activate(Session session) {
        SessionImpl impl = (SessionImpl)session;
        ObjectVar var = (ObjectVar)impl.getVar(this.key);
        var.set = true;
        return var.get();
    }

    @Override
    public void unset(Session session) {
        SessionImpl impl = (SessionImpl)session;
        impl.getVar(this.key).unset();
    }

    @Override
    public boolean isSequenceScoped() {
        return false;
    }

    public String toString() {
        return this.key.toString();
    }
}

