/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.steps;

import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.InitFromParam;
import io.hyperfoil.api.config.Name;
import io.hyperfoil.api.session.Access;
import io.hyperfoil.api.session.Action;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.session.SessionFactory;

public class AddToIntAction
implements Action {
    protected final Access var;
    protected final int value;
    protected final Integer orElseSetTo;

    public AddToIntAction(Access var, int value, Integer orElseSetTo) {
        this.var = var;
        this.value = value;
        this.orElseSetTo = orElseSetTo;
    }

    @Override
    public void run(Session session) {
        if (this.orElseSetTo != null && !this.var.isSet(session)) {
            this.var.setInt(session, this.orElseSetTo);
        } else {
            int prev = this.var.getInt(session);
            this.var.setInt(session, prev + this.value);
        }
    }

    @Name(value="addToInt")
    public static class Builder
    implements InitFromParam<Builder>,
    Action.Builder {
        private String var;
        private int value;
        private Integer orElseSetTo;

        @Override
        public Builder init(String param) {
            if ((param = param.trim()).endsWith("++")) {
                this.var = param.substring(0, param.length() - 2).trim();
                this.value = 1;
            } else if (param.endsWith("--")) {
                this.var = param.substring(0, param.length() - 2).trim();
                this.value = -1;
            } else if (param.contains("+=")) {
                int plusEqualsIndex = param.indexOf("+=");
                this.var = param.substring(0, plusEqualsIndex).trim();
                this.value = Integer.parseInt(param.substring(plusEqualsIndex + 2).trim());
            } else if (param.contains("-=")) {
                int minusEqualsIndex = param.indexOf("-=");
                this.var = param.substring(0, minusEqualsIndex).trim();
                this.value = -Integer.parseInt(param.substring(minusEqualsIndex + 2).trim());
            } else {
                throw new BenchmarkDefinitionException("Accepting one of: var++, var--, var += value, var -= value");
            }
            return this;
        }

        public Builder var(String var) {
            this.var = var;
            return this;
        }

        public Builder value(int value) {
            this.value = value;
            return this;
        }

        public Builder orElseSetTo(int value) {
            this.orElseSetTo = value;
            return this;
        }

        @Override
        public AddToIntAction build() {
            if (this.var == null || this.var.isEmpty()) {
                throw new BenchmarkDefinitionException("Var must be defined an not empty.");
            }
            if (this.value == 0) {
                throw new BenchmarkDefinitionException("It makes no sense to add 0.");
            }
            return new AddToIntAction(SessionFactory.access(this.var), this.value, this.orElseSetTo);
        }
    }
}

