/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.steps;

import io.hyperfoil.api.config.InitFromParam;
import io.hyperfoil.api.config.Name;
import io.hyperfoil.api.config.Step;
import io.hyperfoil.api.session.Access;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.builders.BaseStepBuilder;
import io.hyperfoil.core.session.SessionFactory;
import io.hyperfoil.core.steps.ScheduleDelayStep;
import java.util.Collections;
import java.util.List;

public class AwaitDelayStep
implements Step {
    private final Access key;

    public AwaitDelayStep(Access key) {
        this.key = key;
    }

    @Override
    public boolean invoke(Session session) {
        ScheduleDelayStep.Timestamp blockedUntil = (ScheduleDelayStep.Timestamp)this.key.getObject(session);
        return System.currentTimeMillis() >= blockedUntil.timestamp;
    }

    @Name(value="awaitDelay")
    public static class Builder
    extends BaseStepBuilder<Builder>
    implements InitFromParam<Builder> {
        private Object key;

        @Override
        public Builder init(String param) {
            return this.key(param);
        }

        public Builder key(String key) {
            this.key = key;
            return this;
        }

        @Override
        public List<Step> build() {
            return Collections.singletonList(new AwaitDelayStep(SessionFactory.access(this.key)));
        }
    }
}

