/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.steps;

import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.Name;
import io.hyperfoil.api.config.Step;
import io.hyperfoil.api.session.Access;
import io.hyperfoil.api.session.ResourceUtilizer;
import io.hyperfoil.api.session.SequenceInstance;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.builders.DependencyStepBuilder;
import io.hyperfoil.core.session.SessionFactory;
import io.hyperfoil.core.steps.DependencyStep;
import java.util.Collections;
import java.util.List;

public class ForeachStep
extends DependencyStep
implements ResourceUtilizer {
    private final Access fromVar;
    private final Access counterVar;
    private final String sequence;

    public ForeachStep(Access[] dependencies, Access fromVar, Access counterVar, String sequence) {
        super(dependencies);
        this.fromVar = fromVar;
        this.counterVar = counterVar;
        this.sequence = sequence;
    }

    @Override
    public boolean invoke(Session session) {
        int i;
        if (!super.invoke(session)) {
            return false;
        }
        Object value = this.fromVar.getObject(session);
        if (!(value instanceof Session.Var[])) {
            throw new IllegalStateException("Variable " + this.fromVar + " does not contain var array: " + value);
        }
        Session.Var[] array = (Session.Var[])value;
        for (i = 0; i < array.length && array[i].isSet(); ++i) {
            SequenceInstance instance = session.startSequence(this.sequence, false, Session.ConcurrencyPolicy.FAIL);
            if (instance.index() == i) continue;
            throw new IllegalStateException("This step assumes that there are no already running instances of " + this.sequence);
        }
        if (this.counterVar != null) {
            this.counterVar.setInt(session, i);
        }
        return true;
    }

    @Override
    public void reserve(Session session) {
        if (this.counterVar != null) {
            this.counterVar.declareInt(session);
        }
    }

    @Name(value="foreach")
    public static class Builder
    extends DependencyStepBuilder<Builder> {
        private String fromVar;
        private String counterVar;
        private String sequence;

        public Builder fromVar(String fromVar) {
            this.fromVar = fromVar;
            this.dependency(fromVar);
            return this;
        }

        public Builder counterVar(String counterVar) {
            this.counterVar = counterVar;
            return this;
        }

        public Builder sequence(String sequence) {
            this.sequence = sequence;
            return this;
        }

        @Override
        public List<Step> build() {
            if (this.sequence == null) {
                throw new BenchmarkDefinitionException("Template sequence must be defined");
            }
            return Collections.singletonList(new ForeachStep(this.dependencies(), SessionFactory.access(this.fromVar), SessionFactory.access(this.counterVar), this.sequence));
        }
    }
}

