/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.steps;

import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.ListBuilder;
import io.hyperfoil.api.config.Name;
import io.hyperfoil.api.config.Step;
import io.hyperfoil.api.session.Access;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.builders.BaseStepBuilder;
import io.hyperfoil.core.session.SessionFactory;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class LogStep
implements Step {
    private static final Logger log = LoggerFactory.getLogger(LogStep.class);
    private final String message;
    private final Access[] vars;

    public LogStep(String message, Access[] vars) {
        this.message = message;
        this.vars = vars;
    }

    @Override
    public boolean invoke(Session session) {
        if (this.vars.length == 0) {
            log.info((Object)this.message);
        } else {
            Object[] objects = new Object[this.vars.length];
            for (int i = 0; i < this.vars.length; ++i) {
                Session.Var var = this.vars[i].getVar(session);
                objects[i] = !var.isSet() ? "<not set>" : (var.type() == Session.VarType.OBJECT ? var.objectValue(session) : (var.type() == Session.VarType.INTEGER ? Integer.valueOf(var.intValue(session)) : "<unknown type>"));
            }
            log.info((Object)this.message, objects);
        }
        return true;
    }

    @Name(value="log")
    public static class Builder
    extends BaseStepBuilder<Builder> {
        String message;
        List<String> vars = new ArrayList<String>();

        public Builder message(String message) {
            this.message = message;
            return this;
        }

        public ListBuilder vars() {
            return this.vars::add;
        }

        public Builder addVar(String var, Void ignored) {
            this.vars.add(var);
            return this;
        }

        @Override
        public List<Step> build() {
            if (this.message == null) {
                throw new BenchmarkDefinitionException("Missing message");
            }
            return Collections.singletonList(new LogStep(this.message, (Access[])this.vars.stream().map(SessionFactory::access).toArray(Access[]::new)));
        }
    }
}

