/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.steps;

import io.hyperfoil.api.config.BaseSequenceBuilder;
import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.Locator;
import io.hyperfoil.api.config.Name;
import io.hyperfoil.api.config.Step;
import io.hyperfoil.api.config.StepBuilder;
import io.hyperfoil.api.session.Access;
import io.hyperfoil.api.session.ResourceUtilizer;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.session.SessionFactory;
import io.hyperfoil.core.steps.SetIntAction;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class LoopStep
implements Step,
ResourceUtilizer {
    private final Access counterVar;
    private final int repeats;

    public LoopStep(Access counterVar, int repeats) {
        this.counterVar = counterVar;
        this.repeats = repeats;
    }

    @Override
    public boolean invoke(Session session) {
        int value = 1 + this.counterVar.addToInt(session, 1);
        if (value < this.repeats) {
            session.currentSequence().restart(session);
        }
        return true;
    }

    @Override
    public void reserve(Session session) {
        this.counterVar.declareInt(session);
    }

    @Name(value="loop")
    public static class Builder
    implements StepBuilder<Builder> {
        private String counterVar;
        private int repeats;
        private final BaseSequenceBuilder steps;

        public Builder() {
            this.steps = null;
        }

        public Builder(BaseSequenceBuilder parent) {
            this.steps = new BaseSequenceBuilder(Objects.requireNonNull(parent)){};
        }

        public Builder counterVar(String counterVar) {
            this.counterVar = counterVar;
            return this;
        }

        public Builder repeats(int repeats) {
            this.repeats = repeats;
            return this;
        }

        @Deprecated
        public Builder sequence(String sequence) {
            throw new BenchmarkDefinitionException("Sequence is not supported anymore; place loop as the first step in a sequence.");
        }

        public BaseSequenceBuilder steps() {
            return this.steps;
        }

        @Override
        public List<Step> build() {
            Locator locator = Locator.current();
            if (locator.sequence().indexOf(this) != 0) {
                throw new BenchmarkDefinitionException("Loop step must be placed as the first step in a sequence.");
            }
            if (this.counterVar == null) {
                throw new BenchmarkDefinitionException("loop.counterVar must be set.");
            }
            if (this.repeats <= 0) {
                throw new BenchmarkDefinitionException("loop.repeats must be > 0");
            }
            if (this.steps.isEmpty()) {
                throw new BenchmarkDefinitionException("The loop does not include any steps. Cannot construct empty loop.");
            }
            Access counter = SessionFactory.access(this.counterVar);
            if (locator.sequence().rootSequence().concurrency() > 0 && !counter.isSequenceScoped()) {
                throw new BenchmarkDefinitionException("In concurrent sequences the counter var should be sequence-scoped.");
            }
            ArrayList<Step> allSteps = new ArrayList<Step>();
            allSteps.add(new StepBuilder.ActionStep(new SetIntAction(counter, 0, true, null)));
            allSteps.addAll(this.steps.buildSteps());
            allSteps.add(new LoopStep(counter, this.repeats));
            return allSteps;
        }
    }
}

