/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.steps;

import io.hyperfoil.api.config.InitFromParam;
import io.hyperfoil.api.config.Name;
import io.hyperfoil.api.config.Step;
import io.hyperfoil.api.config.StepBuilder;
import io.hyperfoil.api.session.SequenceInstance;
import io.hyperfoil.api.session.Session;
import java.util.Collections;
import java.util.List;

public class NextSequenceStep
implements Step {
    private final String name;

    public NextSequenceStep(String name) {
        this.name = name;
    }

    @Override
    public boolean invoke(Session session) {
        SequenceInstance sequence = session.currentSequence();
        if (sequence.definition().name().equals(this.name) && sequence.isLastStep()) {
            sequence.restart(session);
        } else {
            session.startSequence(this.name, false, Session.ConcurrencyPolicy.FAIL);
        }
        return true;
    }

    @Name(value="nextSequence")
    public static class Builder
    implements StepBuilder<Builder>,
    InitFromParam<Builder> {
        private String name;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public List<Step> build() {
            return Collections.singletonList(new NextSequenceStep(this.name));
        }

        @Override
        public Builder init(String param) {
            return this.name(param);
        }
    }
}

