/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.steps;

import io.hyperfoil.api.config.ListBuilder;
import io.hyperfoil.api.config.Visitor;
import io.hyperfoil.function.SerializableBiFunction;
import io.hyperfoil.function.SerializableFunction;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PathMetricSelector
implements ListBuilder,
SerializableBiFunction<String, String, String> {
    public List<SerializableFunction<String, String>> tests = new ArrayList<SerializableFunction<String, String>>();

    @Override
    public void nextItem(String item) {
        int arrow = (item = item.trim()).indexOf("->");
        if (arrow < 0) {
            Pattern pattern = Pattern.compile(item);
            this.tests.add(new SimpleMatch(pattern));
        } else if (arrow == 0) {
            String replacement = item.substring(2).trim();
            this.tests.add(new Fallback(replacement));
        } else {
            Pattern pattern = Pattern.compile(item.substring(0, arrow).trim());
            String replacement = item.substring(arrow + 2).trim();
            this.tests.add(new ReplaceMatch(pattern, replacement));
        }
    }

    @Override
    public String apply(String authority, String path) {
        String combined = authority != null ? authority + path : path;
        for (SerializableFunction<String, String> test : this.tests) {
            String result = (String)test.apply(combined);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private static class ReplaceMatch
    implements SerializableFunction<String, String> {
        @Visitor.Invoke(method="pattern")
        private final Pattern pattern;
        private final String replacement;

        public ReplaceMatch(Pattern pattern, String replacement) {
            this.pattern = pattern;
            this.replacement = replacement;
        }

        public String pattern() {
            return this.pattern.pattern();
        }

        @Override
        public String apply(String path) {
            Matcher matcher = this.pattern.matcher(path);
            if (matcher.matches()) {
                return matcher.replaceFirst(this.replacement);
            }
            return null;
        }
    }

    private static class Fallback
    implements SerializableFunction<String, String> {
        private final String metric;

        public Fallback(String metric) {
            this.metric = metric;
        }

        @Override
        public String apply(String path) {
            return this.metric;
        }
    }

    private static class SimpleMatch
    implements SerializableFunction<String, String> {
        @Visitor.Invoke(method="pattern")
        private final Pattern pattern;

        public SimpleMatch(Pattern pattern) {
            this.pattern = pattern;
        }

        public String pattern() {
            return this.pattern.pattern();
        }

        @Override
        public String apply(String path) {
            return this.pattern.matcher(path).matches() ? path : null;
        }
    }
}

