/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.steps;

import io.hyperfoil.api.config.Step;
import io.hyperfoil.api.session.Access;
import io.hyperfoil.api.session.ResourceUtilizer;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.builders.BaseStepBuilder;
import io.hyperfoil.core.session.SessionFactory;
import io.hyperfoil.function.SerializableBiConsumer;
import io.hyperfoil.function.SerializableBiPredicate;
import io.hyperfoil.function.SerializableConsumer;
import io.hyperfoil.function.SerializableFunction;
import io.hyperfoil.function.SerializablePredicate;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;

public class PollStep<T>
implements Step,
ResourceUtilizer {
    private static final Logger log = LoggerFactory.getLogger(PollStep.class);
    private final SerializableFunction<Session, T> provider;
    private final Access toVar;
    private final SerializableBiPredicate<Session, T> filter;
    private final SerializableBiConsumer<Session, T> recycler;
    private final long periodMs;
    private final int maxRetries;

    public PollStep(SerializableFunction<Session, T> provider, Access toVar, SerializableBiPredicate<Session, T> filter, SerializableBiConsumer<Session, T> recycler, long periodMs, int maxRetries) {
        this.provider = provider;
        this.filter = filter;
        this.toVar = toVar;
        this.recycler = recycler;
        this.periodMs = periodMs;
        this.maxRetries = maxRetries;
    }

    @Override
    public boolean invoke(Session session) {
        for (int i = 0; i < this.maxRetries; ++i) {
            Object object = this.provider.apply(session);
            if (object == null) {
                log.trace((Object)"Did not fetch object, scheduling #{} in {}", new Object[]{session.uniqueId(), this.periodMs});
                session.executor().schedule((Callable)session, this.periodMs, TimeUnit.MILLISECONDS);
                return false;
            }
            if (this.filter.test(session, object)) {
                this.toVar.setObject(session, object);
                return true;
            }
            this.recycler.accept(session, object);
        }
        log.trace((Object)"Not accepted, scheduling #{} in {}", new Object[]{session.uniqueId(), this.periodMs});
        session.executor().schedule((Runnable)((Object)session), this.periodMs, TimeUnit.MILLISECONDS);
        return false;
    }

    @Override
    public void reserve(Session session) {
        this.toVar.declareObject(session);
    }

    public static class Builder<T>
    extends BaseStepBuilder<Builder<T>> {
        private final SerializableFunction<Session, T> provider;
        private final String var;
        private SerializableBiPredicate<Session, T> filter = (s, o) -> true;
        private SerializableBiConsumer<Session, T> recycler;
        private long periodMs = 50L;
        private int maxRetries = 16;

        public Builder(SerializableFunction<Session, T> provider, String var) {
            this.provider = provider;
            this.var = var;
        }

        public Builder<T> filter(SerializableBiPredicate<Session, T> filter, SerializableBiConsumer<Session, T> recycler) {
            this.filter = Objects.requireNonNull(filter);
            this.recycler = Objects.requireNonNull(recycler);
            return this;
        }

        public Builder<T> filter(SerializablePredicate<T> filter, SerializableConsumer<T> recycler) {
            Objects.requireNonNull(filter);
            Objects.requireNonNull(recycler);
            this.filter = (s, ship) -> filter.test(ship);
            this.recycler = (s, ship) -> recycler.accept(ship);
            return this;
        }

        public Builder<T> periodMs(long periodMs) {
            this.periodMs = periodMs;
            return this;
        }

        public Builder<T> maxRetries(int maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        @Override
        public List<Step> build() {
            return Collections.singletonList(new PollStep<T>(this.provider, SessionFactory.access(this.var), this.filter, this.recycler, this.periodMs, this.maxRetries));
        }
    }
}

