/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.steps;

import io.hyperfoil.api.config.Name;
import io.hyperfoil.api.config.Step;
import io.hyperfoil.api.session.Access;
import io.hyperfoil.api.session.ResourceUtilizer;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.api.session.SharedData;
import io.hyperfoil.core.builders.BaseStepBuilder;
import io.hyperfoil.core.session.SessionFactory;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.util.Collections;
import java.util.List;

public class PullSharedMapStep
implements Step,
ResourceUtilizer {
    private static final Logger log = LoggerFactory.getLogger(PullSharedMapStep.class);
    private static final boolean trace = log.isTraceEnabled();
    private final String key;
    private final Access match;

    public PullSharedMapStep(String key, Access match) {
        this.key = key;
        this.match = match;
    }

    @Override
    public boolean invoke(Session session) {
        SharedData.SharedMap sharedMap;
        if (this.match == null) {
            sharedMap = session.sharedData().pullMap(this.key);
            if (sharedMap == null) {
                if (trace) {
                    log.trace((Object)"Did not find any shared map for key {}", new Object[]{this.key});
                }
                return true;
            }
        } else {
            Object value = this.match.getObject(session);
            sharedMap = session.sharedData().pullMap(this.key, this.match, value);
            if (sharedMap == null) {
                if (trace) {
                    log.trace((Object)"Did not find any shared map for key {} matching {}={}", new Object[]{this.key, this.match, value});
                }
                return true;
            }
        }
        for (int i = 0; i < sharedMap.size(); ++i) {
            sharedMap.key(i).setObject(session, sharedMap.value(i));
        }
        session.sharedData().releaseMap(this.key, sharedMap);
        return true;
    }

    @Override
    public void reserve(Session session) {
        session.sharedData().reserveMap(this.key, this.match, 0);
    }

    @Name(value="pullSharedMap")
    public static class Builder
    extends BaseStepBuilder<Builder> {
        private String key;
        private String match;

        @Override
        public List<Step> build() {
            return Collections.singletonList(new PullSharedMapStep(this.key, SessionFactory.access(this.match)));
        }

        public Builder key(String key) {
            this.key = key;
            return this;
        }

        public Builder match(String match) {
            this.match = match;
            return this;
        }
    }
}

