/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.steps;

import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.ListBuilder;
import io.hyperfoil.api.config.Name;
import io.hyperfoil.api.config.Step;
import io.hyperfoil.api.session.Access;
import io.hyperfoil.api.session.ResourceUtilizer;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.api.session.SharedData;
import io.hyperfoil.core.builders.BaseStepBuilder;
import io.hyperfoil.core.session.SessionFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;

public class PushSharedMapStep
implements Step,
ResourceUtilizer {
    private final String key;
    private final Access[] vars;

    public PushSharedMapStep(String key, Access[] vars) {
        this.key = key;
        this.vars = vars;
    }

    @Override
    public boolean invoke(Session session) {
        SharedData sharedData = session.sharedData();
        SharedData.SharedMap sharedMap = sharedData.newMap(this.key);
        for (int i = 0; i < this.vars.length; ++i) {
            sharedMap.put(this.vars[i], this.vars[i].getObject(session));
        }
        sharedData.pushMap(this.key, sharedMap);
        return true;
    }

    @Override
    public void reserve(Session session) {
        session.sharedData().reserveMap(this.key, null, this.vars.length);
    }

    @Name(value="pushSharedMap")
    public static class Builder
    extends BaseStepBuilder<Builder> {
        private String key;
        private Collection<String> vars = new ArrayList<String>();

        @Override
        public List<Step> build() {
            if (this.vars.isEmpty()) {
                throw new BenchmarkDefinitionException("No variables pushed for key " + this.key);
            }
            String[] vars1 = this.vars.toArray(new String[0]);
            return Collections.singletonList(new PushSharedMapStep(this.key, (Access[])Stream.of(vars1).map(SessionFactory::access).toArray(Access[]::new)));
        }

        public Builder key(String key) {
            this.key = key;
            return this;
        }

        public ListBuilder vars() {
            return this.vars::add;
        }
    }
}

