/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.steps;

import io.hyperfoil.api.config.BaseSequenceBuilder;
import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.InitFromParam;
import io.hyperfoil.api.config.Locator;
import io.hyperfoil.api.config.Name;
import io.hyperfoil.api.config.Step;
import io.hyperfoil.api.session.Access;
import io.hyperfoil.api.session.ResourceUtilizer;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.builders.BaseStepBuilder;
import io.hyperfoil.core.session.SessionFactory;
import io.hyperfoil.core.steps.AwaitDelayStep;
import io.hyperfoil.core.util.Unique;
import io.hyperfoil.core.util.Util;
import io.hyperfoil.function.SerializableToLongFunction;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;

public class ScheduleDelayStep
implements Step,
ResourceUtilizer {
    private static final Logger log = LoggerFactory.getLogger(ScheduleDelayStep.class);
    private final Access key;
    private final Type type;
    private final SerializableToLongFunction<Session> duration;

    public ScheduleDelayStep(Access key, Type type, SerializableToLongFunction<Session> duration) {
        this.key = key;
        this.type = type;
        this.duration = duration;
    }

    @Override
    public boolean invoke(Session session) {
        long baseTimestamp;
        Timestamp blockedUntil = (Timestamp)this.key.activate(session);
        long now = System.currentTimeMillis();
        switch (this.type) {
            case FROM_LAST: {
                if (blockedUntil.timestamp != Long.MAX_VALUE) {
                    baseTimestamp = blockedUntil.timestamp;
                    break;
                }
            }
            case FROM_NOW: {
                baseTimestamp = now;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        long duration = this.duration.applyAsLong(session);
        blockedUntil.timestamp = baseTimestamp + duration;
        long delay = blockedUntil.timestamp - now;
        if (delay > 0L) {
            log.trace((Object)"Scheduling #{} to run in {}", new Object[]{session.uniqueId(), delay});
            session.executor().schedule((Callable)session, delay, TimeUnit.MILLISECONDS);
        } else {
            log.trace((Object)"Continuing, duration {} resulted in delay {}", new Object[]{duration, delay});
        }
        return true;
    }

    @Override
    public void reserve(Session session) {
        this.key.declareObject(session);
        this.key.setObject(session, new Timestamp());
    }

    private static class RandomNegExpDuration
    implements SerializableToLongFunction<Session> {
        private final long duration;
        private final long max;
        private final long min;

        public RandomNegExpDuration(long duration, long max, long min) {
            this.duration = duration;
            this.max = max;
            this.min = min;
        }

        @Override
        public long applyAsLong(Session session) {
            double rand = ThreadLocalRandom.current().nextDouble();
            long delay = (long)((double)this.duration * -Math.log(Math.max(rand, 1.0E-20)));
            return Math.max(Math.min(delay, this.max), this.min);
        }
    }

    private static class RandomLinearDuration
    implements SerializableToLongFunction<Session> {
        private final long min;
        private final long max;

        public RandomLinearDuration(long min, long max) {
            this.min = min;
            this.max = max;
        }

        @Override
        public long applyAsLong(Session session) {
            return ThreadLocalRandom.current().nextLong(this.min, this.max + 1L);
        }
    }

    private static class ConstantDuration
    implements SerializableToLongFunction<Session> {
        private final long duration;

        public ConstantDuration(long duration) {
            this.duration = duration;
        }

        @Override
        public long applyAsLong(Session session) {
            return this.duration;
        }
    }

    @Name(value="thinkTime")
    public static class ThinkTimeBuilder
    extends Builder
    implements InitFromParam<ThinkTimeBuilder> {
        @Override
        public ThinkTimeBuilder addTo(BaseSequenceBuilder parent) {
            return (ThinkTimeBuilder)super.addTo(parent);
        }

        @Override
        public void prepareBuild() {
            this.key = new Unique();
            this.keyAccess = Locator.current().sequence().rootSequence().concurrency() > 0 ? SessionFactory.sequenceScopedAccess(this.key) : SessionFactory.access(this.key);
        }

        @Override
        public List<Step> build() {
            return Arrays.asList(super.build().get(0), new AwaitDelayStep(this.keyAccess));
        }

        @Override
        public ThinkTimeBuilder init(String param) {
            this.duration(param);
            return this;
        }
    }

    @Name(value="scheduleDelay")
    public static class Builder
    extends BaseStepBuilder<Builder> {
        protected Object key;
        protected Access keyAccess;
        private long duration;
        private Type type = Type.FROM_NOW;
        private RandomType randomType = RandomType.CONSTANT;
        private long min = 0L;
        private long max = Long.MAX_VALUE;

        public Builder key(String key) {
            this.key = key;
            return this;
        }

        public Builder duration(long duration, TimeUnit timeUnit) {
            this.duration = timeUnit == null ? 0L : timeUnit.toMillis(duration);
            return this;
        }

        public Builder duration(String duration) {
            this.duration = Util.parseToMillis(duration);
            return this;
        }

        public Builder fromNow() {
            this.type = Type.FROM_NOW;
            return this;
        }

        public Builder fromLast() {
            this.type = Type.FROM_LAST;
            return this;
        }

        public Builder random(RandomType randomType) {
            this.randomType = randomType;
            return this;
        }

        public Builder min(long min, TimeUnit timeUnit) {
            this.min = timeUnit.toMillis(min);
            return this;
        }

        public Builder min(String min) {
            this.min = Util.parseToMillis(min);
            return this;
        }

        public Builder max(long max, TimeUnit timeUnit) {
            this.max = timeUnit.toMillis(max);
            return this;
        }

        public Builder max(String max) {
            this.max = Util.parseToMillis(max);
            return this;
        }

        @Override
        public void prepareBuild() {
            if (this.key == null) {
                throw new BenchmarkDefinitionException("Key was not defined.");
            }
            this.keyAccess = SessionFactory.access(this.key);
        }

        @Override
        public List<Step> build() {
            SerializableToLongFunction<Session> func;
            long duration = this.duration;
            long min = this.min;
            long max = this.max;
            switch (this.randomType) {
                case CONSTANT: {
                    if (this.min != 0L || this.max != Long.MAX_VALUE) {
                        throw new BenchmarkDefinitionException("This duration should be constant; no need to define 'min' and 'max'.");
                    }
                    if (this.duration <= 0L) {
                        throw new BenchmarkDefinitionException("Duration must be positive.");
                    }
                    func = new ConstantDuration(duration);
                    break;
                }
                case LINEAR: {
                    if (this.duration != 0L) {
                        throw new BenchmarkDefinitionException("The duration is set through 'min' and 'max'; do not use 'duration'");
                    }
                    if (this.min < 0L) {
                        throw new BenchmarkDefinitionException("The minimum duration must not be lower than 0.");
                    }
                    if (this.max > TimeUnit.HOURS.toMillis(24L)) {
                        throw new BenchmarkDefinitionException("The maximum duration is over 24 hours: that's likely an error.");
                    }
                    func = new RandomLinearDuration(min, max);
                    break;
                }
                case NEGATIVE_EXPONENTIAL: {
                    func = new RandomNegExpDuration(duration, max, min);
                    break;
                }
                default: {
                    throw new BenchmarkDefinitionException("Unknown randomness type: " + this.randomType);
                }
            }
            return Collections.singletonList(new ScheduleDelayStep(this.keyAccess, this.type, func));
        }

        public Builder type(Type type) {
            this.type = type;
            return this;
        }
    }

    static class Timestamp {
        long timestamp = Long.MAX_VALUE;

        Timestamp() {
        }
    }

    public static enum RandomType {
        CONSTANT,
        LINEAR,
        NEGATIVE_EXPONENTIAL;

    }

    public static enum Type {
        FROM_LAST,
        FROM_NOW;

    }
}

