/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.steps;

import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.InitFromParam;
import io.hyperfoil.api.config.Name;
import io.hyperfoil.api.session.Access;
import io.hyperfoil.api.session.Action;
import io.hyperfoil.api.session.ResourceUtilizer;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.session.IntVar;
import io.hyperfoil.core.session.ObjectVar;
import io.hyperfoil.core.session.SessionFactory;
import io.hyperfoil.function.SerializableConsumer;
import io.hyperfoil.function.SerializableFunction;
import java.util.Objects;
import java.util.stream.Stream;

public class SetAction
implements Action,
ResourceUtilizer {
    private final Access var;
    private final SerializableFunction<Session, Object> valueSupplier;

    public SetAction(Access var, SerializableFunction<Session, Object> valueSupplier) {
        this.var = var;
        this.valueSupplier = valueSupplier;
    }

    @Override
    public void run(Session session) {
        this.var.setObject(session, this.valueSupplier.apply(session));
    }

    @Override
    public void reserve(Session session) {
        this.var.declareObject(session);
        ResourceUtilizer.reserve(session, this.valueSupplier);
    }

    public static class IntArrayBuilder
    extends BaseArrayBuilder<IntArrayBuilder> {
        public IntArrayBuilder(Builder parent) {
            super(parent);
        }

        private ValueSupplier<IntVar[]> build() {
            int mySize = this.ensurePositiveSize();
            return new ValueSupplier<IntVar[]>(new IntArraySupplier(mySize), BaseArrayBuilder::resetArray);
        }

        private static class IntArraySupplier
        implements SerializableFunction<Session, IntVar[]> {
            private final int size;

            public IntArraySupplier(int size) {
                this.size = size;
            }

            @Override
            public IntVar[] apply(Session session) {
                return IntVar.newArray(session, this.size);
            }
        }
    }

    public static class ObjectArrayBuilder
    extends BaseArrayBuilder<ObjectArrayBuilder> {
        public ObjectArrayBuilder(Builder parent) {
            super(parent);
        }

        private ValueSupplier<ObjectVar[]> build() {
            int mySize = this.ensurePositiveSize();
            return new ValueSupplier<ObjectVar[]>(new ObjectArraySupplier(mySize), BaseArrayBuilder::resetArray);
        }

        private static class ObjectArraySupplier
        implements SerializableFunction<Session, ObjectVar[]> {
            private final int size;

            public ObjectArraySupplier(int size) {
                this.size = size;
            }

            @Override
            public ObjectVar[] apply(Session session) {
                return ObjectVar.newArray(session, this.size);
            }
        }
    }

    public static abstract class BaseArrayBuilder<S extends BaseArrayBuilder<S>> {
        protected final Builder parent;
        protected int size;

        BaseArrayBuilder(Builder parent) {
            this.parent = parent;
        }

        public S size(int size) {
            this.size = size;
            return (S)this;
        }

        public Builder end() {
            return this.parent;
        }

        protected int ensurePositiveSize() {
            if (this.size <= 0) {
                throw new BenchmarkDefinitionException("Size must be positive!");
            }
            return this.size;
        }

        protected static void resetArray(Session.Var[] array) {
            for (int i = 0; i < array.length; ++i) {
                array[i].unset();
            }
        }
    }

    private static class ValueSupplier<T>
    implements SerializableFunction<Session, Object>,
    Session.ResourceKey<ValueResource<T>>,
    ResourceUtilizer {
        private final SerializableFunction<Session, T> supplier;
        private final SerializableConsumer<T> reset;

        private ValueSupplier(SerializableFunction<Session, T> supplier, SerializableConsumer<T> reset) {
            this.supplier = supplier;
            this.reset = reset;
        }

        @Override
        public Object apply(Session session) {
            Object object = ((ValueResource)session.getResource(this)).object;
            this.reset.accept(object);
            return object;
        }

        @Override
        public void reserve(Session session) {
            session.declareResource(this, () -> new ValueResource(this.supplier.apply(session)));
        }
    }

    private static class ValueResource<T>
    implements Session.Resource {
        private T object;

        public ValueResource(T o) {
            this.object = o;
        }
    }

    @Name(value="set")
    public static class Builder
    implements InitFromParam<Builder>,
    Action.Builder {
        private String var;
        private Object value;
        private ObjectArrayBuilder objectArray;
        private IntArrayBuilder intArray;

        @Override
        public Builder init(String param) {
            int sep = param.indexOf("<-");
            if (sep < 0) {
                throw new BenchmarkDefinitionException("Invalid inline definition '" + param + "': should be 'var <- value'");
            }
            this.var = param.substring(0, sep).trim();
            String value = param.substring(sep + 2).trim();
            this.value = value;
            return this;
        }

        public Builder var(String var) {
            this.var = var;
            return this;
        }

        public Builder value(String value) {
            this.value = value;
            return this;
        }

        public ObjectArrayBuilder objectArray() {
            this.objectArray = new ObjectArrayBuilder(this);
            return this.objectArray;
        }

        public IntArrayBuilder intArray() {
            this.intArray = new IntArrayBuilder(this);
            return this.intArray;
        }

        @Override
        public SetAction build() {
            if (this.var == null) {
                throw new BenchmarkDefinitionException("Variable name was not set!");
            }
            if (Stream.of(this.value, this.objectArray, this.intArray).filter(Objects::nonNull).count() != 1L) {
                throw new BenchmarkDefinitionException("Must set exactly on of: value, objectArray, intArray");
            }
            if (this.value != null) {
                Object myValue = this.value;
                return new SetAction(SessionFactory.access(this.var), new ConstantValue(myValue));
            }
            if (this.objectArray != null) {
                return new SetAction(SessionFactory.access(this.var), this.objectArray.build());
            }
            return new SetAction(SessionFactory.access(this.var), this.intArray.build());
        }

        private static class ConstantValue
        implements SerializableFunction<Session, Object> {
            private final Object value;

            public ConstantValue(Object value) {
                this.value = value;
            }

            @Override
            public Object apply(Session s) {
                return this.value;
            }
        }
    }
}

