/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.steps;

import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.InitFromParam;
import io.hyperfoil.api.config.Name;
import io.hyperfoil.api.session.Access;
import io.hyperfoil.api.session.Action;
import io.hyperfoil.api.session.ResourceUtilizer;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.builders.IntCondition;
import io.hyperfoil.core.session.SessionFactory;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;

public class SetIntAction
implements Action,
ResourceUtilizer {
    private static final Logger log = LoggerFactory.getLogger(SetIntAction.class);
    private static final boolean trace = log.isTraceEnabled();
    private final Access var;
    private final int value;
    private final boolean onlyIfNotSet;
    private final IntCondition condition;

    public SetIntAction(Access var, int value, boolean onlyIfNotSet, IntCondition condition) {
        this.var = var;
        this.value = value;
        this.onlyIfNotSet = onlyIfNotSet;
        this.condition = condition;
    }

    @Override
    public void run(Session session) {
        if (this.onlyIfNotSet && this.var.isSet(session)) {
            if (trace) {
                log.trace((Object)"#{} Not setting {} to {} as it is already set to {}", new Object[]{session.uniqueId(), this.var, this.value, this.var.getInt(session)});
            }
            return;
        }
        if (this.condition == null || this.condition.test(session)) {
            this.var.setInt(session, this.value);
        }
    }

    @Override
    public void reserve(Session session) {
        this.var.declareInt(session);
    }

    @Name(value="setInt")
    public static class Builder
    implements InitFromParam<Builder>,
    Action.Builder {
        private String var;
        private int value;
        private boolean onlyIfNotSet;
        private IntCondition.ProvidedVarBuilder<Builder> intCondition;

        @Override
        public Builder init(String param) {
            int sep = param.indexOf("<-");
            if (sep < 0) {
                throw new BenchmarkDefinitionException("Invalid inline definition '" + param + "': should be 'var <- value'");
            }
            this.var = param.substring(0, sep).trim();
            try {
                this.value = Integer.parseInt(param.substring(sep + 2).trim());
            }
            catch (NumberFormatException e) {
                throw new BenchmarkDefinitionException("Cannot parse value as int: " + param.substring(sep + 2), e);
            }
            return this;
        }

        public Builder var(String var) {
            this.var = var;
            return this;
        }

        public Builder value(int value) {
            this.value = value;
            return this;
        }

        public Builder onlyIfNotSet(boolean onlyIfNotSet) {
            this.onlyIfNotSet = onlyIfNotSet;
            return this;
        }

        public IntCondition.ProvidedVarBuilder<Builder> intCondition() {
            this.intCondition = new IntCondition.ProvidedVarBuilder<Builder>(this);
            return this.intCondition;
        }

        @Override
        public SetIntAction build() {
            if (this.var == null) {
                throw new BenchmarkDefinitionException("No variable set!");
            }
            return new SetIntAction(SessionFactory.access(this.var), this.value, this.onlyIfNotSet, this.intCondition == null ? null : this.intCondition.build(this.var));
        }
    }
}

