/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.steps;

import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.InitFromParam;
import io.hyperfoil.api.config.Name;
import io.hyperfoil.api.session.Access;
import io.hyperfoil.api.session.Action;
import io.hyperfoil.api.session.ResourceUtilizer;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.session.SessionFactory;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;

public class StringToIntAction
implements Action,
ResourceUtilizer {
    private static final Logger log = LoggerFactory.getLogger(StringToIntAction.class);
    private final Access fromVar;
    private final Access toVar;

    public StringToIntAction(Access fromVar, Access toVar) {
        this.fromVar = fromVar;
        this.toVar = toVar;
    }

    @Override
    public void run(Session session) {
        Object value = this.fromVar.getObject(session);
        if (value == null) {
            log.error((Object)"#{} Cannot convert {} == null to integer", new Object[]{session.uniqueId(), this.fromVar});
        } else {
            try {
                int intValue = Integer.parseInt(value.toString());
                this.toVar.setInt(session, intValue);
            }
            catch (NumberFormatException e) {
                log.error((Object)"#{} Cannot convert {} to integer", new Object[]{session.uniqueId(), value});
            }
        }
    }

    @Override
    public void reserve(Session session) {
        this.toVar.declareInt(session);
    }

    @Name(value="stringToInt")
    public static class Builder
    implements Action.Builder,
    InitFromParam<Builder> {
        String fromVar;
        String toVar;

        public Builder fromVar(String fromVar) {
            this.fromVar = fromVar;
            return this;
        }

        public Builder toVar(String toVar) {
            this.toVar = toVar;
            return this;
        }

        @Override
        public Builder init(String param) {
            int index = param.indexOf("->");
            if (index < 0) {
                throw new BenchmarkDefinitionException("Wrong format: use 'fromVar -> toVar'");
            }
            this.fromVar = param.substring(0, index).trim();
            this.toVar = param.substring(index + 2).trim();
            if (this.fromVar.isEmpty() || this.toVar.isEmpty()) {
                throw new BenchmarkDefinitionException("Wrong format: use 'fromVar -> toVar'");
            }
            return this;
        }

        @Override
        public Action build() {
            if (this.fromVar == null || this.toVar == null) {
                throw new BenchmarkDefinitionException("Must set both `fromVar` and `toVar`.");
            }
            if (this.fromVar.equals(this.toVar)) {
                throw new BenchmarkDefinitionException("Variable type is set statically; cannot use the same variable for both `fromVar` and `toVar`.");
            }
            return new StringToIntAction(SessionFactory.access(this.fromVar), SessionFactory.access(this.toVar));
        }
    }
}

