/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.util;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;

public class CountDown
implements Handler<AsyncResult<Void>> {
    private Handler<AsyncResult<Void>> handler;
    private int value;

    public CountDown(Handler<AsyncResult<Void>> handler, int initialValue) {
        if (initialValue <= 0) {
            throw new IllegalArgumentException();
        }
        this.handler = handler;
        this.value = initialValue;
    }

    public CountDown(int initialValue) {
        this(null, initialValue);
    }

    public CountDown setHandler(Handler<AsyncResult<Void>> handler) {
        if (this.handler != null) {
            throw new IllegalStateException();
        }
        if (handler == null) {
            throw new IllegalArgumentException();
        }
        this.handler = handler;
        return this;
    }

    public void increment() {
        if (this.value < 0) {
            throw new IllegalStateException();
        }
        ++this.value;
    }

    public void countDown() {
        if (this.value <= 0) {
            throw new IllegalStateException();
        }
        if (--this.value == 0) {
            this.value = -1;
            this.handler.handle((Object)Future.succeededFuture());
        }
    }

    public void handle(AsyncResult<Void> event) {
        if (event.succeeded()) {
            this.countDown();
        } else {
            this.value = -1;
            this.handler.handle(event);
        }
    }
}

