/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.util;

import io.hyperfoil.api.config.Visitor;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Trie
implements Serializable {
    @Visitor.Invoke(method="terms")
    private final Node[] firstNodes;

    public Trie(String ... strings) {
        this.firstNodes = this.getNodes(Stream.of(strings).map(s -> s.getBytes(StandardCharsets.UTF_8)).collect(Collectors.toList()), 0);
    }

    public Map<String, Integer> terms() {
        TreeMap<String, Integer> map = new TreeMap<String, Integer>();
        for (Node n : this.firstNodes) {
            n.writeTo(map, new byte[0]);
        }
        return map;
    }

    private Node[] getNodes(List<byte[]> strings, int index) {
        Set bytes = strings.stream().filter(Objects::nonNull).map(s -> s[index]).collect(Collectors.toSet());
        ArrayList<Node> nodes = new ArrayList<Node>();
        Iterator iterator = bytes.iterator();
        while (iterator.hasNext()) {
            byte b = (Byte)iterator.next();
            ArrayList<byte[]> matching = new ArrayList<byte[]>();
            int terminal = -1;
            for (int i = 0; i < strings.size(); ++i) {
                byte[] s2 = strings.get(i);
                if (s2 != null && s2[index] == b) {
                    if (s2.length == index + 1) {
                        assert (terminal < 0) : "Duplicate strings";
                        terminal = i;
                        continue;
                    }
                    matching.add(s2);
                    continue;
                }
                matching.add(null);
            }
            nodes.add(new Node(b, terminal, this.getNodes(matching, index + 1)));
        }
        return nodes.isEmpty() ? null : nodes.toArray(new Node[0]);
    }

    public State newState() {
        return new State();
    }

    private static class Node
    implements Serializable {
        final byte b;
        final int terminal;
        final Node[] nextNodes;

        private Node(byte b, int terminal, Node[] nextNodes) {
            this.b = b;
            this.terminal = terminal;
            this.nextNodes = nextNodes;
        }

        public void writeTo(Map<String, Integer> map, byte[] prefix) {
            byte[] current = Arrays.copyOf(prefix, prefix.length + 1);
            current[prefix.length] = this.b;
            if (this.terminal >= 0) {
                map.put(new String(current, StandardCharsets.UTF_8), this.terminal);
            }
            if (this.nextNodes != null) {
                for (Node n : this.nextNodes) {
                    n.writeTo(map, current);
                }
            }
        }
    }

    public class State {
        Node[] current;

        public State() {
            this.current = Trie.this.firstNodes;
        }

        public int next(byte b) {
            if (this.current == null) {
                return -1;
            }
            for (Node n : this.current) {
                if (n.b != b) continue;
                this.current = n.nextNodes;
                return n.terminal;
            }
            this.current = null;
            return -1;
        }

        public void reset() {
            this.current = Trie.this.firstNodes;
        }
    }
}

