/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.util;

import io.hyperfoil.api.config.Benchmark;
import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.netty.buffer.ByteBuf;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.StandardCharsets;
import java.util.BitSet;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;

public class Util {
    public static final CompletableFuture<Void> COMPLETED_VOID_FUTURE = CompletableFuture.completedFuture(null);
    private static final NumberFormatException NUMBER_FORMAT_EXCEPTION = new NumberFormatException();
    private static final int[] HEX = new int[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
    private static final int[] SIZE_TABLE = new int[]{1000000000, 100000000, 10000000, 1000000, 100000, 10000, 1000, 100, 10};

    private Util() {
    }

    public static boolean compareIgnoreCase(byte b1, byte b2) {
        return b1 == b2 || Util.toUpperCase(b1) == Util.toUpperCase(b2) || Util.toLowerCase(b1) == Util.toLowerCase(b2);
    }

    public static byte toLowerCase(byte b) {
        return b >= 65 && b <= 90 ? (byte)(b + 32) : b;
    }

    public static byte toUpperCase(byte b) {
        return b >= 97 && b <= 122 ? (byte)(b - 32) : b;
    }

    public static String prettyPrintNanosFixed(long meanResponseTime) {
        if (meanResponseTime < 1000L) {
            return String.format("%6d ns", meanResponseTime);
        }
        if (meanResponseTime < 1000000L) {
            return String.format("%6.2f \u03bcs", (double)meanResponseTime / 1000.0);
        }
        if (meanResponseTime < 1000000000L) {
            return String.format("%6.2f ms", (double)meanResponseTime / 1000000.0);
        }
        return String.format("%6.2f s ", (double)meanResponseTime / 1.0E9);
    }

    public static String prettyPrintNanos(long meanResponseTime) {
        if (meanResponseTime < 1000L) {
            return String.format("%d ns", meanResponseTime);
        }
        if (meanResponseTime < 1000000L) {
            return String.format("%.2f \u03bcs", (double)meanResponseTime / 1000.0);
        }
        if (meanResponseTime < 1000000000L) {
            return String.format("%.2f ms", (double)meanResponseTime / 1000000.0);
        }
        return String.format("%.2f s ", (double)meanResponseTime / 1.0E9);
    }

    public static String toString(ByteBuf buf, int offset, int length) {
        if (buf.hasArray()) {
            return new String(buf.array(), buf.arrayOffset() + offset, length, StandardCharsets.UTF_8);
        }
        byte[] strBytes = new byte[length];
        buf.getBytes(offset, strBytes, 0, length);
        return new String(strBytes, StandardCharsets.UTF_8);
    }

    public static ByteBuf string2byteBuf(CharSequence str, ByteBuf buffer) {
        CharBuffer input = CharBuffer.wrap(str);
        ByteBuffer output = buffer.nioBuffer(buffer.writerIndex(), buffer.capacity() - buffer.writerIndex());
        CharsetEncoder encoder = StandardCharsets.UTF_8.newEncoder();
        int accumulatedBytes = buffer.writerIndex();
        while (true) {
            CoderResult result;
            if ((result = encoder.encode(input, output, true)).isError()) {
                throw new RuntimeException("Cannot encode: " + result + ", string is " + str);
            }
            if (result.isUnderflow()) {
                buffer.writerIndex(accumulatedBytes + output.position());
                return buffer;
            }
            if (!result.isOverflow()) break;
            buffer.capacity(buffer.capacity() * 2);
            int writtenBytes = output.position();
            output = buffer.nioBuffer(accumulatedBytes += writtenBytes, buffer.capacity() - accumulatedBytes);
        }
        throw new IllegalStateException();
    }

    public static String explainCauses(Throwable e) {
        StringBuilder causes = new StringBuilder();
        HashSet<Throwable> reported = new HashSet<Throwable>();
        while (e != null && !reported.contains(e)) {
            if (causes.length() != 0) {
                causes.append(": ");
            }
            causes.append(e.getMessage());
            reported.add(e);
            e = e.getCause();
        }
        return causes.toString();
    }

    public static boolean regionMatchesIgnoreCase(CharSequence a, int aoffset, CharSequence b, int boffset, int length) {
        if (a instanceof String && b instanceof String) {
            return ((String)a).regionMatches(true, aoffset, (String)b, boffset, length);
        }
        if (aoffset < 0 || boffset < 0) {
            return false;
        }
        if (aoffset + length > a.length() || boffset + length > b.length()) {
            return false;
        }
        while (length-- > 0) {
            char u2;
            char u1;
            char c2;
            char c1;
            if ((c1 = a.charAt(aoffset++)) == (c2 = b.charAt(boffset++)) || (u1 = Character.toUpperCase(c1)) == (u2 = Character.toUpperCase(c2)) || Character.toLowerCase(u1) == Character.toLowerCase(u2)) continue;
            return false;
        }
        return true;
    }

    public static boolean regionMatches(CharSequence a, int aoffset, CharSequence b, int boffset, int length) {
        if (a instanceof String && b instanceof String) {
            return ((String)a).regionMatches(aoffset, (String)b, boffset, length);
        }
        if (aoffset < 0 || boffset < 0) {
            return false;
        }
        if (aoffset + length > a.length() || boffset + length > b.length()) {
            return false;
        }
        while (length-- > 0) {
            char c2;
            char c1;
            if ((c1 = a.charAt(aoffset++)) == (c2 = b.charAt(boffset++))) continue;
            return false;
        }
        return true;
    }

    public static boolean startsWith(CharSequence sequence, int offset, CharSequence prefix) {
        return Util.regionMatches(sequence, offset, prefix, 0, prefix.length());
    }

    public static int pow(int base, int exp) {
        int res = 1;
        while (exp-- > 0) {
            res *= base;
        }
        return res;
    }

    public static long parseLong(ByteBuf data, int offset, int length) {
        long value = 0L;
        int i = offset;
        while (Character.isWhitespace(data.getByte(i))) {
            ++i;
        }
        byte sign = data.getByte(i);
        if (sign == 45 || sign == 43) {
            ++i;
        }
        while (Character.isWhitespace(data.getByte(i))) {
            ++i;
        }
        while (length > 0 && Character.isWhitespace(data.getByte(offset + length - 1))) {
            --length;
        }
        while (i < offset + length) {
            byte digit = data.getByte(i);
            if (digit < 48 || digit > 57) {
                throw NUMBER_FORMAT_EXCEPTION;
            }
            value *= 10L;
            value += (long)(digit - 48);
            ++i;
        }
        return sign == 45 ? -value : value;
    }

    public static boolean isParamConvertible(Class<?> type) {
        return type == String.class || type == CharSequence.class || type == Object.class || type.isPrimitive() || type.isEnum();
    }

    public static String prettyPrintObject(Object value) {
        if (value instanceof byte[]) {
            byte[] bytes = (byte[])value;
            if (bytes.length == 0) {
                return "";
            }
            StringBuilder sb = new StringBuilder("[");
            sb.append((char)HEX[bytes[0] >> 4]);
            sb.append((char)HEX[bytes[0] & 0xF]);
            int length = Math.min(32, bytes.length);
            for (int i = 1; i < length; ++i) {
                sb.append(", ");
                sb.append((char)HEX[bytes[i] >> 4]);
                sb.append((char)HEX[bytes[i] & 0xF]);
            }
            if (bytes.length > 32) {
                sb.append(", ... (total length: ").append(bytes.length).append(")");
            }
            sb.append("]=");
            sb.append(new String(bytes, 0, Math.min(bytes.length, 32), StandardCharsets.UTF_8));
            if (bytes.length > 32) {
                sb.append("...");
            }
            return sb.toString();
        }
        return String.valueOf(value);
    }

    public static boolean hasPrefix(ByteBuf data, int offset, int length, byte[] prefix) {
        if (length < prefix.length) {
            return false;
        }
        for (int i = 0; i < prefix.length; ++i) {
            if (data.getByte(offset + i) == prefix[i]) continue;
            return false;
        }
        return true;
    }

    public static byte[] serialize(Benchmark benchmark) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (ObjectOutputStream outputStream = new ObjectOutputStream(byteArrayOutputStream);){
            outputStream.writeObject(benchmark);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static Benchmark deserialize(byte[] bytes) throws IOException, ClassNotFoundException {
        try (ObjectInputStream input = new ObjectInputStream(new ByteArrayInputStream(bytes));){
            Benchmark benchmark = (Benchmark)input.readObject();
            return benchmark;
        }
    }

    private static ByteArrayOutputStream toByteArrayOutputStream(InputStream stream) throws IOException {
        int length;
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((length = stream.read(buffer)) != -1) {
            result.write(buffer, 0, length);
        }
        stream.close();
        return result;
    }

    public static byte[] toByteArray(InputStream stream) throws IOException {
        return Util.toByteArrayOutputStream(stream).toByteArray();
    }

    public static String toString(InputStream stream) throws IOException {
        return Util.toByteArrayOutputStream(stream).toString(StandardCharsets.UTF_8.name());
    }

    public static long parseLong(CharSequence string) {
        return Util.parseLong(string, 0, string.length(), 0L);
    }

    public static long parseLong(CharSequence string, int begin, int end) {
        return Util.parseLong(string, begin, end, 0L);
    }

    public static long parseLong(CharSequence string, int begin, int end, long defaultValue) {
        long value = 0L;
        int i = begin;
        char sign = string.charAt(begin);
        if (sign == '-' || sign == '+') {
            ++i;
        }
        while (i < end) {
            char digit = string.charAt(i);
            if (digit < '0' || digit > '9') {
                return defaultValue;
            }
            value *= 10L;
            value += (long)(digit - 48);
            ++i;
        }
        return sign == '-' ? -value : value;
    }

    public static long parseToNanos(String time) {
        String prefix;
        TimeUnit unit;
        if (time.endsWith("ms")) {
            unit = TimeUnit.MILLISECONDS;
            prefix = time.substring(0, time.length() - 2);
        } else if (time.endsWith("us")) {
            unit = TimeUnit.MICROSECONDS;
            prefix = time.substring(0, time.length() - 2);
        } else if (time.endsWith("ns")) {
            unit = TimeUnit.NANOSECONDS;
            prefix = time.substring(0, time.length() - 2);
        } else if (time.endsWith("s")) {
            unit = TimeUnit.SECONDS;
            prefix = time.substring(0, time.length() - 1);
        } else if (time.endsWith("m")) {
            unit = TimeUnit.MINUTES;
            prefix = time.substring(0, time.length() - 1);
        } else if (time.endsWith("h")) {
            unit = TimeUnit.HOURS;
            prefix = time.substring(0, time.length() - 1);
        } else {
            throw new BenchmarkDefinitionException("Unknown time unit: " + time);
        }
        return unit.toNanos(Long.parseLong(prefix.trim()));
    }

    public static long parseToMillis(String time) {
        String prefix;
        TimeUnit unit;
        time = time.trim();
        switch (time.charAt(time.length() - 1)) {
            case 's': {
                if (time.endsWith("ms")) {
                    unit = TimeUnit.MILLISECONDS;
                    prefix = time.substring(0, time.length() - 2).trim();
                    break;
                }
                unit = TimeUnit.SECONDS;
                prefix = time.substring(0, time.length() - 1).trim();
                break;
            }
            case 'm': {
                unit = TimeUnit.MINUTES;
                prefix = time.substring(0, time.length() - 1).trim();
                break;
            }
            case 'h': {
                unit = TimeUnit.HOURS;
                prefix = time.substring(0, time.length() - 1).trim();
                break;
            }
            default: {
                unit = TimeUnit.SECONDS;
                prefix = time;
            }
        }
        return unit.toMillis(Long.parseLong(prefix));
    }

    public static void urlEncode(String string, ByteBuf buf) {
        byte[] bytes;
        for (byte b : bytes = string.getBytes(StandardCharsets.UTF_8)) {
            if (b >= 0 && URLEncoding.DONT_NEED_ENCODING.get(b)) {
                buf.ensureWritable(1);
                buf.writeByte((int)b);
                continue;
            }
            if (b == 32) {
                buf.ensureWritable(1);
                buf.writeByte(43);
                continue;
            }
            buf.ensureWritable(3);
            buf.writeByte(37);
            buf.writeByte(HEX[b >> 4 & 0xF]);
            buf.writeByte(HEX[b & 0xF]);
        }
    }

    public static String prettyPrintData(double value) {
        String suffix;
        double scaled;
        if (value >= 1.073741824E9) {
            scaled = value / 1.073741824E9;
            suffix = "GB";
        } else if (value >= 1048576.0) {
            scaled = value / 1048576.0;
            suffix = "MB";
        } else if (value >= 1024.0) {
            scaled = value / 1024.0;
            suffix = "kB";
        } else {
            scaled = value;
            suffix = "B ";
        }
        return String.format("%6.2f%s", scaled, suffix);
    }

    public static void intAsText2byteBuf(int value, ByteBuf buf) {
        int i;
        if (value < 0) {
            buf.writeByte(45);
            value = -value;
        }
        for (i = 0; i < SIZE_TABLE.length && value < SIZE_TABLE[i]; ++i) {
        }
        while (i < SIZE_TABLE.length) {
            int q = value / SIZE_TABLE[i];
            assert (q >= 0 && q <= 9);
            buf.writeByte(48 + q);
            value -= q * SIZE_TABLE[i];
            ++i;
        }
        assert (value >= 0 && value <= 9);
        buf.writeByte(48 + value);
    }

    private static class URLEncoding {
        private static final BitSet DONT_NEED_ENCODING;

        private URLEncoding() {
        }

        static {
            int i;
            DONT_NEED_ENCODING = new BitSet();
            for (i = 97; i <= 122; ++i) {
                DONT_NEED_ENCODING.set(i);
            }
            for (i = 65; i <= 90; ++i) {
                DONT_NEED_ENCODING.set(i);
            }
            for (i = 48; i <= 57; ++i) {
                DONT_NEED_ENCODING.set(i);
            }
            DONT_NEED_ENCODING.set(45);
            DONT_NEED_ENCODING.set(95);
            DONT_NEED_ENCODING.set(46);
            DONT_NEED_ENCODING.set(42);
        }
    }
}

