/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.tools.parse;

import io.hyperfoil.tools.parse.internal.DropString;
import io.hyperfoil.tools.yaup.StringUtil;
import java.util.HashMap;
import java.util.Map;

public enum Eat {
    Width(1),
    None(0),
    Match(-1),
    ToMatch(-2),
    Line(-3);

    private static final Map<Integer, Eat> idMap;
    private int id;

    private Eat(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public static Eat from(int value) {
        return idMap.containsKey(value) ? idMap.get(value) : Width;
    }

    public static Eat from(String input) {
        if (input.matches("-?\\d+")) {
            return Eat.from(Integer.parseInt(input));
        }
        return (Eat)StringUtil.getEnum((String)input, Eat.class, (Enum)Match);
    }

    public static boolean preEat(int eat, DropString line, int start, int end) {
        Eat toEat = Eat.from(eat);
        boolean changed = false;
        switch (toEat) {
            case Match: {
                line.drop(start, end);
                changed = true;
                break;
            }
            case ToMatch: {
                line.drop(0, end);
                changed = true;
                break;
            }
            case Width: {
                line.drop(start, start + eat);
                changed = true;
            }
        }
        return changed;
    }

    public static boolean postEat(int eat, DropString line, int start, int end) {
        Eat toEat = Eat.from(eat);
        boolean changed = false;
        switch (toEat) {
            case Line: {
                line.drop(0, line.length());
                changed = true;
            }
        }
        return changed;
    }

    static {
        idMap = new HashMap<Integer, Eat>();
        Eat[] values = Eat.values();
        for (int i = 0; i < values.length; ++i) {
            idMap.put(values[i].getId(), values[i]);
        }
    }
}

