/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.tools.parse;

import io.hyperfoil.tools.parse.Eat;
import io.hyperfoil.tools.parse.ExpMerge;
import io.hyperfoil.tools.parse.ExpRule;
import io.hyperfoil.tools.parse.JsMatchAction;
import io.hyperfoil.tools.parse.MatchAction;
import io.hyperfoil.tools.parse.MatchRange;
import io.hyperfoil.tools.parse.Parser;
import io.hyperfoil.tools.parse.ValueMerge;
import io.hyperfoil.tools.parse.ValueType;
import io.hyperfoil.tools.parse.internal.CheatChars;
import io.hyperfoil.tools.parse.internal.DropString;
import io.hyperfoil.tools.parse.internal.IMatcher;
import io.hyperfoil.tools.parse.internal.RegexMatcher;
import io.hyperfoil.tools.parse.json.JsonBuilder;
import io.hyperfoil.tools.yaup.HashedLists;
import io.hyperfoil.tools.yaup.StringUtil;
import io.hyperfoil.tools.yaup.json.Json;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;

public class Exp {
    static final XLogger logger = XLoggerFactory.getXLogger(MethodHandles.lookup().lookupClass());
    static final String NEST_ARRAY = "_array";
    static final String NEST_VALUE = "_value";
    public static final String NEST_KEY_PREFIX = "${{";
    public static final String NEST_KEY_SUFFIX = "}}";
    public static final String NEST_EXTEND_PREFIX = "$[[";
    public static final String NEST_EXTEND_SUFFIX = "]]";
    public static final String CAPTURE_PREFIX = "(?<";
    public static final String CAPTURE_SUFFIX = ">";
    public static final String CAPTURE_GROUP_PATTERN = "\\(\\?<(?!!)([^>]+)>";
    public static final String ROOT_TARGET_NAME = "_ROOT";
    public static final String GROUPED_NAME = "_GROUPED";
    private LinkedList<MatchAction> callbacks = new LinkedList();
    private LinkedHashMap<String, Object> with = new LinkedHashMap();
    private LinkedList<Exp> children = new LinkedList();
    private HashedLists<ExpRule, Object> rules = new HashedLists();
    private LinkedHashSet<String> enables = new LinkedHashSet();
    private LinkedHashSet<String> disables = new LinkedHashSet();
    private LinkedHashSet<String> requires = new LinkedHashSet();
    private Map<String, ValueInfo> fields;
    private LinkedList<NestPair> nesting = new LinkedList();
    private MatchRange matchRange = MatchRange.AfterParent;
    private ExpMerge expMerge = ExpMerge.ByKey;
    private int eat = Eat.Match.getId();
    private final String name;
    private final String pattern;
    private final IMatcher matcher;
    private boolean debug = false;

    public Json toJson() {
        Json rtrn = new Json();
        rtrn.set((Object)"pattern", (Object)this.getPattern());
        rtrn.set((Object)"eat", Eat.from(this.getEat()) == Eat.Width ? Integer.valueOf(this.getEat()) : Eat.from(this.getEat()));
        rtrn.set((Object)"name", (Object)this.getName());
        rtrn.set((Object)"range", (Object)this.getRange());
        if (this.getNest() != null) {
            rtrn.set((Object)"nest", (Object)this.getNest());
        }
        if (!this.getRequires().isEmpty()) {
            rtrn.set((Object)"requires", this.getRequires());
        }
        if (!this.getEnables().isEmpty()) {
            rtrn.set((Object)"enables", this.getEnables());
        }
        if (!this.getDisables().isEmpty()) {
            rtrn.set((Object)"disables", this.getDisables());
        }
        if (!this.getWith().isEmpty()) {
            Json with = new Json(false);
            this.getWith().forEach((k, v) -> with.set(k, v));
            rtrn.set((Object)"with", (Object)with);
        }
        if (!this.callbacks.isEmpty()) {
            Json execute = new Json();
            this.callbacks.forEach(callback -> {
                if (callback instanceof JsMatchAction) {
                    JsMatchAction matchAction = (JsMatchAction)callback;
                    execute.add((Object)matchAction.getJs());
                }
            });
            if (!execute.isEmpty()) {
                if (execute.size() == 1) {
                    rtrn.set((Object)"execute", execute.get((Object)0));
                } else {
                    rtrn.set((Object)"execute", (Object)execute);
                }
            }
        }
        return rtrn;
    }

    public static Exp fromJson(Json json) {
        Object value;
        if (!json.has((Object)"pattern") || !(json.get((Object)"pattern") instanceof String)) {
            throw new IllegalArgumentException("exp requires a pattern");
        }
        String name = json.getString((Object)"name", json.getString((Object)"pattern"));
        Exp rtrn = new Exp(name, json.getString((Object)"pattern"));
        if (json.has((Object)"eat")) {
            rtrn.eat(Eat.from(json.get((Object)"eat").toString()));
        }
        if (json.has((Object)"range")) {
            rtrn.setRange((MatchRange)StringUtil.getEnum((String)json.getString((Object)"range"), MatchRange.class, (Enum)MatchRange.AfterParent));
        }
        if (json.has((Object)"nest")) {
            rtrn.nest(json.getString((Object)"nest"));
        }
        if (json.has((Object)"requires")) {
            value = json.get((Object)"requires");
            if (value instanceof String) {
                rtrn.requires(value.toString());
            } else if (value instanceof Json) {
                ((Json)value).forEach(entry -> rtrn.requires(entry.toString()));
            }
        }
        if (json.has((Object)"enables")) {
            value = json.get((Object)"enables");
            if (value instanceof String) {
                rtrn.enables(value.toString());
            } else if (value instanceof Json) {
                ((Json)value).forEach(entry -> rtrn.enables(entry.toString()));
            }
        }
        if (json.has((Object)"disables")) {
            value = json.get((Object)"disables");
            if (value instanceof String) {
                rtrn.disables(value.toString());
            } else if (value instanceof Json) {
                ((Json)value).forEach(entry -> rtrn.disables(entry.toString()));
            }
        }
        rtrn.setMerge((ExpMerge)StringUtil.getEnum((String)json.getString((Object)"merge", ""), ExpMerge.class, (Enum)ExpMerge.ByKey));
        if (json.has((Object)"with")) {
            value = json.get((Object)"with");
            if (value instanceof Json) {
                ((Json)value).forEach((k, v) -> rtrn.with(k.toString(), v));
            } else {
                throw new IllegalArgumentException("unsupported with :" + value.getClass().getSimpleName() + " " + value.toString());
            }
        }
        if (json.has((Object)"rules") && (value = json.get((Object)"rules")) instanceof Json) {
            ((Json)value).forEach(rule -> {
                if (rule instanceof String) {
                    ExpRule newRule = (ExpRule)StringUtil.getEnum((String)rule.toString(), ExpRule.class, null);
                    if (newRule == null) throw new IllegalArgumentException("failed to parse rule from " + rule.toString());
                    rtrn.addRule(newRule);
                    return;
                } else {
                    if (!(rule instanceof Json) || ((Json)rule).size() != 1 || ((Json)rule).isArray()) throw new IllegalArgumentException("could not create rule form " + rule.getClass().getSimpleName() + " " + rule);
                    ((Json)rule).forEach((k, v) -> {
                        ExpRule newRule = (ExpRule)StringUtil.getEnum((String)k.toString(), ExpRule.class, null);
                        if (newRule == null) {
                            throw new IllegalArgumentException("failed to parse rule from " + k.toString());
                        }
                        rtrn.addRule(newRule, v);
                    });
                }
            });
        }
        if (json.has((Object)"fields")) {
            json.getJson((Object)"fields").forEach((fieldName, fieldValue) -> {
                if (fieldValue instanceof Json) {
                    Json valueJson = (Json)fieldValue;
                    ValueType type = (ValueType)StringUtil.getEnum((String)valueJson.getString((Object)"type", ""), ValueType.class, (Enum)ValueType.Auto);
                    ValueMerge merge = (ValueMerge)StringUtil.getEnum((String)valueJson.getString((Object)"merge", ""), ValueMerge.class, (Enum)ValueMerge.Auto);
                    rtrn.setType(fieldName.toString(), type);
                    if (valueJson.has((Object)"target") && ValueMerge.Key.equals((Object)merge)) {
                        rtrn.setKeyValue(fieldName.toString(), valueJson.getString((Object)"target"));
                    } else {
                        rtrn.setMerge(fieldName.toString(), merge);
                    }
                } else {
                    throw new IllegalArgumentException(fieldName + " value is not json " + fieldValue);
                }
            });
        }
        if (json.has((Object)"execute")) {
            value = json.get((Object)"execute");
            if (value instanceof String) {
                rtrn.execute(new JsMatchAction(value.toString()));
            } else if (value instanceof Json && ((Json)value).isArray()) {
                ((Json)value).forEach(entry -> rtrn.execute(new JsMatchAction(entry.toString())));
            }
        }
        if (json.has((Object)"children")) {
            json.getJson((Object)"children").forEach(child -> {
                if (child instanceof String) {
                    rtrn.add(new Exp(child.toString()));
                } else if (child instanceof Json && !((Json)child).isArray()) {
                    rtrn.add(Exp.fromJson((Json)child));
                } else {
                    throw new IllegalArgumentException("could not create child Exp from " + child);
                }
            });
        }
        return rtrn;
    }

    public static Json getSchema() {
        Json rtrn = new Json();
        rtrn.set((Object)"$schema", (Object)"http://json-schema.org/draft-07/schema");
        rtrn.set((Object)"definitions", (Object)new Json());
        rtrn.getJson((Object)"definitions").set((Object)"exp", (Object)Exp.getSchemaDefinition("exp"));
        rtrn.set((Object)"$ref", (Object)"#/definitions/exp");
        return rtrn;
    }

    public static Json getSchemaDefinition(String name) {
        return Json.fromJs((String)("{  oneOf: [    {type: 'string'},    {      type: 'object',      properties: {        name: { type: 'string' },        pattern: { type: 'string' },        eat: { oneOf: [ { type: 'number' }, { enum: ['None','Match','ToMatch','Line'] } ] },        range: { enum: ['EntireLine','AfterParent','BeforeParent'] },        nest: { type: 'string' },        requires: { oneOf: [ { type: 'string'}, { type: 'array', items: { type: 'string' } } ] },        enables: { oneOf: [ { type: 'string'}, { type: 'array', items: { type: 'string' } } ] },        disables: { oneOf: [ { type: 'string'}, { type: 'array', items: { type: 'string' } } ] },        merge: { enum: ['ByKey','AsEntry','Extend'] },        with: { type: 'object' },        rules: {          type: 'array',          items: {            oneOf: [              { enum: ['Repeat','RepeatChildren','PushTarget','PreClose','PostClose','PrePopTarget','PostPopTarget','PreClearTarget','PostClearTarget','TargetRoot'] },              {                type: 'object',                properties: {                  PushTarget: { oneOf: [ {type: 'string'} , { type: 'array', items: { type: 'string' } } ] },                  PreClearTarget: { oneOf: [ {type: 'string'} , { type: 'array', items: { type: 'string' } } ] },                  PostClearTarget: { oneOf: [ {type: 'string'} , { type: 'array', items: { type: 'string' } } ] },                  PreClose: { oneOf: [ {type: 'string'} , { type: 'array', items: { type: 'string' } } ] },                  PostClose: { oneOf: [ {type: 'string'} , { type: 'array', items: { type: 'string' } } ] },                  TargetRoot: { oneOf: [ {type: 'string'} , { type: 'array', items: { type: 'string' } } ] }                }              }            ]          }        },        fields: {           type: 'object',          additionalProperties: {            type: 'object',            properties: {              type: { enum: ['Auto','String','KMG','Integer','Decimal','Json'] },              merge: { enum: ['Auto','BooleanKey','BooleanValue','TargetId','Count','Add','List','Key','Set','First','Last','TreeSibling','TreeMerging'] },            },            if: { properties: { merge: {enum: ['Key']} } },            then: { required: ['target'] }          }        },        execute: {oneOf: [ {type: 'string'}, {type: 'array',items: { type: 'string'} } ] },        children: { type: 'array', items: {$ref: '#/definitions/" + name + "' } }      },      required: ['pattern'],      additionalProperties: false    }  ]}"));
    }

    public static String removePatternValues(String pattern) {
        String rtrn = pattern;
        Matcher fieldMatcher = Pattern.compile(CAPTURE_GROUP_PATTERN).matcher(pattern);
        fieldMatcher.reset(pattern);
        while (fieldMatcher.find()) {
            String match = fieldMatcher.group(1);
            if (match.indexOf(":") <= -1) continue;
            rtrn = rtrn.replace(match, match.substring(0, match.indexOf(":")));
        }
        return rtrn;
    }

    public static Map<String, ValueInfo> parsePattern(String pattern) {
        Matcher fieldMatcher = Pattern.compile(CAPTURE_GROUP_PATTERN).matcher(pattern);
        LinkedHashMap<String, ValueInfo> rtrn = new LinkedHashMap<String, ValueInfo>();
        while (fieldMatcher.find()) {
            LinkedList<String> fieldKeys = new LinkedList<String>(Arrays.asList(fieldMatcher.group(1).split(":")));
            String name = (String)fieldKeys.poll();
            ValueInfo valueInfo = rtrn.containsKey(name) ? (ValueInfo)rtrn.get(name) : new ValueInfo(name, null, ValueType.Auto, ValueMerge.Auto);
            rtrn.put(name, valueInfo);
            while (!fieldKeys.isEmpty()) {
                String key = ((String)fieldKeys.poll()).toLowerCase();
                if (StringUtil.getEnum((String)key, ValueType.class) != null) {
                    valueInfo.setType((ValueType)StringUtil.getEnum((String)key, ValueType.class));
                    continue;
                }
                if (StringUtil.getEnum((String)key, ValueMerge.class) != null) {
                    valueInfo.setMerge((ValueMerge)StringUtil.getEnum((String)key, ValueMerge.class));
                    continue;
                }
                if (key.contains("=")) {
                    String type = key.substring(0, key.indexOf("="));
                    String value = key.substring(key.indexOf("=") + 1);
                    ValueMerge valueMerge = (ValueMerge)StringUtil.getEnum((String)type, ValueMerge.class);
                    if (valueMerge == null) continue;
                    valueInfo.setMerge(valueMerge);
                    valueInfo.setTarget(value);
                    if (!ValueMerge.Key.equals((Object)valueMerge)) continue;
                    if (!rtrn.containsKey(value)) {
                        rtrn.put(value, new ValueInfo(value, null, ValueType.Auto, ValueMerge.Auto));
                    }
                    ((ValueInfo)rtrn.get(value)).setSkip(true);
                    continue;
                }
                logger.error("what is a " + key);
                throw new IllegalArgumentException("cannot infer type info from " + key + " in " + fieldMatcher.group(1) + " of " + pattern);
            }
        }
        return rtrn;
    }

    public String buildPattern() {
        String rtrn = this.getPattern();
        for (String key : this.fields.keySet()) {
            ValueInfo info = this.fields.get(key);
            Object replacement = key;
            if (!info.getType().equals((Object)ValueType.Auto)) {
                replacement = (String)replacement + ":" + info.getType().toString().toLowerCase();
            }
            if (!info.getMerge().equals((Object)ValueMerge.Auto)) {
                replacement = (String)replacement + ":" + info.getMerge().toString().toLowerCase();
                if (ValueMerge.Key.equals((Object)info.getMerge())) {
                    replacement = (String)replacement + "=" + info.getTarget();
                }
            }
            int start = rtrn.indexOf(CAPTURE_PREFIX + key);
            int stop = rtrn.indexOf(CAPTURE_SUFFIX, start);
            String substring = rtrn.substring(start, stop + CAPTURE_SUFFIX.length());
            rtrn = rtrn.replace(substring, CAPTURE_PREFIX + (String)replacement + CAPTURE_SUFFIX);
        }
        return rtrn;
    }

    public Exp(String pattern) {
        this(pattern, pattern);
    }

    public Exp(String name, String pattern) {
        if (name == null || pattern == null) {
            throw new IllegalArgumentException("name and pattern cannot be null");
        }
        this.name = name;
        this.pattern = pattern;
        this.fields = Exp.parsePattern(pattern);
        String safePattern = Exp.removePatternValues(pattern);
        this.matcher = new RegexMatcher(safePattern);
    }

    public boolean isDebug() {
        return this.debug;
    }

    public Exp debug() {
        return this.debug(true);
    }

    public Exp debug(boolean debug) {
        this.debug = debug;
        return this;
    }

    public String getPattern() {
        return this.pattern;
    }

    public int getEat() {
        return this.eat;
    }

    public Exp with(String key, Object value) {
        if (key == null || value == null) {
            throw new IllegalArgumentException("key and value cannot be null");
        }
        this.with.putIfAbsent(key, value);
        return this;
    }

    public Map<String, Object> getWith() {
        return this.with;
    }

    public boolean isNested() {
        return !this.nesting.isEmpty();
    }

    public ExpMerge getExpMerge() {
        return this.expMerge;
    }

    public void eachNest(BiConsumer<String, NestType> action) {
        this.nesting.forEach(np -> action.accept(np.value, np.type));
    }

    public boolean hasRules() {
        return !this.rules.isEmpty();
    }

    public void eachRule(BiConsumer<ExpRule, List<Object>> action) {
        this.rules.forEach(action);
    }

    public boolean isTargeting() {
        return this.fields.values().stream().map(valueInfo -> valueInfo.merge.isTargeting()).reduce(Boolean::logicalOr).orElse(false);
    }

    public Exp nest(String nesting) {
        if (nesting == null) {
            throw new IllegalArgumentException("nesting cannot be null");
        }
        List nests = Json.dotChain((String)nesting);
        for (String nest : nests) {
            int index = -1;
            if (nest.startsWith(NEST_KEY_PREFIX) && nest.endsWith(NEST_KEY_SUFFIX)) {
                String fieldName = nest.substring(NEST_KEY_PREFIX.length(), nest.length() - NEST_KEY_SUFFIX.length());
                this.key(fieldName);
                continue;
            }
            if (nest.startsWith(NEST_EXTEND_PREFIX) && nest.endsWith(NEST_EXTEND_SUFFIX)) {
                String extendName = nest.substring(NEST_EXTEND_PREFIX.length(), nest.length() - NEST_EXTEND_SUFFIX.length());
                this.extend(extendName);
                continue;
            }
            this.group(nest);
        }
        return this;
    }

    public String getNest() {
        if (!this.isNested()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        this.eachNest((key, type) -> {
            if (key.contains(".")) {
                key = key.replace(".", "\\.");
            }
            if (builder.length() > 0) {
                builder.append(".");
            }
            if (NestType.Field.equals(type)) {
                builder.append(NEST_KEY_PREFIX + key + NEST_KEY_SUFFIX);
            } else if (NestType.Extend.equals(type)) {
                builder.append(NEST_EXTEND_PREFIX + key + NEST_EXTEND_SUFFIX);
            } else {
                builder.append((String)key);
            }
        });
        return builder.toString();
    }

    public Exp group(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        this.nesting.add(new NestPair(name, NestType.Name));
        return this;
    }

    public Exp key(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        this.nesting.add(new NestPair(name, NestType.Field));
        return this;
    }

    public Exp extend(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        this.nesting.add(new NestPair(name, NestType.Extend));
        return this;
    }

    public Exp eat(int width) {
        this.eat = width;
        return this;
    }

    public Exp eat(Eat toEat) {
        if (toEat == null) {
            throw new IllegalArgumentException("eat cannot be null");
        }
        this.eat = toEat.getId();
        return this;
    }

    public Exp execute(MatchAction action) {
        if (action == null) {
            throw new IllegalArgumentException("action cannot be null");
        }
        this.callbacks.add(action);
        return this;
    }

    public Exp add(Exp child) {
        if (child == null) {
            throw new IllegalArgumentException("child cannot be null");
        }
        this.children.add(child);
        return this;
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public void eachChild(Consumer<Exp> consumer) {
        this.children.forEach(consumer);
    }

    public Exp setType(String fieldName, ValueType type) {
        if (fieldName == null || type == null) {
            throw new IllegalArgumentException("fieldName and type cannot be null");
        }
        this.fields.get(fieldName).setType(type);
        return this;
    }

    public Exp setKeyValue(String key, String value) {
        if (key == null || value == null) {
            throw new IllegalArgumentException("key and value cannot be null");
        }
        this.fields.get(key).setMerge(ValueMerge.Key);
        this.fields.get(key).setTarget(value);
        this.fields.get(value).setSkip(true);
        return this;
    }

    public Exp setMerge(String fieldName, ValueMerge merge) {
        if (fieldName == null || merge == null) {
            throw new IllegalArgumentException("fieldName and merge cannot be null");
        }
        this.fields.get(fieldName).setMerge(merge);
        return this;
    }

    public MatchRange getRange() {
        return this.matchRange;
    }

    public Exp setRange(MatchRange range) {
        if (range == null) {
            throw new IllegalArgumentException("range cannot be null");
        }
        this.matchRange = range;
        return this;
    }

    public Exp addRule(ExpRule rule) {
        if (rule == null) {
            throw new IllegalArgumentException("rule cannot be null");
        }
        this.rules.put((Object)rule, null);
        return this;
    }

    public Exp addRule(ExpRule rule, Object value) {
        if (rule == null || value == null) {
            throw new IllegalArgumentException("rule and value cannot be null");
        }
        this.rules.put((Object)rule, value);
        return this;
    }

    public Exp setMerge(ExpMerge merge) {
        if (merge == null) {
            throw new IllegalArgumentException("merge cannot be null");
        }
        this.expMerge = merge;
        return this;
    }

    public boolean hasRule(ExpRule rule) {
        return this.rules.containsKey((Object)rule);
    }

    public Json getNestedTarget(Json currentTarget, JsonBuilder builder) {
        Json returnTarget = currentTarget;
        if (this.nesting.isEmpty()) {
            switch (this.expMerge) {
                case AsEntry: {
                    if (currentTarget == builder.getRoot()) {
                        if (!builder.getRoot().isArray()) break;
                        Json newEnty = new Json();
                        currentTarget.add((Object)newEnty);
                        builder.pushTarget(newEnty);
                        currentTarget = builder.getTarget();
                        break;
                    }
                    if (currentTarget.isEmpty()) {
                        Json newEntry = new Json();
                        currentTarget.add((Object)newEntry);
                        builder.pushTarget(newEntry);
                        currentTarget = builder.getTarget();
                        break;
                    }
                    if (currentTarget.isArray() || builder.peekTarget(1) == null || !builder.peekTarget(1).isArray()) break;
                    Json newTarget = new Json();
                    builder.popTarget();
                    builder.getTarget().add((Object)newTarget);
                    builder.pushTarget(newTarget);
                    currentTarget = builder.getTarget();
                }
            }
        } else {
            Iterator iter = this.nesting.iterator();
            block8: while (iter.hasNext()) {
                Json newJson;
                NestPair nestPair = (NestPair)iter.next();
                String nestValue = nestPair.getValue();
                NestType nestType = nestPair.getType();
                boolean extend = false;
                if (NestType.Field.equals((Object)nestType) && ((nestValue = this.matcher.group(nestValue)) == null || nestValue.isEmpty())) {
                    throw new IllegalArgumentException("Cannot nest with " + nestValue);
                }
                if (NestType.Extend.equals((Object)nestType)) {
                    extend = true;
                }
                if (!iter.hasNext()) {
                    switch (this.expMerge) {
                        case AsEntry: {
                            Json entry;
                            if (returnTarget.has((Object)nestValue)) {
                                entry = new Json(false);
                                returnTarget.add((Object)nestValue, (Object)entry);
                                returnTarget = entry;
                                continue block8;
                            }
                            entry = new Json(false);
                            Json arry = new Json();
                            arry.add((Object)entry);
                            returnTarget.set((Object)nestValue, (Object)arry);
                            returnTarget = entry;
                            continue block8;
                        }
                        case Extend: {
                            if (returnTarget.has((Object)nestValue)) {
                                Json last;
                                Json arry = returnTarget.getJson((Object)nestValue);
                                returnTarget = last = arry.getJson((Object)(arry.size() - 1));
                                continue block8;
                            }
                            Json entry = new Json(false);
                            Json arry = new Json();
                            arry.add((Object)entry);
                            returnTarget.set((Object)nestValue, (Object)arry);
                            returnTarget = entry;
                            continue block8;
                        }
                        case ByKey: {
                            if (returnTarget.has((Object)nestValue)) {
                                returnTarget = returnTarget.getJson((Object)nestValue);
                                break;
                            }
                            newJson = new Json(false);
                            returnTarget.set((Object)nestValue, (Object)newJson);
                            returnTarget = newJson;
                        }
                    }
                    continue;
                }
                if (returnTarget.has((Object)nestValue)) {
                    Object obj = returnTarget.get((Object)nestValue);
                    if (obj instanceof Json && ((Json)obj).isArray()) {
                        Json groupArry = (Json)obj;
                        if (extend || ExpMerge.Extend.equals((Object)this.expMerge) && groupArry.size() > 0) {
                            returnTarget = groupArry.getJson((Object)(groupArry.size() - 1));
                            continue;
                        }
                        Json newJson2 = new Json(false);
                        groupArry.add((Object)newJson2);
                        returnTarget = newJson2;
                        continue;
                    }
                    returnTarget = returnTarget.getJson((Object)nestValue);
                    continue;
                }
                newJson = new Json(false);
                returnTarget.set((Object)nestValue, (Object)newJson);
                returnTarget = newJson;
            }
        }
        return returnTarget;
    }

    public Json apply(String line) {
        if (line == null) {
            throw new IllegalArgumentException("line cannot be null");
        }
        JsonBuilder builder = new JsonBuilder();
        this.apply(new CheatChars(line), builder, null);
        return builder.getRoot();
    }

    public boolean apply(DropString line, JsonBuilder builder, Parser parser) {
        return this.apply(line, builder, parser, line.reference(0));
    }

    protected boolean apply(DropString line, JsonBuilder builder, Parser parser, DropString.Ref startIndex) {
        if (this.isDebug() && startIndex.get() < line.length()) {
            logger.debug("{} apply to {}", (Object)this.getName(), (Object)line.subSequence(startIndex.get(), line.length()));
        }
        boolean rtrn = false;
        try {
            if (startIndex.get() > line.length() && this.matchRange.equals((Object)MatchRange.AfterParent)) {
                if (this.isDebug()) {
                    // empty if block
                }
                return false;
            }
            if (!this.requires.isEmpty() && parser != null) {
                boolean satisfyRequired;
                boolean bl = satisfyRequired = this.requires.stream().filter(required -> !parser.getState((String)required)).findAny().orElse(null) == null;
                if (!satisfyRequired) {
                    if (this.isDebug()) {
                        logger.debug("{} does not satisfy {}", (Object)this.getName(), this.requires.stream().filter(required -> !parser.getState((String)required)).collect(Collectors.toList()));
                    }
                    return false;
                }
            }
            int matchStart = this.matchRange.apply(this.matcher, line, startIndex.get());
            if (this.matcher.find()) {
                Json startTarget;
                rtrn = true;
                DropString.Ref firstStart = line.reference(this.matcher.start());
                DropString.Ref firstEnd = line.reference(this.matcher.end());
                int originalStart = line.getOriginalIndex(this.matcher.start());
                int originalEnd = line.getOriginalIndex(this.matcher.end());
                this.rules.forEach((rule, roleObjects) -> {
                    boolean changed = rule.prePopulate(builder, (List<Object>)roleObjects);
                    if (changed && this.isDebug()) {
                        logger.debug("{} pre-populated target json due to {}", (Object)this.getName(), (Object)rule);
                    }
                });
                Json currentTarget = startTarget = builder.getTarget();
                do {
                    boolean preEatChanged;
                    if (this.isDebug()) {
                        logger.debug("{} matches {} of {}", new Object[]{this.getName(), line.subSequence(this.matcher.start(), this.matcher.end()), line.subSequence(startIndex.get(), line.length())});
                    }
                    DropString.Ref matcherStart = line.reference(this.matcher.start());
                    DropString.Ref matcherEnd = line.reference(this.matcher.end());
                    boolean needPop = false;
                    boolean populateChangedTarget = false;
                    currentTarget = this.getNestedTarget(startTarget, builder);
                    if (currentTarget != startTarget) {
                        builder.pushTarget(currentTarget, this.getName() + GROUPED_NAME);
                        needPop = true;
                        if (this.isDebug()) {
                            logger.debug("{} created a nested target json", (Object)this.getName());
                        }
                    }
                    this.populate(builder);
                    if (currentTarget != builder.getTarget()) {
                        currentTarget = builder.getTarget();
                        populateChangedTarget = true;
                        if (this.isDebug()) {
                            logger.debug("{} changed target json when populated pattern values", (Object)this.getName());
                        }
                    }
                    if (this.isDebug()) {
                        logger.debug("{} post populate json\n{}", (Object)this.getName(), (Object)builder.getRoot().toString(2));
                    }
                    DropString beforeMatch = line;
                    DropString.Ref beforeMatchStart = matcherStart;
                    DropString.Ref beforeMatchEnd = matcherEnd;
                    if (this.hasChildren() && this.children.stream().filter(child -> MatchRange.BeforeParent.equals((Object)child.matchRange)).findAny().orElse(null) != null) {
                        beforeMatch = (DropString)line.subSequence(0, matcherStart.get());
                        beforeMatchStart = beforeMatch.reference(beforeMatchStart.get());
                        beforeMatchEnd = beforeMatch.reference(beforeMatchEnd.get());
                    }
                    if ((preEatChanged = Eat.preEat(this.eat, line, this.matcher.start(), this.matcher.end())) && this.isDebug()) {
                        logger.debug("{} changed line before children match", (Object)this.getName());
                    }
                    Json ruleTarget = currentTarget;
                    this.rules.forEach((rule, roleObjects) -> rule.preChildren(builder, ruleTarget, (List<Object>)roleObjects));
                    if (ruleTarget != builder.getTarget()) {
                        // empty if block
                    }
                    if (!this.disables.isEmpty() && parser != null) {
                        this.disables.forEach(v -> parser.setState((String)v, false));
                        if (this.isDebug()) {
                            logger.debug("{} disabled {}", (Object)this.getName(), this.disables);
                        }
                    }
                    if (!this.enables.isEmpty() && parser != null) {
                        this.enables.forEach(v -> parser.setState((String)v, true));
                        if (this.isDebug()) {
                            logger.debug("{} enabled {}", (Object)this.getName(), this.enables);
                        }
                    }
                    int lineLength = line.length();
                    if (this.hasChildren()) {
                        boolean childMatched = false;
                        do {
                            childMatched = false;
                            for (Exp child2 : this.children) {
                                boolean matched;
                                if (MatchRange.BeforeParent.equals((Object)child2.matchRange)) {
                                    matched = child2.apply(beforeMatch, builder, parser, beforeMatchStart);
                                    childMatched = matched || childMatched;
                                    continue;
                                }
                                matched = child2.apply(line, builder, parser, beforeMatchEnd);
                                if (this.isDebug()) {
                                    logger.debug("{} applied child {} matched={}", new Object[]{this.getName(), child2.getName(), matched});
                                }
                                childMatched = matched || childMatched;
                            }
                        } while (childMatched && this.hasRule(ExpRule.RepeatChildren));
                    }
                    if (needPop) {
                        builder.popTarget(this.getName() + GROUPED_NAME);
                    }
                    if (line.length() != lineLength) {
                        this.matcher.reset(line);
                        if (this.isDebug()) {
                            logger.debug("{} children modified line", (Object)this.getName());
                        }
                    }
                    this.matchRange.apply(this.matcher, line, matcherEnd.get());
                } while (this.hasRule(ExpRule.Repeat) && this.matcher.find());
                if (rtrn) {
                    for (MatchAction action : this.callbacks) {
                        action.onMatch(line.getLine(), currentTarget, this, parser);
                    }
                }
                Eat.postEat(this.eat, line, firstStart.get(), firstEnd.get());
                Json ruleTarget = currentTarget;
                this.rules.forEach((rule, roleObjects) -> rule.postChildren(builder, ruleTarget, (List<Object>)roleObjects));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return rtrn;
    }

    public void populate(JsonBuilder builder) {
        String key;
        for (ValueInfo valueInfo : this.fields.values()) {
            if (valueInfo.isSkip() || !valueInfo.getMerge().isTargeting()) continue;
            key = valueInfo.getName();
            Object value = valueInfo.type.apply(this.matcher.group(key));
            valueInfo.getMerge().merge(key, value, builder, null);
        }
        for (ValueInfo valueInfo : this.fields.values()) {
            Object value;
            if (valueInfo.isSkip() || valueInfo.getMerge().isTargeting()) continue;
            key = valueInfo.getName();
            Object target = valueInfo.getTarget();
            if (target != null) {
                target = this.fields.get((Object)target).type.apply(this.matcher.group(target.toString()));
            }
            if ((value = valueInfo.type.apply(this.matcher.group(key))) == null) continue;
            valueInfo.getMerge().merge(key, value, builder, target);
        }
        if (!this.with.isEmpty()) {
            for (String key2 : this.with.keySet()) {
                Json.chainSet((Json)builder.getTarget(), (String)key2, (Object)this.with.get(key2));
            }
        }
    }

    public boolean test(CharSequence input) {
        this.matcher.reset(input);
        return this.matcher.find();
    }

    public String getName() {
        return this.name;
    }

    Json appendNames(Json input) {
        if (input == null) {
            throw new IllegalArgumentException("input cannot be null");
        }
        Json ctx = input;
        for (NestPair pair : this.nesting) {
            ctx.add((Object)pair.getValue(), (Object)new Json());
            ctx = ctx.getJson((Object)pair.getValue());
        }
        for (String value : this.fields.keySet()) {
            ctx.set((Object)value, (Object)this.fields.get(value).getType());
        }
        for (Exp child : this.children) {
            child.appendNames(ctx);
        }
        return ctx;
    }

    public ValueType getType(String key) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null");
        }
        return this.fields.get(key).getType();
    }

    public ValueMerge getMerge(String key) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null");
        }
        return this.fields.get(key).getMerge();
    }

    public Exp requires(String key) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null");
        }
        this.requires.add(key);
        return this;
    }

    public Exp enables(String key) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null");
        }
        this.enables.add(key);
        return this;
    }

    public Exp disables(String key) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null");
        }
        this.disables.add(key);
        return this;
    }

    public void onSetup(Parser parser) {
    }

    public void onClose(Parser parser) {
        if (this.hasRule(ExpRule.RemoveOnClose)) {
            parser.remove(this);
        } else if (this.hasChildren()) {
            for (Exp child : this.children) {
                child.onClose(parser);
            }
        }
    }

    public Set<String> getRequires() {
        return this.requires;
    }

    public Set<String> getEnables() {
        return this.enables;
    }

    public Set<String> getDisables() {
        return this.disables;
    }

    private class NestPair {
        final String value;
        final NestType type;

        private NestPair(String value, NestType type) {
            this.value = value;
            this.type = type;
        }

        public String getValue() {
            return this.value;
        }

        public NestType getType() {
            return this.type;
        }
    }

    public static enum NestType {
        Extend,
        Field,
        Name;

    }

    private static class ValueInfo {
        final String name;
        String target;
        ValueType type;
        ValueMerge merge;
        boolean skip = false;

        private ValueInfo(String name, String target, ValueType type, ValueMerge merge) {
            this.name = name;
            this.target = target;
            this.type = type;
            this.merge = merge;
        }

        public boolean isSkip() {
            return this.skip;
        }

        public void setSkip(boolean skip) {
            this.skip = skip;
        }

        public String getName() {
            return this.name;
        }

        public String getTarget() {
            return this.target;
        }

        public void setTarget(String target) {
            this.target = target;
        }

        public ValueType getType() {
            return this.type;
        }

        public void setType(ValueType type) {
            this.type = type;
        }

        public ValueMerge getMerge() {
            return this.merge;
        }

        public void setMerge(ValueMerge merge) {
            this.merge = merge;
        }
    }
}

