/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.tools.parse;

import io.hyperfoil.tools.parse.json.JsonBuilder;
import io.hyperfoil.tools.yaup.json.Json;
import java.util.List;
import java.util.stream.Collectors;

public enum ExpRule {
    Repeat,
    RepeatChildren,
    PushTarget,
    PreClose,
    PostClose,
    PrePopTarget,
    PostPopTarget,
    PreClearTarget,
    RemoveOnClose,
    PostClearTarget,
    TargetRoot;

    private static final RuleAction DO_NOTHING;

    public boolean prePopulate(JsonBuilder builder, List<Object> data) {
        boolean changedTarget = false;
        List<Object> filteredData = this.filterRules(data);
        switch (this) {
            case PreClose: {
                if (filteredData.isEmpty()) {
                    builder.close();
                    changedTarget = true;
                    break;
                }
                boolean shouldClose = filteredData.stream().filter(obj -> builder.getTarget().has(obj)).findAny().isPresent();
                if (!shouldClose) break;
                builder.close();
                changedTarget = true;
                break;
            }
            case PrePopTarget: {
                if (filteredData.isEmpty()) {
                    builder.popTarget();
                } else {
                    filteredData.forEach(name -> builder.popTarget(name.toString()));
                }
                changedTarget = true;
                break;
            }
            case PreClearTarget: {
                if (filteredData.isEmpty()) {
                    builder.clearTargets();
                } else {
                    filteredData.forEach(name -> builder.clearTargets(name.toString()));
                }
                changedTarget = true;
                break;
            }
            case TargetRoot: {
                builder.pushTarget(builder.getRoot(), filteredData.toString() + "_ROOT");
                changedTarget = true;
            }
        }
        return changedTarget;
    }

    public boolean preChildren(JsonBuilder builder, Json target, List<Object> data) {
        boolean changedTarget = false;
        List<Object> filteredData = this.filterRules(data);
        switch (this) {
            case PushTarget: {
                if (filteredData.isEmpty()) {
                    builder.pushTarget(target);
                } else {
                    filteredData.forEach(name -> builder.pushTarget(target, name.toString()));
                }
                changedTarget = true;
            }
        }
        return changedTarget;
    }

    public boolean postChildren(JsonBuilder builder, Json target, List<Object> data) {
        boolean changedTarget = false;
        List<Object> filteredData = this.filterRules(data);
        switch (this) {
            case PostClose: {
                if (filteredData.isEmpty()) {
                    builder.close();
                    changedTarget = true;
                    break;
                }
                boolean shouldClose = filteredData.stream().filter(obj -> builder.getTarget().has(obj)).findAny().isPresent();
                if (!shouldClose) break;
                builder.close();
                changedTarget = true;
                break;
            }
            case PostPopTarget: {
                if (filteredData.isEmpty()) {
                    builder.popTarget(data.size());
                } else {
                    filteredData.forEach(name -> builder.popTarget(name.toString()));
                }
                changedTarget = true;
                break;
            }
            case PostClearTarget: {
                if (filteredData.isEmpty()) {
                    builder.clearTargets();
                } else {
                    filteredData.forEach(name -> builder.clearTargets(name.toString()));
                }
                changedTarget = true;
                break;
            }
            case TargetRoot: {
                builder.popTarget(filteredData.toString() + "_ROOT");
            }
        }
        return changedTarget;
    }

    public List<Object> filterRules(List<Object> data) {
        return data.stream().filter(v -> !(v instanceof ExpRule) && v != null).collect(Collectors.toList());
    }

    static {
        DO_NOTHING = (b, t, d) -> false;
    }

    private static interface RuleAction {
        public boolean apply(JsonBuilder var1, Json var2, List<Object> var3);
    }
}

