/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.tools.parse;

import io.hyperfoil.tools.parse.Exp;
import io.hyperfoil.tools.parse.file.FileRule;
import io.hyperfoil.tools.parse.file.Filter;
import io.hyperfoil.tools.parse.file.MatchCriteria;
import io.hyperfoil.tools.parse.yaml.ExpConstruct;
import io.hyperfoil.tools.parse.yaml.FileRuleConstruct;
import io.hyperfoil.tools.parse.yaml.FilterConstruct;
import io.hyperfoil.tools.parse.yaml.MatchCriteriaConstruct;
import io.hyperfoil.tools.yaup.Sets;
import io.hyperfoil.tools.yaup.StringUtil;
import io.hyperfoil.tools.yaup.file.FileUtility;
import io.hyperfoil.tools.yaup.json.Json;
import io.hyperfoil.tools.yaup.json.JsonValidator;
import io.hyperfoil.tools.yaup.json.graaljs.JsException;
import io.hyperfoil.tools.yaup.time.SystemTimer;
import io.hyperfoil.tools.yaup.yaml.MapRepresenter;
import io.hyperfoil.tools.yaup.yaml.OverloadConstructor;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.invoke.MethodHandles;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.aesh.AeshRuntimeRunner;
import org.aesh.command.Command;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandException;
import org.aesh.command.CommandResult;
import org.aesh.command.invocation.CommandInvocation;
import org.aesh.command.option.Option;
import org.aesh.command.option.OptionGroup;
import org.aesh.command.option.OptionList;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Construct;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Representer;

@CommandDefinition(name="parse", description="parse text files into structured json")
public class ParseCommand
implements Command {
    static final XLogger logger = XLoggerFactory.getXLogger(MethodHandles.lookup().lookupClass());
    @Option(shortName=116, name="threads", description="number of parallel threads for parsing sources", defaultValue={"-1"})
    Integer threadCount;
    @Option(name="disableDefault", description="disables default rules", hasValue=false)
    Boolean disableDefault;
    @OptionList(shortName=114, name="rules", description="parse rule definitions")
    Set<String> config;
    @Option(shortName=115, name="source", description="source of files to scan, supports folder or archive")
    String source;
    @OptionList(shortName=98, name="batch", description="batch of files to individually scan")
    Set<String> batch;
    @Option(shortName=100, name="destination", description="destination for the resulting json")
    String destination;
    @OptionGroup(shortName=83, name="state", description="state variables for patterns", defaultValue={})
    Map<String, String> state;

    public CommandResult execute(CommandInvocation commandInvocation) throws CommandException, InterruptedException {
        SystemTimer systemTimer = new SystemTimer("fileparser");
        ArrayList<FileRule> fileRules = new ArrayList<FileRule>();
        JsonValidator validator = ParseCommand.getValidator();
        systemTimer.start("load config");
        if (this.config == null || this.config.isEmpty()) {
            this.config = new HashSet<String>();
        }
        if (!this.disableDefault.booleanValue()) {
            logger.info("loading default rules");
            try (InputStreamReader fileStream = new InputStreamReader(ParseCommand.class.getClassLoader().getResourceAsStream("defaultRules.yaml"));
                 BufferedReader reader = new BufferedReader(fileStream);){
                String content = reader.lines().collect(Collectors.joining("\n"));
                Json loaded = Json.fromYaml((String)content);
                if (loaded.isArray()) {
                    loaded.forEach(entry -> {
                        if (entry instanceof Json) {
                            FileRule rule;
                            Json entryJson = (Json)entry;
                            Json errors = validator.validate(entryJson);
                            if (!errors.isEmpty()) {
                                logger.error("Errors\n" + errors.toString(2));
                                System.exit(1);
                            }
                            if ((rule = FileRule.fromJson(entryJson, Json.toObjectMap((Json)Json.fromMap(this.state)))) != null) {
                                fileRules.add(rule);
                            }
                        } else {
                            logger.error("cannot load rules from " + entry);
                        }
                    });
                } else {
                    FileRule rule = FileRule.fromJson(loaded, Json.toObjectMap((Json)Json.fromMap(this.state)));
                    if (rule != null) {
                        fileRules.add(rule);
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.batch == null) {
            this.batch = new LinkedHashSet<String>();
        }
        if (this.batch.isEmpty()) {
            if (this.source == null || this.source.isEmpty() || !Files.exists(Paths.get(this.source, new String[0]), new LinkOption[0])) {
                logger.error("source cannot be found: " + this.source);
                return CommandResult.FAILURE;
            }
            this.batch.add(this.source);
        } else if (this.source != null && !this.source.isEmpty()) {
            this.batch.add(this.source);
        }
        if (this.config != null) {
            this.config.forEach(configPath -> {
                Json loaded;
                Json json = loaded = configPath.endsWith("yaml") || configPath.endsWith("yml") ? Json.fromYamlFile((String)configPath) : Json.fromFile((String)configPath);
                if (loaded.isEmpty()) {
                    logger.error("failed to load content from {}", configPath);
                } else if (loaded.isArray()) {
                    loaded.forEach(entry -> {
                        if (entry instanceof Json) {
                            FileRule rule;
                            Json entryJson = (Json)entry;
                            Json errors = validator.validate(entryJson);
                            if (!errors.isEmpty()) {
                                logger.error("Errors\n" + errors.toString(2));
                                System.exit(1);
                            }
                            if ((rule = FileRule.fromJson(entryJson, Json.toObjectMap((Json)Json.fromMap(this.state)))) != null) {
                                fileRules.add(rule);
                            }
                        } else {
                            logger.error("cannot create rule from {}", (Object)entry.toString());
                            System.exit(1);
                        }
                    });
                } else {
                    Json errors = validator.validate(loaded);
                    if (!errors.isEmpty()) {
                        logger.error("Errors\n" + errors.toString(2));
                        System.exit(1);
                    }
                    FileRule rule = FileRule.fromJson(loaded, Json.toObjectMap((Json)Json.fromMap(this.state)));
                    fileRules.add(rule);
                }
            });
        }
        if (fileRules.isEmpty()) {
            logger.error("failed to load any rules");
            return CommandResult.FAILURE;
        }
        int heapMb = (int)(Runtime.getRuntime().maxMemory() / 0x100000L);
        Semaphore heapSemaphore = new Semaphore(heapMb);
        int numOfThread = this.threadCount != null && this.threadCount > 0 ? this.threadCount.intValue() : Runtime.getRuntime().availableProcessors();
        int blockQueueSize = 2 * numOfThread;
        ArrayBlockingQueue<Runnable> blockingQueue = new ArrayBlockingQueue<Runnable>(blockQueueSize);
        ThreadPoolExecutor.CallerRunsPolicy rejectedExecutionHandler = new ThreadPoolExecutor.CallerRunsPolicy();
        ThreadPoolExecutor executorService = new ThreadPoolExecutor(numOfThread, numOfThread, 0L, TimeUnit.MINUTES, blockingQueue, rejectedExecutionHandler);
        systemTimer.start("parse");
        for (String sourcePath : this.batch) {
            RuleRunner ruleRunner = new RuleRunner(fileRules, systemTimer, heapSemaphore, heapMb);
            ruleRunner.setSourcePath(sourcePath);
            executorService.submit(ruleRunner);
        }
        executorService.shutdown();
        executorService.awaitTermination(1L, TimeUnit.DAYS);
        systemTimer.stop();
        logger.info(systemTimer.getJson().toString(2));
        return CommandResult.SUCCESS;
    }

    public static void main(String[] args) {
        AeshRuntimeRunner.builder().command(ParseCommand.class).args(args).execute();
        Object cmdLineSyntax = "";
        cmdLineSyntax = "java -jar " + new File(ParseCommand.class.getProtectionDomain().getCodeSource().getLocation().getPath()).getName() + " " + (String)cmdLineSyntax;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static JsonValidator getValidator() {
        try (InputStreamReader fileStream = new InputStreamReader(ParseCommand.class.getClassLoader().getResourceAsStream("filerule-schema.json"));){
            JsonValidator jsonValidator;
            try (BufferedReader reader = new BufferedReader(fileStream);){
                JsonValidator validator;
                String content = reader.lines().collect(Collectors.joining("\n"));
                Json schemaJson = Json.fromString((String)content);
                jsonValidator = validator = new JsonValidator(schemaJson);
            }
            return jsonValidator;
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
            return null;
        }
    }

    public static Yaml getYaml() {
        OverloadConstructor constructor = new OverloadConstructor();
        constructor.setExactMatchOnly(false);
        MapRepresenter mapRepresenter = new MapRepresenter();
        DumperOptions dumperOptions = new DumperOptions();
        dumperOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        dumperOptions.setWidth(1024);
        dumperOptions.setIndent(2);
        Yaml yaml = new Yaml((BaseConstructor)constructor, (Representer)mapRepresenter, dumperOptions);
        ExpConstruct expConstruct = new ExpConstruct();
        constructor.addConstruct(new Tag("exp"), (Construct)expConstruct);
        constructor.addConstruct(new Tag(Exp.class), (Construct)expConstruct);
        mapRepresenter.addMapping(Exp.class, ExpConstruct.MAPPING);
        FileRuleConstruct fileRuleConstruct = new FileRuleConstruct();
        constructor.addConstruct(new Tag("rule"), (Construct)fileRuleConstruct);
        constructor.addConstruct(new Tag(FileRule.class), (Construct)fileRuleConstruct);
        constructor.addMapKeys(new Tag("rule"), Sets.of((Object[])new String[]{"asText"}));
        constructor.addMapKeys(new Tag("rule"), Sets.of((Object[])new String[]{"asJbossCli"}));
        constructor.addMapKeys(new Tag("rule"), Sets.of((Object[])new String[]{"asJson"}));
        constructor.addMapKeys(new Tag("rule"), Sets.of((Object[])new String[]{"asXml"}));
        constructor.addMapKeys(new Tag("rule"), Sets.of((Object[])new String[]{"asPath"}));
        MatchCriteriaConstruct matchCriteriaConstruct = new MatchCriteriaConstruct();
        constructor.addConstruct(new Tag("match"), (Construct)matchCriteriaConstruct);
        constructor.addConstruct(new Tag(MatchCriteria.class), (Construct)matchCriteriaConstruct);
        FilterConstruct filterConstruct = new FilterConstruct();
        constructor.addConstruct(new Tag("filter"), (Construct)filterConstruct);
        constructor.addConstruct(new Tag(Filter.class), (Construct)filterConstruct);
        return yaml;
    }

    private class RuleRunner
    implements Runnable {
        private final Semaphore semaphore;
        private final List<FileRule> fileRules;
        private final SystemTimer systemTimer;
        private String sourcePath;
        private final int maxPermits;

        public RuleRunner(List<FileRule> fileRules, SystemTimer systemTimer, Semaphore semaphore, int maxPermits) {
            this.fileRules = fileRules;
            this.systemTimer = systemTimer;
            this.semaphore = semaphore;
            this.maxPermits = maxPermits;
        }

        public void setSourcePath(String sourcePath) {
            this.sourcePath = sourcePath;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (!Files.exists(Paths.get(this.sourcePath, new String[0]), new LinkOption[0])) {
                logger.error("cannot access " + this.sourcePath);
                return;
            }
            int neededMb = 0;
            try {
                neededMb = (int)(FileUtility.getInputSize((String)this.sourcePath) / 0x100000L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            int acquire = Math.min(this.maxPermits, 2 * neededMb);
            try {
                this.semaphore.acquire(acquire);
                try {
                    Object sourceDestination;
                    logger.info("Starting {}", (Object)this.sourcePath);
                    SystemTimer thisTimer = this.systemTimer.start(this.sourcePath, true);
                    List entries = FileUtility.isArchive((String)this.sourcePath) ? FileUtility.getArchiveEntries((String)this.sourcePath).stream().map(entry -> this.sourcePath + "#" + entry).collect(Collectors.toList()) : FileUtility.getFiles((String)this.sourcePath, (String)"", (boolean)true);
                    Json result = new Json();
                    for (String entry2 : entries) {
                        for (FileRule rule : this.fileRules) {
                            try {
                                rule.apply(entry2, (nest, json) -> {
                                    try {
                                        if (nest == null || nest.trim().isEmpty()) {
                                            if (!json.isArray()) {
                                                if (!result.isEmpty() && result.isArray()) {
                                                    result.add(json);
                                                    return;
                                                }
                                                result.merge(json);
                                                return;
                                            }
                                            if (!result.isEmpty() && !result.isArray()) {
                                                logger.error("cannot add an array to an object without a key");
                                                return;
                                            }
                                            json.forEach(arg_0 -> ((Json)result).add(arg_0));
                                            return;
                                        }
                                        if (!StringUtil.isJsFnLike((String)nest)) {
                                            Json.chainMerge((Json)result, (String)nest, (Object)json);
                                            return;
                                        }
                                        try {
                                            StringUtil.jsEval((String)nest, (Object[])new Object[]{result, json, ParseCommand.this.state});
                                            return;
                                        }
                                        catch (JsException jse) {
                                            logger.error(jse.getMessage());
                                            return;
                                        }
                                    }
                                    catch (Throwable e) {
                                        logger.error("Exception applying rule=" + rule.getName() + " entry=" + entry2, e);
                                    }
                                });
                            }
                            catch (Throwable e) {
                                logger.error("Exception for rule=" + rule.getName() + " entry=" + entry2, e);
                            }
                        }
                    }
                    if (result.isEmpty()) {
                        logger.error("failed to match rules to {}", (Object)this.sourcePath);
                    }
                    Object object = sourceDestination = ParseCommand.this.batch.size() > 1 ? null : ParseCommand.this.destination;
                    if (sourceDestination == null || ((String)sourceDestination).isEmpty()) {
                        if (FileUtility.isArchive((String)this.sourcePath)) {
                            sourceDestination = this.sourcePath;
                            if (((String)sourceDestination).endsWith(".zip")) {
                                sourceDestination = ((String)sourceDestination).substring(0, ((String)sourceDestination).lastIndexOf(".zip"));
                            }
                            if (((String)sourceDestination).endsWith(".tar.gz")) {
                                sourceDestination = ((String)sourceDestination).substring(0, ((String)sourceDestination).lastIndexOf(".tar.gz"));
                            }
                            sourceDestination = (String)sourceDestination + ".json";
                        } else {
                            sourceDestination = this.sourcePath.endsWith("/") ? this.sourcePath.substring(0, this.sourcePath.length() - 1) + ".json" : this.sourcePath + ".json";
                        }
                    }
                    logger.info("writing to {}", sourceDestination);
                    Path parentPath = Paths.get((String)sourceDestination, new String[0]).toAbsolutePath().getParent();
                    if (!parentPath.toFile().exists()) {
                        parentPath.toFile().mkdirs();
                    }
                    try {
                        Files.write(Paths.get((String)sourceDestination, new String[0]), result.toString(0).getBytes(), new OpenOption[0]);
                    }
                    catch (IOException e) {
                        logger.error("failed to write to {}", sourceDestination);
                        e.printStackTrace();
                    }
                    thisTimer.stop();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    this.semaphore.release(acquire);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

