/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.tools.parse;

import io.hyperfoil.tools.parse.Exp;
import io.hyperfoil.tools.parse.ExpRule;
import io.hyperfoil.tools.parse.JsonConsumer;
import io.hyperfoil.tools.parse.factory.ParseFactory;
import io.hyperfoil.tools.parse.internal.CheatChars;
import io.hyperfoil.tools.parse.json.JsonBuilder;
import io.hyperfoil.tools.yaup.json.Json;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.stream.Collectors;

public class Parser {
    private static final Map<String, ParseFactory> parserFactories = new HashMap<String, ParseFactory>();
    private List<JsonConsumer> consumers = new LinkedList<JsonConsumer>();
    private ArrayList<Exp> patterns;
    private HashMap<String, Boolean> states;
    private HashMap<String, Integer> counts;
    private JsonBuilder builder;
    private List<UnparsedConsumer> unparsedConsumers = new LinkedList<UnparsedConsumer>();

    public static Parser fromJson(Object obj) {
        if (obj instanceof String) {
            ParseFactory parseFactory = parserFactories.get(obj.toString().toLowerCase());
            if (parseFactory != null) {
                return parseFactory.newParser();
            }
            throw new IllegalArgumentException("unknown parser " + obj.toString());
        }
        if (obj instanceof Json) {
            Json json = (Json)obj;
            Parser p = new Parser();
            json.values().forEach(entry -> {
                if (entry instanceof String) {
                    Exp exp = new Exp(entry.toString());
                    p.add(exp);
                } else if (entry instanceof Json) {
                    Exp exp = Exp.fromJson((Json)entry);
                    p.add(exp);
                } else {
                    throw new IllegalArgumentException("cannot create expression from " + entry);
                }
            });
            return p;
        }
        throw new IllegalArgumentException("unknown parser " + obj);
    }

    public List<String> patternNames() {
        return this.patterns.stream().map(p -> p.getName()).collect(Collectors.toList());
    }

    public Parser() {
        this.patterns = new ArrayList();
        this.builder = new JsonBuilder();
        this.states = new HashMap();
        this.counts = new HashMap();
    }

    public void setCount(String name, int value) {
        this.counts.put(name, value);
    }

    public void addCount(String name, int value) {
        this.counts.put(name, value + this.counts.getOrDefault(name, 0));
    }

    public int getCount(String name) {
        return this.counts.getOrDefault(name, 0);
    }

    public void setState(String state, boolean value) {
        this.states.put(state, value);
    }

    public boolean getState(String state) {
        if (!this.states.containsKey(state)) {
            this.states.put(state, false);
        }
        return this.states.get(state);
    }

    public Json getNames() {
        Json rtrn = new Json();
        for (Exp p : this.patterns) {
            p.appendNames(rtrn);
        }
        return rtrn;
    }

    public JsonBuilder getBuilder() {
        return this.builder;
    }

    public void addUnparsedConsumer(UnparsedConsumer consumer) {
        this.unparsedConsumers.add(consumer);
    }

    public void removeUnparsedConsumer(UnparsedConsumer consumer) {
        this.unparsedConsumers.remove(consumer);
    }

    public void clearUnparsedConsumers() {
        this.unparsedConsumers.clear();
    }

    public void addAhead(Exp pattern) {
        this.patterns.add(0, pattern);
    }

    public void addAt(Exp pattern, int order) {
        if (this.patterns.size() <= order) {
            this.patterns.add(pattern);
        } else {
            this.patterns.add(order, pattern);
        }
    }

    public void add(Exp pattern) {
        this.patterns.add(pattern);
    }

    public void add(JsonConsumer consumer) {
        if (consumer != null) {
            this.consumers.add(consumer);
        }
    }

    public List<Exp> exps() {
        return Collections.unmodifiableList(this.patterns);
    }

    public Exp get(String patternName) {
        Exp rtrn = null;
        for (int i = 0; i < this.patterns.size() && rtrn == null; ++i) {
            Exp exp = this.patterns.get(i);
            if (!exp.getName().equals(patternName)) continue;
            rtrn = exp;
        }
        return rtrn;
    }

    public int remove(String patternName) {
        int index = -1;
        for (int i = 0; i < this.patterns.size() && index == -1; ++i) {
            Exp exp = this.patterns.get(i);
            if (!exp.getName().equals(patternName)) continue;
            index = i;
        }
        if (index > -1) {
            this.patterns.remove(index);
        }
        return index;
    }

    public boolean remove(Exp exp) {
        return this.patterns.remove(exp);
    }

    public void clearConsumers() {
        this.consumers.clear();
    }

    public boolean test(CharSequence line) {
        for (Exp pattern : this.patterns) {
            if (!pattern.hasRule(ExpRule.PreClose) || !pattern.test(line)) continue;
            return true;
        }
        return false;
    }

    public Json onLine(String str) {
        return this.onLine(new CheatChars(str), 0);
    }

    public Json onLine(String str, int lineNumber) {
        return this.onLine(new CheatChars(str), lineNumber);
    }

    public Json onLine(CheatChars line, int lineNumber) {
        boolean matched = false;
        int size = this.patterns.size();
        for (int i = 0; i < size; ++i) {
            int newIndex;
            Exp exp = this.patterns.get(i);
            matched = exp.apply(line, this.builder, this) && matched;
            int newSize = this.patterns.size();
            if (newSize == size) continue;
            i = newIndex = this.patterns.indexOf(exp);
            size = newSize;
        }
        if (!(line.isEmpty() || line.toString().trim().isEmpty() || this.unparsedConsumers.isEmpty())) {
            this.unparsedConsumers.forEach(consumer -> consumer.accept(line.toString(), line.getLine(), lineNumber));
        }
        return this.emit();
    }

    public void setup() {
        for (JsonConsumer consumer : this.consumers) {
            consumer.start();
        }
        for (Exp exp : this.patterns) {
            exp.onSetup(this);
        }
    }

    public Json close() {
        this.builder.close();
        Json rtrn = this.emit();
        for (JsonConsumer consumer : this.consumers) {
            consumer.close();
        }
        for (Exp exp : this.patterns) {
            exp.onClose(this);
        }
        return rtrn;
    }

    private Json emit() {
        Json toEmit = this.builder.takeClosed();
        if (toEmit != null) {
            for (JsonConsumer consumer : this.consumers) {
                consumer.consume(toEmit);
            }
        }
        return toEmit;
    }

    static {
        try {
            ServiceLoader<ParseFactory> parserSetLoader = ServiceLoader.load(ParseFactory.class);
            parserSetLoader.forEach(parseFactory -> {
                String[] className = parseFactory.getClass().getName().split("\\.");
                if (className.length > 0) {
                    parserFactories.put(className[className.length - 1].toLowerCase(), (ParseFactory)parseFactory);
                }
            });
        }
        catch (ServiceConfigurationError serviceConfigurationError) {
            throw new RuntimeException("Unable to load ParserFactories via ServiceLoader", serviceConfigurationError);
        }
    }

    public static interface UnparsedConsumer {
        public void accept(String var1, String var2, int var3);
    }
}

