/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.tools.parse;

import io.hyperfoil.tools.parse.json.JsonBuilder;
import io.hyperfoil.tools.yaup.json.Json;
import java.util.concurrent.atomic.AtomicBoolean;

public enum ValueMerge {
    Auto(false, (key, value, builder, data) -> {
        Json.chainAct((Json)builder.getTarget(), (String)key, (Object)value, (target, k, v) -> {
            if (!target.has((Object)k)) {
                target.set((Object)k, v);
            } else if (target.get((Object)k) instanceof Json && target.getJson((Object)k).isArray()) {
                target.getJson((Object)k).add(v);
            } else {
                Json newArry = new Json();
                newArry.add(target.get((Object)k));
                newArry.add(v);
                target.set((Object)k, (Object)newArry);
            }
        });
        return false;
    }),
    BooleanKey(false, (key, value, builder, data) -> {
        Json.chainSet((Json)builder.getTarget(), (String)key, (Object)true);
        return false;
    }),
    BooleanValue(false, (key, value, builder, data) -> {
        builder.getTarget().set(value, (Object)true);
        return false;
    }),
    TargetId(true, (key, value, builder, data) -> {
        AtomicBoolean rtrn = new AtomicBoolean(false);
        Object existing = builder.getContext("TargetId:" + key, true, null);
        if (existing == null) {
            builder.setContext("TargetId:" + key, value, -1);
        } else if (!value.equals(existing)) {
            builder.close();
        }
        Json.chainAct((Json)builder.getTarget(), (String)key, (Object)value, (target, k, v) -> {
            if (!target.has((Object)k)) {
                target.set((Object)k, v);
            } else if (!v.equals(target.get((Object)k))) {
                builder.close();
                Json.chainSet((Json)builder.getTarget(), (String)key, (Object)value);
                rtrn.set(true);
            }
        });
        return rtrn.get();
    }),
    Count((key, value, builder, data) -> {
        Json.chainAct((Json)builder.getTarget(), (String)key, (Object)value, (target, k, v) -> {
            if (target.has(v) && target.get(v) instanceof Long) {
                target.set(v, (Object)(target.getLong(v) + 1L));
            } else {
                target.set(v, (Object)1L);
            }
        });
        return false;
    }),
    Add((key, value, builder, data) -> {
        Json.chainAct((Json)builder.getTarget(), (String)key, (Object)value, (target, k, v) -> {
            if (v instanceof Number) {
                target.set((Object)k, (Object)(((Number)v).doubleValue() + target.getDouble((Object)k, 0.0)));
            } else {
                target.set((Object)k, (Object)(target.getString((Object)k, "") + v.toString()));
            }
        });
        return false;
    }),
    List((key, value, builder, data) -> {
        Json.chainAdd((Json)builder.getTarget(), (String)key, (Object)value);
        return false;
    }),
    Key((key, value, builder, data) -> {
        Json.chainAct((Json)builder.getTarget(), (String)key, (Object)value, (target, k, v) -> {
            if (target.has(v)) {
                if (target.get(v) instanceof Json && target.getJson(v).isArray()) {
                    target.getJson(v).add(data);
                } else {
                    Json newValue = new Json();
                    newValue.add(target.get(v));
                    newValue.add(data);
                    target.set(v, (Object)newValue);
                }
            } else {
                target.set(v, data);
            }
        });
        return false;
    }),
    Set((key, value, builder, data) -> {
        Json.chainAct((Json)builder.getTarget(), (String)key, (Object)value, (target, k, v) -> {
            boolean haveIt;
            if (!target.has((Object)k)) {
                target.set((Object)k, (Object)new Json());
            }
            boolean bl = haveIt = target.getJson((Object)k).values().stream().filter(existing -> existing.equals(v)).findFirst().orElse(null) != null;
            if (!haveIt) {
                target.add((Object)k, value);
            }
        });
        return false;
    }),
    First((key, value, builder, data) -> {
        Json.chainAct((Json)builder.getTarget(), (String)key, (Object)value, (target, k, v) -> {
            if (!target.has((Object)k)) {
                target.set((Object)k, v);
            }
        });
        return false;
    }),
    Last((key, value, builder, data) -> {
        Json.chainSet((Json)builder.getTarget(), (String)key, (Object)value);
        return false;
    }),
    TreeSibling(true, new TreeMerger(false)),
    TreeMerging(true, new TreeMerger(true));

    private final boolean isTargeting;
    private final Merger mergeFunction;

    private ValueMerge(boolean isTargeting, Merger mergeFunction) {
        this.isTargeting = isTargeting;
        this.mergeFunction = mergeFunction;
    }

    private ValueMerge(Merger mergeFunction) {
        this(false, mergeFunction);
    }

    public boolean isTargeting() {
        return this.isTargeting;
    }

    public boolean merge(String key, Object value, JsonBuilder builder, Object data) {
        return this.mergeFunction.merge(key, value, builder, data);
    }

    private static class TreeMerger
    implements Merger {
        final boolean merging;

        public TreeMerger(boolean merging) {
            this.merging = merging;
        }

        @Override
        public boolean merge(String key, Object value, JsonBuilder builder, Object data) {
            boolean changedTarget = false;
            int valueLength = value.toString().length();
            int contextLength = builder.getContextInteger(key, true);
            if (builder.hasContext(key, true)) {
                if (valueLength > contextLength) {
                    Json childAry = new Json();
                    Json newChild = new Json(false);
                    childAry.add((Object)newChild);
                    builder.getTarget().add((Object)key, (Object)childAry);
                    builder.pushTarget(childAry);
                    builder.setContext(key + "_array", true);
                    builder.pushTarget(newChild);
                } else if (valueLength < contextLength) {
                    while (valueLength < contextLength || builder.getContextBoolean(key + "_array", false)) {
                        builder.popTarget();
                        contextLength = builder.getContextInteger(key, true);
                    }
                    if (this.merging) {
                        Json childAry = builder.getTarget().getJson((Object)(builder.getTarget().size() - 1));
                    } else {
                        builder.popTarget();
                        Json newEntry = new Json(false);
                        if (builder.getContextBoolean(key + "_array", false)) {
                            builder.getTarget().add((Object)newEntry);
                        } else {
                            builder.getTarget().add((Object)key, (Object)newEntry);
                            builder.pushTarget(builder.getTarget().getJson((Object)key));
                            builder.setContext(key + "_array", true);
                            builder.pushTarget(newEntry);
                        }
                        builder.pushTarget(newEntry);
                        changedTarget = true;
                    }
                } else if (!this.merging) {
                    while (builder.size() > 1 && !builder.getContextBoolean(key + "_array", false)) {
                        builder.popTarget();
                        changedTarget = true;
                    }
                    Json newJson = new Json(false);
                    builder.getTarget().add((Object)newJson);
                    builder.pushTarget(newJson);
                    changedTarget = true;
                }
            } else {
                Json treeArry = new Json(true);
                Json treeStart = new Json(false);
                treeArry.add((Object)treeStart);
                builder.getTarget().add((Object)key, (Object)treeArry);
                builder.pushTarget(treeArry);
                builder.setContext(key + "_array", true);
                builder.pushTarget(treeStart);
                changedTarget = true;
            }
            builder.setContext(key, valueLength);
            if (changedTarget && !builder.hasContext(key + "_value", false)) {
                builder.setContext(key + "_value", value);
            }
            return changedTarget;
        }
    }

    private static interface Merger {
        public boolean merge(String var1, Object var2, JsonBuilder var3, Object var4);
    }
}

