/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.tools.parse;

import io.hyperfoil.tools.yaup.StringUtil;
import io.hyperfoil.tools.yaup.json.Json;
import java.util.regex.Pattern;

public enum ValueType {
    Auto{

        @Override
        public Object apply(String a) {
            if (a == null) {
                return "";
            }
            if (IntegerPattern.matcher(a).matches()) {
                return Long.parseLong(a);
            }
            if (DoublePattern.matcher(a).matches()) {
                return Double.parseDouble(a);
            }
            if (a.startsWith("[") && a.endsWith("]") || a.startsWith("{") && a.endsWith("}")) {
                return io.hyperfoil.tools.yaup.json.Json.fromString((String)a);
            }
            if (KmgPattern.matcher(a).matches()) {
                return StringUtil.parseKMG((String)a);
            }
            if ("true".equals(a.toLowerCase()) || "false".equals(a.toLowerCase())) {
                return Boolean.valueOf(a);
            }
            return a;
        }
    }
    ,
    String{

        @Override
        public Object apply(String input) {
            return input;
        }
    }
    ,
    KMG{

        @Override
        public Object apply(String input) {
            return StringUtil.parseKMG((String)input);
        }
    }
    ,
    Integer{

        @Override
        public Object apply(String input) {
            if (Pattern.matches("-?\\d+(?:.0+)?", input)) {
                return Long.parseLong(input);
            }
            return input;
        }
    }
    ,
    Ignore{

        @Override
        public Object apply(String input) {
            return null;
        }
    }
    ,
    Decimal{

        @Override
        public Object apply(String input) {
            if (Pattern.matches("-?\\d+(?:.\\d+)?", input)) {
                return Double.parseDouble(input);
            }
            return input;
        }
    }
    ,
    Json{

        @Override
        public Object apply(String input) {
            return io.hyperfoil.tools.yaup.json.Json.fromString((String)input);
        }
    };

    private static Pattern IntegerPattern;
    private static Pattern DoublePattern;
    private static Pattern KmgPattern;

    public Object apply(String input) {
        return input;
    }

    static {
        IntegerPattern = Pattern.compile("-?\\d{1,16}+");
        DoublePattern = Pattern.compile("-?\\d+(?:\\.\\d+)?");
        KmgPattern = Pattern.compile("\\d+\\.?\\d*[bBkKmMgGtT]");
    }
}

