/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.tools.parse.consumers;

import io.hyperfoil.tools.parse.JsonConsumer;
import io.hyperfoil.tools.yaup.json.Json;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class WriteJsonConsumer
implements JsonConsumer {
    private String fileName;
    private BufferedWriter writer;
    private boolean firstWrite = true;

    public WriteJsonConsumer(String fileName) {
        this.fileName = fileName;
        try {
            this.writer = new BufferedWriter(new FileWriter(new File(fileName)));
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(0);
        }
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFileName() {
        return this.fileName;
    }

    @Override
    public void start() {
        try {
            this.writer.write("[");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void consume(Json object) {
        try {
            if (!this.firstWrite) {
                this.writer.write(",");
                this.writer.newLine();
            } else {
                this.firstWrite = false;
            }
            this.writer.write(object.toString());
            this.writer.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void close() {
        try {
            this.writer.write("]");
            this.writer.flush();
            this.writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

