/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.tools.parse.factory;

import io.hyperfoil.tools.parse.Eat;
import io.hyperfoil.tools.parse.Exp;
import io.hyperfoil.tools.parse.ExpRule;
import io.hyperfoil.tools.parse.Parser;
import io.hyperfoil.tools.parse.factory.ParseFactory;
import io.hyperfoil.tools.yaup.json.Json;
import java.util.ArrayList;

public class DstatFactory
implements ParseFactory {
    public Exp defaultMessage() {
        return new Exp("defaultMessage", "You did not select any stats, using -cdngy by default");
    }

    public Exp headerGroup() {
        return new Exp("headerGroup", "[ ]?[\\-]{1,}(?<header>[^ \\-]+(:?[\\-\\/]?[^ \\-\\/]+)*)[\\- ]{1}");
    }

    public Exp columnGroup() {
        return new Exp("columnGroup", "\\s*(?<column>[\\:\\|]|[^\\s\\:\\|]+)");
    }

    @Override
    public Parser newParser() {
        Parser p = new Parser();
        this.addToParser(p);
        return p;
    }

    @Override
    public void addToParser(Parser p) {
        ArrayList headers = new ArrayList();
        p.add(this.defaultMessage().addRule(ExpRule.PreClose).eat(Eat.Line));
        p.add(this.headerGroup().addRule(ExpRule.PreClose).addRule(ExpRule.Repeat).eat(Eat.Line).execute((line, match, pattern, parser) -> {
            Json arry = match.getJson((Object)"header");
            for (int i = 0; i < arry.size(); ++i) {
                String header = arry.getString((Object)i);
                if (header.matches(".*[_\\-/].*")) {
                    StringBuilder fixHeader = new StringBuilder(header.length());
                    for (int c = 0; c < header.length(); ++c) {
                        char l = header.charAt(c);
                        if ("_/-".indexOf(l) > -1) {
                            if (++c >= header.length()) continue;
                            fixHeader.append(Character.toUpperCase(header.charAt(c)));
                            continue;
                        }
                        fixHeader.append(l);
                    }
                    headers.add(fixHeader.toString());
                    continue;
                }
                headers.add(header);
            }
        }));
        p.add(this.columnGroup().addRule(ExpRule.PreClose).addRule(ExpRule.Repeat).eat(Eat.Line).execute((line, match, pattern, parser) -> {
            Json arry = match.getJson((Object)"column");
            StringBuilder sb = new StringBuilder();
            sb.append("\\s*");
            int h = 0;
            for (int i = 0; i < arry.size(); ++i) {
                String column = arry.getString((Object)i);
                if ("|".equals(column) || ":".equals(column)) {
                    sb.append("[:\\|]?");
                    ++h;
                } else {
                    String header = (String)headers.get(h);
                    sb.append("(?<");
                    sb.append(header.replaceAll("[_\\-/]", ""));
                    sb.append("\\.");
                    sb.append(column.replaceAll("[_\\-/]", ""));
                    sb.append(":KMG>");
                    if ("time".equals(column)) {
                        sb.append("\\d{1,2}\\-\\d{1,2} \\d{2}:\\d{2}:\\d{2}");
                    } else {
                        sb.append("\\-|\\d+\\.?\\d*[KkMmGgBb]?");
                    }
                    sb.append(")");
                }
                sb.append("\\s*");
            }
            Exp entryExp = new Exp("dstat", sb.toString());
            entryExp.addRule(ExpRule.PreClose);
            entryExp.eat(Eat.Line);
            parser.addAhead(entryExp);
        }));
    }
}

