/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.tools.parse.factory;

import io.hyperfoil.tools.parse.Eat;
import io.hyperfoil.tools.parse.Exp;
import io.hyperfoil.tools.parse.ExpMerge;
import io.hyperfoil.tools.parse.ExpRule;
import io.hyperfoil.tools.parse.MatchRange;
import io.hyperfoil.tools.parse.Parser;
import io.hyperfoil.tools.parse.ValueMerge;
import io.hyperfoil.tools.parse.factory.ParseFactory;

public class JStackFactory
implements ParseFactory {
    public Exp threadDumpHeader() {
        return new Exp("start", "Full thread dump (?<vm>[^\\(]+)\\((?<version>[^\\(]+)\\)").addRule(ExpRule.PreClose);
    }

    public Exp threadInfo() {
        return new Exp("tid", " tid=(?<tid>0x[0-9a-f]+) nid=(?<nid>0x[0-9a-f]+)").addRule(ExpRule.PreClose).add(new Exp("os_prio", " os_prio=(?<osprio>\\d+)").setRange(MatchRange.EntireLine)).add(new Exp("prio", " prio=(?<prio>\\d+)").setRange(MatchRange.EntireLine)).add(new Exp("daemon", " (?<daemon>daemon)").setMerge("daemon", ValueMerge.BooleanKey).setRange(MatchRange.EntireLine)).add(new Exp("Name", "\\\"(?<Name>.+)\\\"(?: #\\d+)?").setRange(MatchRange.EntireLine)).add(new Exp("hex", "\\[(?<hex>0x[0-9a-f]+)\\]").eat(Eat.Match)).add(new Exp("status", " (?<status>[^\\[\n]+) "));
    }

    public Exp threadState() {
        return new Exp("ThreadState", "\\s+java\\.lang\\.Thread\\.State: (?<state>.*)");
    }

    public Exp stackFrame() {
        return new Exp("stack", "\\s+at (?<frame>[^\\(]+)").group("stack").setMerge(ExpMerge.AsEntry).add(new Exp("nativeMethod", "\\((?<nativeMethod>Native Method)\\)").setMerge("nativeMethod", ValueMerge.BooleanKey)).add(new Exp("lineNumber", "\\((?<file>[^:]+):(?<line>\\d+)\\)"));
    }

    public Exp locked() {
        return new Exp("stack", "\\s+- locked <(?<id>0x[0-9a-f]+)> \\(a (?<class>[^\\)]+)\\)").extend("stack").group("lock").setMerge(ExpMerge.AsEntry);
    }

    public Exp waiting() {
        return new Exp("stack", "\\s+- waiting on <(?<id>0x[0-9a-f]+)> \\(a (?<class>[^\\)]+)\\)").extend("stack").group("wait").setMerge(ExpMerge.AsEntry);
    }

    @Override
    public Parser newParser() {
        Parser p = new Parser();
        this.addToParser(p);
        return p;
    }

    @Override
    public void addToParser(Parser p) {
        p.add(this.threadDumpHeader());
        p.add(this.threadInfo());
        p.add(this.threadState());
        p.add(this.stackFrame());
        p.add(this.locked());
        p.add(this.waiting());
    }
}

