/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.tools.parse.factory;

import io.hyperfoil.tools.parse.Eat;
import io.hyperfoil.tools.parse.Exp;
import io.hyperfoil.tools.parse.ExpMerge;
import io.hyperfoil.tools.parse.ExpRule;
import io.hyperfoil.tools.parse.MatchRange;
import io.hyperfoil.tools.parse.Parser;
import io.hyperfoil.tools.parse.factory.ParseFactory;

public class Jep271Factory
implements ParseFactory {
    @Override
    public Parser newParser() {
        Parser p = new Parser();
        this.addToParser(p);
        return p;
    }

    @Override
    public void addToParser(Parser p) {
        this.addToParser(p, false);
    }

    public void addToParser(Parser p, boolean strict) {
        p.add(this.gcId().addRule(ExpRule.TargetRoot).add(this.gcExpanding().group("resize").setMerge(ExpMerge.AsEntry)).add(this.gcShrinking().group("resize").setMerge(ExpMerge.AsEntry)).add(this.shenandoahPhase().requires("gc-shenandoah").group("phases")).add(this.gcPause()).add(this.parallelSizeChanged().group("resize").setMerge(ExpMerge.AsEntry)).add(this.g1ResizePhase().requires("gc-g1").setMerge(ExpMerge.AsEntry)).add(this.g1TimedPhase().requires("gc-g1").setMerge(ExpMerge.AsEntry)).add(this.gcCpu().group("cpu")).add(this.gcAge()).add(this.gcAgeTableHeader().addRule(ExpRule.PushTarget)).add(this.gcAgeTableEntry().group("table").key("age")).add(this.gcHeapHeader().group("heap").setMerge(ExpMerge.AsEntry).addRule(ExpRule.PreClearTarget).add(this.gcHeapRegion().group("region").setMerge(ExpMerge.AsEntry).addRule(ExpRule.PreClearTarget)).add(this.gcHeapRegionG1().requires("gc-g1").addRule(ExpRule.PushTarget))).add(this.gcHeapRegion().group("region").setMerge(ExpMerge.AsEntry).addRule(ExpRule.PreClearTarget)).add(this.gcHeapSpace().extend("region").group("space").setMerge(ExpMerge.AsEntry).addRule(ExpRule.PrePopTarget)).add(this.gcHeapSpaceG1().requires("gc-g1")).add(this.gcHeapMetaRegion().group("region").setMerge(ExpMerge.AsEntry).addRule(ExpRule.PreClearTarget)).add(this.gcHeapMetaSpace().extend("region").group("space").setMerge(ExpMerge.AsEntry).addRule(ExpRule.PrePopTarget)).add(this.gcHeapRegionResize().group("resize").setMerge(ExpMerge.AsEntry).addRule(ExpRule.PreClearTarget)).add(this.gcHeapRegionResizeG1().requires("gc-g1").group("resize").setMerge(ExpMerge.AsEntry).addRule(ExpRule.PreClearTarget).addRule(ExpRule.PushTarget)).add(this.gcHeapRegionResizeG1UsedWaste().requires("gc-g1")).add(this.gcClassHistoStart()).add(this.gcClassHistoEntry().group("histo").setMerge(ExpMerge.AsEntry)).add(this.gcClassHistoTotal().group("total")).add(this.gcClassHistoEnd()));
        p.add(this.shenandoahTrigger().group("trigger").requires("gc-shenandoah").addRule(ExpRule.PreClose));
        p.add(this.gcLevel().enables("jep271-decorator").add(this.time().setRange(MatchRange.BeforeParent)).add(this.utcTime().setRange(MatchRange.BeforeParent)).add(this.uptime().setRange(MatchRange.BeforeParent)).add(this.timeMillis().setRange(MatchRange.BeforeParent)).add(this.uptimeMillis().setRange(MatchRange.BeforeParent)).add(this.timeNanos().setRange(MatchRange.BeforeParent)).add(this.uptimeNanos().setRange(MatchRange.BeforeParent)));
        p.add(this.gcTags().requires("jep271-decorator"));
        p.add(this.g1MarkStack().requires("gc-g1"));
        p.add(this.usingSerial().addRule(ExpRule.PostClose));
        p.add(this.usingParallel().addRule(ExpRule.PostClose));
        p.add(this.usingCms().addRule(ExpRule.PostClose));
        p.add(this.usingG1().addRule(ExpRule.PostClose));
        p.add(this.usingShenandoah().addRule(ExpRule.PostClose));
        p.add(this.gcExpanding());
        p.add(this.safepointStopTime().group("safepoint"));
        p.add(this.safepointAppTime().group("safepoint"));
        p.add(this.gcHeapSize().group("heap"));
        p.add(this.gcHeapRange().group("heap"));
        p.add(this.gcHeapYoungRange().group("heap").group("young"));
        p.add(this.gcHeapOldRange().group("heap").group("old"));
    }

    public Exp usingCms() {
        return new Exp("using", "Using (?<gc>Concurrent Mark Sweep)").enables("gc-cms");
    }

    public Exp usingSerial() {
        return new Exp("using", "Using (?<gc>Serial)").enables("gc-serial");
    }

    public Exp usingParallel() {
        return new Exp("using", "Using (?<gc>Parallel)").enables("gc-parallel");
    }

    public Exp usingG1() {
        return new Exp("using", "Using (?<gc>G1)").enables("gc-g1");
    }

    public Exp usingShenandoah() {
        return new Exp("using", "Using (?<gc>Shenandoah)").enables("gc-shenandoah");
    }

    public Exp gcPause() {
        return new Exp("pause", "Pause (?<region>.+\\S)\\s+\\((?<reason>[^\\)]+)\\)").add(this.gcResize()).add(new Exp("time", "(?<milliseconds>\\d+\\.\\d{3})ms"));
    }

    public Exp gcTags() {
        return new Exp("tags", "\\[(?<tags:set>[^\\s,\\]]+)").addRule(ExpRule.TargetRoot).add(new Exp("otherTags", "^,(?<tags:set>[^\\s,\\]]+)").addRule(ExpRule.Repeat).addRule(ExpRule.TargetRoot)).add(new Exp("tagsEnd", "\\s*\\]"));
    }

    public Exp gcResize() {
        return new Exp("gcResize", "(?<usedBefore:KMG>\\d+[bBkKmMgG])->(?<usedAfter:KMG>\\d+[bBkKmMgG])\\((?<capacity:KMG>\\d+[bBkKmMgG])\\)");
    }

    public Exp gcLevel() {
        return new Exp("level", "\\[(?<level:last>error|warning|info|debug|trace|develop)\\s*\\]").addRule(ExpRule.TargetRoot).eat(Eat.ToMatch);
    }

    public Exp gcKeyValue() {
        return new Exp("gcKeyValue", "(?<key>\\S+): (?<value>\\d+)").group("stat").setMerge(ExpMerge.AsEntry);
    }

    public Exp parallelSizeChanged() {
        return new Exp("parallelSizeChange", "(?<region>\\w+) generation size changed: (?<before:KMG>\\d+[bBkKmMgG])->(?<after:KMG>\\d+[bBkKmMgG])");
    }

    public Exp shenandoahPhase() {
        return new Exp("shenandoah.phase", "(?<lock>Pause|Concurrent) (?<phase>[a-zA-Z]+(?:\\s[a-zA-Z]+)*) ").setMerge(ExpMerge.AsEntry).add(new Exp("task", "\\((?<task>[a-zA-Z]+(?:\\s[a-zA-Z]+)+)\\) ")).add(this.gcResize()).add(new Exp("milliseconds", "(?<milliseconds>\\d+\\.\\d{3})ms"));
    }

    public Exp shenandoahTrigger() {
        return new Exp("shenandoah.trigger", "Trigger: ").add(new Exp("learning", "Learning (?<learningStep>\\d+) of (?<totalSteps>\\d+)\\. ")).add(new Exp("allocationFailure", "Handle Allocation Failure").with("cause", "allocation failure")).add(new Exp("freeThreshold", "Free \\((?<free:KMG>\\d+[bBkKmMgG])\\) is below (?:minimum|initial) threshold \\((?<threshold:KMG>\\d+[bBkKmMgG])\\)").with("cause", "free threshold")).add(new Exp("allocationThreshold", "Allocated since last cycle \\((?<allocated:KMG>\\d+[bBkKmMgG])\\) is larger than allocation threshold \\((?<threshold:KMG>\\d+[bBkKmMgG])\\)").with("cause", "allocation threshold")).add(new Exp("interval", "Time since last GC \\((?<elapsed>\\d+) ms\\) is larger than guaranteed interval \\((?<guarantee>\\d+) ms\\)").with("cause", "interval")).add(new Exp("rate", "Average GC time \\((?<milliseconds>\\d+\\.\\d{2}) ms\\) is above the time for allocation rate \\((?<rate>\\d+\\.\\d{2}) MB/s\\) to deplete free headroom \\((?<free:KMG>\\d+[bBkKmMgG])\\)").with("cause", "rate"));
    }

    public Exp g1MarkStack() {
        return new Exp("gcG1MarkStack", "MarkStackSize: (?<size:KMG>\\d+[bBkKmMgG])\\s+MarkStackSizeMax: (?<max:KMG>\\d+[bBkKmMgG])").group("markStack");
    }

    public Exp g1ResizePhase() {
        return new Exp("g1ResizePhase", "(?<phase>\\w+(?:\\s\\w+)*) (?<before:KMG>\\d+[bBkKmMgG])->(?<after:KMG>\\d+[bBkKmMgG])\\((?<capacity:KMG>\\d+[bBkKmMgG])\\) (?<milliseconds>\\d+\\.\\d{3})ms").group("phases");
    }

    public Exp g1TimedPhase() {
        return new Exp("g1TimedPhase", "(?<phase>\\w+(?:\\s\\w+)*) (?<milliseconds>\\d+\\.\\d{3})ms").group("phases");
    }

    public Exp gcCpu() {
        return new Exp("gcCpu", "User=(?<user>\\d+\\.\\d{2,3})s Sys=(?<sys>\\d+\\.\\d{2,3})s Real=(?<real>\\d+\\.\\d{2,3})s");
    }

    public Exp gcHeapSize() {
        return new Exp("gcHeapSize", "(?<limit>Initial|Minimum|Maximum) heap size (?<size>\\d+)").setKeyValue("limit", "size");
    }

    public Exp gcHeapRange() {
        return new Exp("gcHeapRange", "Minimum heap (?<min>\\d+)\\s+Initial heap (?<initial>\\d+)\\s+Maximum heap (?<max>\\d+)");
    }

    public Exp gcHeapYoungRange() {
        return new Exp("gcHeapYoungRange", "1: Minimum young (?<min>\\d+)\\s+Initial young (?<initial>\\d+)\\s+Maximum young (?<max>\\d+)");
    }

    public Exp gcHeapOldRange() {
        return new Exp("gcHeapOldRange", "Minimum old (?<min>\\d+)\\s+Initial old (?<initial>\\d+)\\s+Maximum old (?<max>\\d+)");
    }

    public Exp gcHeapHeader() {
        return new Exp("gcHeapHeader", "Heap (?<phase>before|after) GC invocations=(?<invocations>\\d+) \\(full (?<full>\\d+)\\):\\s*");
    }

    public Exp gcHeapRegion() {
        return new Exp("gcHeapRegion", "\\s*(?<name>\\w+(?:[\\s-]\\w+)*)\\s+total (?<total:KMG>\\d+[bBkKmMgG]), used (?<used:KMG>\\d+[bBkKmMgG])\\s+\\[(?<start>[^,]+), (?<current>[^,]+), (?<end>[^(]+)\\)");
    }

    public Exp gcHeapRegionG1() {
        return new Exp("gcHeapRegion_g1", "\\s+(?<name>\\w+(?:\\s\\w+)*)\\s+total (?<total:KMG>\\d+[bBkKmMgG]), used (?<used:KMG>\\d+[bBkKmMgG])\\s+\\[(?<start>[^,]+), (?<end>[^(]+)\\)");
    }

    public Exp gcHeapMetaRegion() {
        return new Exp("gcHeapMetaRegion", "\\s+(?<name>Metaspace)\\s+used (?<used:KMG>\\d+[KMG]), capacity (?<capacity:KMG>\\d+[bBkKmMgG]), committed (?<committed:KMG>\\d+[bBkKmMgG]), reserved (?<reserved:KMG>\\d+[bBkKmMgG])");
    }

    public Exp gcHeapRegionResize() {
        return new Exp("gcHeapRegionResize", "\\s*(?<region>\\w+): (?<before:KMG>\\d+[bBkKmMgG])->(?<after:KMG>\\d+[bBkKmMgG])\\((?<size:KMG>\\d+[bBkKmMgG])\\)");
    }

    public Exp gcHeapRegionResizeG1() {
        return new Exp("gcHeapRegionResizeG1", "(?<region>\\S+) regions: (?<before>\\d+)->(?<after>\\d+)").add(new Exp("gcHeapRegionRegizeG1_total", "\\((?<total>\\d+)\\)"));
    }

    public Exp gcHeapRegionResizeG1UsedWaste() {
        return new Exp("gcHeapRegionG1UsedWaste", "Used: (?<used:KMG>\\d+[bBkKmMgG]), Waste: (?<waste:KMG>\\d+[bBkKmMgG])");
    }

    public Exp gcHeapMetaSpace() {
        return new Exp("gcHeapMetaSpace", "\\s*(?<space>\\S+) space\\s+used (?<used:KMG>\\d+[bBkKmMgG]), capacity (?<capacity:KMG>\\d+[bBkKmMgG]), committed (?<committed:KMG>\\d+[bBkKmMgG]), reserved (?<reserved:KMG>\\d+[bBkKmMgG])");
    }

    public Exp gcHeapSpace() {
        return new Exp("gcHeapSpace", "\\s+(?<space>\\S+) space (?<size:KMG>\\d+[bBkKmMgG]),\\s+(?<used>\\d+)% used\\s+\\[(?<start>[^,]+),\\s?(?<current>[^,]+),\\s?(?<end>[^(]+)\\)");
    }

    public Exp gcHeapSpaceG1() {
        return new Exp("gcHeapSpaceG1", "region size (?<regionSize:KMG>\\d+[bBkKmMgG]), (?<youngCount>\\d+) young \\((?<youngSize:KMG>\\d+[bBkKmMgG])\\), (?<survivorCount>\\d+) survivors \\((?<survivorSize:KMG>\\d+[bBkKmMgG])\\)");
    }

    public Exp safepointStopTime() {
        return new Exp("safepointStop", "Total time for which application threads were stopped: (?<stoppedSeconds:add>\\d+\\.\\d+) seconds, Stopping threads took: (?<quiesceSeconds:add>\\d+\\.\\d+) seconds");
    }

    public Exp safepointAppTime() {
        return new Exp("safepointApplication", "Application time: (?<applicationSeconds:add>\\d+\\.\\d+) seconds");
    }

    public Exp gcClassHistoStart() {
        return new Exp("gcClassHistoStart", "Class Histogram \\((?<phase>\\S+) full gc\\)");
    }

    public Exp gcClassHistoEntry() {
        return new Exp("gcClassHistoEntry", "(?<num>\\d+):\\s+(?<count>\\d+):?\\s+(?<bytes>\\d+)\\s+(?<name>.*)");
    }

    public Exp gcClassHistoTotal() {
        return new Exp("gcClassHistoTotal", "Total\\s+(?<count>\\d+)\\s+(?<bytes>\\d+)");
    }

    public Exp gcClassHistoEnd() {
        return new Exp("gcClassHistoEnd", "Class Histogram \\((?<phase>\\S+) full gc\\) (?<milliseconds>\\d+\\.\\d{3})ms");
    }

    public Exp gcId() {
        return new Exp("gcId", "GC\\((?<gcId:TargetId>\\d+)\\)");
    }

    public Exp time() {
        return new Exp("time", "\\[(?<time:first>\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}\\.\\d{3}-\\d{4})\\]").addRule(ExpRule.TargetRoot);
    }

    public Exp utcTime() {
        return new Exp("utcTime", "\\[(?<utcTime:first>\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}\\.\\d{3}\\+\\d{4})\\]").addRule(ExpRule.TargetRoot);
    }

    public Exp uptime() {
        return new Exp("uptime", "\\[(?<uptime:first>\\d+\\.\\d{3})s\\]").addRule(ExpRule.TargetRoot);
    }

    public Exp timeMillis() {
        return new Exp("timeMillis", "\\[(?<timeMillis:first>\\d{13})ms\\]").addRule(ExpRule.TargetRoot);
    }

    public Exp uptimeMillis() {
        return new Exp("uptimeMillis", "\\[(?<uptimeMillis:first>\\d{1,12})ms\\]").addRule(ExpRule.TargetRoot);
    }

    public Exp timeNanos() {
        return new Exp("timeNanos", "\\[(?<timeNanos:first>\\d{13,})ns\\]").addRule(ExpRule.TargetRoot);
    }

    public Exp uptimeNanos() {
        return new Exp("uptimeNanos", "\\[(?<uptimeNanos:first>\\d{1,12})ns\\]").addRule(ExpRule.TargetRoot);
    }

    public Exp gcExpanding() {
        return new Exp("expand", "Expanding (?<region>\\S.+\\S) from (?<from:KMG>\\d+[kKmMgG]?)").add(new Exp("by", " by (?<by:KMG>\\d+[kKmMgG]?)")).add(new Exp("to", " to (?<to:KMG>\\d+[kKmMgG]?)")).with("change", "expanding");
    }

    public Exp gcShrinking() {
        return new Exp("shrink", "Shrinking (?<region>\\S.+\\S) from (?<from:KMG>\\d+[kKmMgG]?)").add(new Exp("by", " by (?<by:KMG>\\d+[kKmMgG]?)")).add(new Exp("to", " to (?<to:KMG>\\d+[kKmMgG]?)")).with("change", "shrinking");
    }

    public Exp gcAge() {
        return new Exp("gcAge", "Desired survivor size (?<survivorSize>\\d+) bytes, new threshold (?<threshold>\\d+) \\(max threshold (?<maxThreshold>\\d+)\\)");
    }

    public Exp gcAgeTableHeader() {
        return new Exp("gcAgeTableHeader", "Age table with threshold (?<tableThreshold>\\d+) \\(max threshold (?<tableMaxThreshold>\\d+)\\)");
    }

    public Exp gcAgeTableEntry() {
        return new Exp("gcAgeTableEntry", "- age\\s+(?<age>\\d+):\\s+(?<size>\\d+) bytes,\\s+(?<total>\\d+) total");
    }
}

