/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.tools.parse.factory;

import io.hyperfoil.tools.parse.Exp;
import io.hyperfoil.tools.parse.ExpMerge;
import io.hyperfoil.tools.parse.ExpRule;
import io.hyperfoil.tools.parse.Parser;
import io.hyperfoil.tools.parse.factory.ParseFactory;

public class SubstrateGcFactory
implements ParseFactory {
    public Exp gc() {
        return new Exp("gcEvent", "\\[(?<gctype>.*) GC \\((?<cause>[^\\)]+)\\) (?<before:kmg>\\d+[kKmMgG])->(?<after:kmg>\\d+[kKmMgG]), (?<seconds>\\d+\\.\\d{7}) secs\\]");
    }

    public Exp policyParametersHeader() {
        return new Exp("policyParametersHeader", "\\[Heap policy parameters:");
    }

    public Exp policyParameter() {
        return new Exp("policyParameter", "\\s+(?<policy>[^:]+): (?<value>\\d+)");
    }

    public Exp collectionTime() {
        return new Exp("collectionTime", "  collection time: (?<nanoSeconds>\\d+) nanoSeconds\\]\\]");
    }

    public Exp gcPhase() {
        return new Exp("timestamp", "\\[(?<timestamp>\\d{15,}) GC: (?<phase>\\S+)\\s{2,}+epoch: (?<epoch:targetId>\\d+)\\s+{2,}").add(new Exp("cause", "cause: (?<cause>.*?)(?:\\s{2,}|\\])")).add(new Exp("policy", "policy: (?<policy>.*?)(?:\\s{2,}|\\])")).add(new Exp("type", "type: (?<type>.*?)(?:\\s{2,}|\\]|$)"));
    }

    @Override
    public void addToParser(Parser p) {
        p.add(this.policyParametersHeader().enables("policyParameter"));
        p.add(this.policyParameter().requires("policyParameter").group("parameters").setMerge(ExpMerge.AsEntry).add(new Exp("closeBracket", "]").disables("policyParameter")));
        p.add(this.gcPhase().group("phase").setMerge(ExpMerge.AsEntry));
        p.add(this.gc().addRule(ExpRule.PreClose, "cause"));
        p.add(this.collectionTime().addRule(ExpRule.PostClose));
    }

    @Override
    public Parser newParser() {
        Parser parser = new Parser();
        this.addToParser(parser);
        return parser;
    }
}

