/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.tools.parse.factory;

import io.hyperfoil.tools.parse.Eat;
import io.hyperfoil.tools.parse.Exp;
import io.hyperfoil.tools.parse.ExpRule;
import io.hyperfoil.tools.parse.Parser;
import io.hyperfoil.tools.parse.factory.ParseFactory;
import io.hyperfoil.tools.yaup.json.Json;
import java.util.ArrayList;

public class VmstatFactory
implements ParseFactory {
    public Exp headerGroup() {
        return new Exp("headerGroup", "(?<header>(?:^| -+)[^ ]+)");
    }

    public Exp columnGroup() {
        return new Exp("columnGroup", "(?<column>\\s*\\S+)");
    }

    @Override
    public Parser newParser() {
        Parser p = new Parser();
        this.addToParser(p);
        return p;
    }

    @Override
    public void addToParser(Parser p) {
        ArrayList headers = new ArrayList();
        p.add(this.headerGroup().addRule(ExpRule.PreClose).addRule(ExpRule.Repeat).eat(Eat.Line).execute((line, match, pattern, parser) -> {
            Json arry = match.getJson((Object)"header");
            arry.forEach(entry -> headers.add(entry.toString()));
        }));
        p.add(this.columnGroup().addRule(ExpRule.PreClose).addRule(ExpRule.Repeat).eat(Eat.Line).execute((line, match, pattern, parser) -> {
            Json columns = match.getJson((Object)"column");
            StringBuilder sb = new StringBuilder();
            sb.append("\\s*");
            boolean h = false;
            int headerIndex = 0;
            int headerEnd = ((String)headers.get(headerIndex)).length();
            int columnEnd = 0;
            for (int i = 0; i < columns.size(); ++i) {
                String column = columns.getString((Object)i);
                columnEnd += column.length();
                column = column.trim().replaceAll("[_\\-/ ]", "");
                if (columnEnd > headerEnd) {
                    headerEnd += ((String)headers.get(++headerIndex)).length();
                }
                String header = ((String)headers.get(headerIndex)).replaceAll("[_\\-/ ]", "");
                sb.append("(?<");
                sb.append(header);
                sb.append("\\.");
                sb.append(column);
                if ("timestamp".equals(header)) {
                    sb.append(">");
                    sb.append("\\d{4}\\-\\d{1,2}-\\d{1,2} \\d{2}:\\d{2}:\\d{2}");
                } else {
                    sb.append(":KMG>");
                    sb.append("\\-|\\d+\\.?\\d*[KkMmGgBb]?");
                }
                sb.append(")");
                sb.append("\\s*");
            }
            Exp entryExp = new Exp("vmstat", sb.toString());
            entryExp.addRule(ExpRule.PreClose);
            entryExp.eat(Eat.Line);
            parser.addAhead(entryExp);
        }));
    }
}

