/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.tools.parse.factory;

import io.hyperfoil.tools.parse.Eat;
import io.hyperfoil.tools.parse.Exp;
import io.hyperfoil.tools.parse.ExpMerge;
import io.hyperfoil.tools.parse.ExpRule;
import io.hyperfoil.tools.parse.Parser;
import io.hyperfoil.tools.parse.factory.ParseFactory;
import io.hyperfoil.tools.yaup.json.Json;

public class XanFactory
implements ParseFactory {
    public Exp blank() {
        return new Exp("blank", "^\\s*$");
    }

    public Exp title() {
        return new Exp("title", "Title: (?<title>.*)");
    }

    public Exp section() {
        return new Exp("section", "Section: (?<section>.*)");
    }

    public Exp display() {
        return new Exp("display", "Display: (?<display>.*)");
    }

    public Exp dashes() {
        return new Exp("dashes", "^-[ -]+$");
    }

    public Exp header() {
        return new Exp("headers", "(?<header>.{2,}?)(?:\\s{2,}|$)");
    }

    @Override
    public Parser newParser() {
        Parser p = new Parser();
        this.addToParser(p);
        return p;
    }

    @Override
    public void addToParser(Parser p) {
        p.add(this.blank().eat(Eat.Line).execute((line, match, pattern, parser) -> {
            if (parser != null) {
                int n = parser.remove("row");
            }
        }));
        p.add(this.title().eat(Eat.Line).addRule(ExpRule.PreClose));
        p.add(this.section().eat(Eat.Line).addRule(ExpRule.PreClose));
        p.add(this.display().eat(Eat.Line));
        p.add(this.dashes().eat(Eat.Line));
        p.add(this.header().addRule(ExpRule.Repeat).eat(Eat.Line).execute((line, match, pattern, parser) -> {
            Json arry = match.getJson((Object)"header");
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < arry.size(); ++i) {
                String header = arry.getString((Object)i);
                arry.set((Object)i, (Object)header);
                sb.append("(?<" + header + ">[^ -].*?)(?:\\s{2,}|$)");
            }
            Exp rowExp = new Exp("row", sb.toString()).eat(Eat.Line).nest("data").setMerge(ExpMerge.AsEntry);
            if (parser != null) {
                int removedIndex = parser.remove("row");
                parser.addAt(rowExp, 1);
            }
        }));
    }
}

