/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.tools.parse.file;

import io.hyperfoil.tools.parse.Exp;
import io.hyperfoil.tools.parse.JsJsonFunction;
import io.hyperfoil.tools.parse.JsStringFunction;
import io.hyperfoil.tools.parse.Parser;
import io.hyperfoil.tools.parse.file.ContentConverter;
import io.hyperfoil.tools.parse.file.Filter;
import io.hyperfoil.tools.parse.file.JbossCliConverter;
import io.hyperfoil.tools.parse.file.JsonConverter;
import io.hyperfoil.tools.parse.file.MatchCriteria;
import io.hyperfoil.tools.parse.file.TextConverter;
import io.hyperfoil.tools.parse.file.XmlConverter;
import io.hyperfoil.tools.yaup.PopulatePatternException;
import io.hyperfoil.tools.yaup.StringUtil;
import io.hyperfoil.tools.yaup.json.Json;
import java.lang.invoke.MethodHandles;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;

public class FileRule {
    static final XLogger logger = XLoggerFactory.getXLogger(MethodHandles.lookup().lookupClass());
    private String name;
    private Json with;
    private MatchCriteria criteria = new MatchCriteria();
    private final List<Filter> filters = new LinkedList<Filter>();
    private String nest = "";
    private Function<String, Json> converter = null;

    public static FileRule fromJson(Json json, Map<Object, Object> state) {
        Object asJson;
        String asString;
        Object asJbossCli;
        Function<String, Json> converter;
        FileRule rtrn = new FileRule(json.getString((Object)"name", ""));
        rtrn.addWith(state);
        if (json.has((Object)"nest")) {
            rtrn.setNest(json.getString((Object)"nest"));
        }
        if (json.has((Object)"path")) {
            rtrn.getCriteria().setPathPattern(json.getString((Object)"path"));
        }
        if (json.has((Object)"headerLines")) {
            rtrn.getCriteria().setHeaderLines((int)json.getLong((Object)"headerLines"));
        }
        if (json.has((Object)"filters")) {
            json.getJson((Object)"filters").values().stream().map(o -> (Json)o).forEach(jsonFilter -> {
                Filter f = Filter.fromJson(jsonFilter);
                if (f != null) {
                    rtrn.addFilter(f);
                }
            });
        }
        if (json.has((Object)"findHeader")) {
            Object findHeader = json.get((Object)"findHeader");
            if (findHeader instanceof String) {
                rtrn.getCriteria().addFindPattern(findHeader.toString());
            } else if (findHeader instanceof Json) {
                Json findList = (Json)findHeader;
                findList.values().forEach(findIt -> rtrn.getCriteria().addFindPattern(findIt.toString()));
                if (rtrn.getCriteria().getHeaderLines() < findList.size()) {
                    rtrn.getCriteria().setHeaderLines(findList.size());
                }
            }
        }
        if (json.has((Object)"avoidHeader")) {
            Object avoidheader = json.get((Object)"avoidHeader");
            if (avoidheader instanceof String) {
                rtrn.getCriteria().addNotFindPattern(avoidheader.toString());
            } else if (avoidheader instanceof Json) {
                Json avoidList = (Json)avoidheader;
                avoidList.values().forEach(avoidIt -> rtrn.getCriteria().addNotFindPattern(avoidIt.toString()));
            }
        }
        if (json.has((Object)"asContent")) {
            Object asContent = json.get((Object)"asContent");
            converter = new ContentConverter();
            String asContentStr = asContent.toString();
            try {
                asContentStr = StringUtil.populatePattern((String)asContentStr, state);
            }
            catch (PopulatePatternException e) {
                logger.error(e.getMessage());
            }
            converter.setKey(asContentStr);
            rtrn.setConverter(converter);
        }
        if (json.has((Object)"asText")) {
            TextConverter converter2 = new TextConverter();
            rtrn.setConverter(converter2);
            Object asText = json.get((Object)"asText");
            if (asText instanceof String) {
                String str = asText.toString();
                try {
                    str = StringUtil.populatePattern((String)str, state);
                }
                catch (PopulatePatternException e) {
                    logger.error(e.getMessage());
                }
                String ref = str;
                converter2.addFactory(() -> Parser.fromJson(ref));
            } else if (asText instanceof Json) {
                Json expList = (Json)asText;
                expList.values().forEach(expData -> {
                    if (expData instanceof String) {
                        Exp exp = new Exp(expData.toString());
                        converter2.addExp(exp);
                    } else if (expData instanceof Json) {
                        Exp exp = Exp.fromJson((Json)expData);
                        converter2.addExp(exp);
                    }
                });
            }
        }
        if (json.has((Object)"asJbossCli") && (asJbossCli = json.get((Object)"asJbossCli")) instanceof String) {
            asString = asJbossCli.toString();
            try {
                asString = StringUtil.populatePattern((String)asString, state);
            }
            catch (PopulatePatternException e) {
                logger.error(e.getMessage());
            }
            if (asString.isEmpty()) {
                rtrn.setConverter(new JbossCliConverter());
            } else {
                rtrn.setConverter(new JbossCliConverter().andThen(new JsJsonFunction(asString)));
            }
        }
        if (json.has((Object)"asJson") && (asJson = json.get((Object)"asJson")) instanceof String) {
            asString = (String)asJson;
            try {
                asString = StringUtil.populatePattern((String)asString, state);
            }
            catch (PopulatePatternException e) {
                logger.error(e.getMessage());
            }
            if (asString.isEmpty()) {
                rtrn.setConverter(new JsonConverter());
            } else {
                rtrn.setConverter(new JsonConverter().andThen(new JsJsonFunction(asString)));
            }
        }
        if (json.has((Object)"asXml")) {
            Object asXml = json.get((Object)"asXml");
            if (asXml instanceof String) {
                asString = (String)asXml;
                try {
                    asString = StringUtil.populatePattern((String)asString, state);
                }
                catch (PopulatePatternException e) {
                    logger.error(e.getMessage());
                }
                if (asString.isEmpty()) {
                    rtrn.setConverter(new XmlConverter());
                } else {
                    rtrn.setConverter(new XmlConverter().andThen(new JsJsonFunction(asString)));
                }
            } else if (asXml instanceof Json) {
                converter = new XmlConverter();
                ((Json)asXml).values().stream().map(o -> (Json)o).forEach(arg_0 -> FileRule.lambda$fromJson$7((XmlConverter)converter, arg_0));
                rtrn.setConverter(converter);
            }
        }
        if (json.has((Object)"asPath")) {
            rtrn.setConverter(FileRule.asPath(json.getString((Object)"asPath")));
        }
        return rtrn;
    }

    public static Function<String, Json> asPath(String function) {
        return new JsStringFunction(function);
    }

    public static Json getSchema() {
        Json rtrn = new Json();
        rtrn.set((Object)"$schema", (Object)"http://json-schema.org/draft-07/schema");
        rtrn.set((Object)"definitions", (Object)new Json());
        rtrn.getJson((Object)"definitions").set((Object)"filter", (Object)Filter.getSchemaDefinition());
        rtrn.getJson((Object)"definitions").set((Object)"rule", (Object)FileRule.getSchemaDefinition("filter"));
        rtrn.getJson((Object)"definitions").set((Object)"exp", (Object)Exp.getSchemaDefinition("exp"));
        rtrn.set((Object)"$ref", (Object)"#/definitions/rule");
        return rtrn;
    }

    public static Json getSchemaDefinition(String filterRef) {
        return Json.fromJs((String)("{type: 'object',properties: {  name: {type: 'string'},  nest: {type: 'string'},  path: {type: 'string'},  headerLines: {type: 'number'},  filter: {type: 'array', items: { $ref: '#/definitions/" + filterRef + "' } },  findHeader: { oneOf: [ {type: 'string'} , { type: 'array', items: { type: 'string' } } ] },  avoidHeader: { oneOf: [ {type: 'string'} , { type: 'array', items: { type: 'string' } } ] },  asText: {oneOf: [    { type: 'string'},    { type: 'array', items: { $ref: '#/definitions/exp' } },  ]},  asJbossCli: {oneOf: [    { type: 'string'},  ]},  asJson: {oneOf: [    { type: 'string'},  ]},  asXml: {oneOf: [    { type: 'string'},    { type: 'array', items: { $ref: '#/definitions/filter'} },  ]},  asPath: {type: 'string'},},oneOf: [  { required: ['asContent'] },  { required: ['asJbossCli'] },  { required: ['asJson'] },  { required: ['asText'] },  { required: ['asPath'] },  { required: ['asXml'] },],additionalProperties: false}"));
    }

    public FileRule() {
        this("");
    }

    public FileRule(String name) {
        this.name = name;
        this.with = new Json(false);
    }

    public void addWith(Map<Object, Object> toLoad) {
        if (toLoad != null) {
            toLoad.forEach((k, v) -> this.addWith(k, v));
        }
    }

    public void addWith(Object key, Object value) {
        this.with.add(key, value);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean isValid() {
        return this.converter != null && this.nest != null;
    }

    public FileRule setCriteria(MatchCriteria criteria) {
        this.criteria = criteria;
        return this;
    }

    public FileRule withCriteria(Consumer<MatchCriteria> consumer) {
        consumer.accept(this.criteria);
        return this;
    }

    public FileRule addFilter(Filter filter) {
        this.filters.add(filter);
        return this;
    }

    public FileRule accept(String acceptPattern) {
        return this;
    }

    public FileRule block(String pattern) {
        return this;
    }

    public String getNest() {
        return this.nest;
    }

    public FileRule setNest(String nest) {
        this.nest = nest;
        return this;
    }

    public List<Filter> getFilters() {
        return this.filters;
    }

    public MatchCriteria getCriteria() {
        return this.criteria;
    }

    public Function<String, Json> getConverter() {
        return this.converter;
    }

    public FileRule setConverter(Function<String, Json> converter) {
        this.converter = converter;
        return this;
    }

    public boolean apply(String path, BiConsumer<String, Json> callback) {
        try {
            Json state = this.with.clone();
            boolean matched = this.getCriteria().match(path, state);
            if (matched) {
                Json result = this.getConverter().apply(path);
                String nestPath = StringUtil.populatePattern((String)this.getNest(), (Map)Json.toObjectMap((Json)state));
                if (this.getFilters().isEmpty()) {
                    callback.accept(nestPath, result);
                } else {
                    Json postFilter = new Json();
                    BiConsumer<String, Object> filterCallback = (nest, json) -> Json.chainSet((Json)postFilter, (String)nest, (Object)json);
                    for (Filter filter : this.getFilters()) {
                        filter.apply(result, filterCallback);
                    }
                    callback.accept(nestPath, postFilter);
                }
            }
            return matched;
        }
        catch (Exception e) {
            logger.error("Failed to convert " + path, (Throwable)e);
            return false;
        }
    }

    private static /* synthetic */ void lambda$fromJson$7(XmlConverter converter, Json entry) {
        Filter f = Filter.fromJson(entry);
        if (f != null) {
            converter.addFilter(f);
        }
    }
}

