/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.tools.parse.file;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.spi.json.JsonProvider;
import io.hyperfoil.tools.parse.Exp;
import io.hyperfoil.tools.parse.Parser;
import io.hyperfoil.tools.yaup.PopulatePatternException;
import io.hyperfoil.tools.yaup.StringUtil;
import io.hyperfoil.tools.yaup.json.Json;
import io.hyperfoil.tools.yaup.json.YaupJsonProvider;
import io.hyperfoil.tools.yaup.xml.pojo.Xml;
import io.hyperfoil.tools.yaup.xml.pojo.XmlPath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Filter {
    private static Configuration yaup = Configuration.defaultConfiguration().jsonProvider((JsonProvider)new YaupJsonProvider());
    private String path = "";
    private String nest = "";
    private String regex = "";
    private String result = "";
    private Type type = Type.Json;
    private List<Exp> exps = new ArrayList<Exp>();
    private List<Filter> children = new ArrayList<Filter>();

    public Json toJson() {
        Json rtrn = new Json();
        if (this.hasPath()) {
            rtrn.set((Object)"path", (Object)this.getPath());
        }
        if (this.hasNest()) {
            rtrn.set((Object)"nest", (Object)this.getNest());
        }
        if (this.hasRegex()) {
            rtrn.set((Object)"regex", (Object)this.getRegex());
        }
        if (this.hasResult()) {
            rtrn.set((Object)"result", (Object)this.getResult());
        }
        if (this.hasExp()) {
            Json exps = new Json(true);
            this.getExps().forEach(exp -> exps.add((Object)exp.toJson()));
        }
        return rtrn;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Filter fromJson(Json json) {
        Filter rtrn = new Filter();
        if (json == null) {
            throw new IllegalArgumentException("cannot create Filter from null");
        }
        if (json.has((Object)"path")) {
            rtrn.setPath(json.getString((Object)"path"));
        }
        if (json.has((Object)"nest")) {
            rtrn.setNest(json.getString((Object)"nest"));
        }
        if (json.has((Object)"regex")) {
            rtrn.setRegex(json.getString((Object)"regex"));
        }
        if (json.has((Object)"result")) {
            rtrn.setResult(json.getString((Object)"result"));
        }
        if (json.has((Object)"children")) {
            if (!(json.get((Object)"children") instanceof Json)) throw new IllegalArgumentException("filter children must be an array: " + json.toString());
            Json children = json.getJson((Object)"children");
            if (!children.isArray()) throw new IllegalArgumentException("filter children must be an array: " + json.toString());
            children.forEach(child -> {
                if (!(child instanceof Json)) {
                    throw new IllegalArgumentException("cannot create filter child from " + child);
                }
                Filter childFilter = Filter.fromJson((Json)child);
                rtrn.addChild(childFilter);
            });
        }
        if (!json.has((Object)"exp")) return rtrn;
        if (!(json.getJson((Object)"exp") instanceof Json)) throw new IllegalArgumentException("exp must be json" + json.toString());
        Json exp = json.getJson((Object)"exp");
        if (exp.isArray()) {
            exp.forEach(entry -> {
                if (entry instanceof Json) {
                    Exp e = Exp.fromJson((Json)entry);
                    if (e != null) {
                        rtrn.addExp(e);
                    }
                } else if (entry instanceof String) {
                    Exp e = new Exp((String)entry);
                    rtrn.addExp(e);
                }
            });
            return rtrn;
        } else {
            Exp e = Exp.fromJson(exp);
            if (e == null) return rtrn;
            rtrn.addExp(e);
        }
        return rtrn;
    }

    public static Json getSchemaDefinition() {
        return Json.fromJs((String)"{  type: 'object',  properties: {    path: {type: 'string'},    nest: {type: 'string'},    regex: {type: 'string'},    result: {type: 'string'},  },  required: ['regex'],}");
    }

    public List<Filter> getChildren() {
        return this.children;
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public void addChild(Filter filter) {
        this.children.add(filter);
    }

    public List<Exp> getExps() {
        return this.exps;
    }

    public boolean hasExp() {
        return !this.exps.isEmpty();
    }

    public void addExp(Exp exp) {
        this.exps.add(exp);
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public boolean hasPath() {
        return this.path != null && !this.path.isEmpty();
    }

    public String getPath() {
        return this.path;
    }

    public Filter setPath(String path) {
        this.path = path;
        this.type = path.startsWith("$.") ? Type.Json : (path.startsWith("/") ? Type.Xml : Type.Unknown);
        return this;
    }

    public boolean hasNest() {
        return this.nest != null && !this.nest.isEmpty();
    }

    public String getNest() {
        return this.nest;
    }

    public Filter setNest(String nest) {
        this.nest = nest;
        return this;
    }

    public boolean hasRegex() {
        return this.regex != null & !this.regex.isEmpty();
    }

    public String getRegex() {
        return this.regex;
    }

    public Filter setRegex(String regex) {
        this.regex = regex;
        return this;
    }

    public boolean hasResult() {
        return this.result != null && !this.result.isEmpty();
    }

    public String getResult() {
        return this.result;
    }

    public Filter setResult(String result) {
        this.result = result;
        return this;
    }

    public boolean apply(Object obj, BiConsumer<String, Object> callback) {
        boolean matched = false;
        if (Type.Json.equals((Object)this.getType())) {
            if (obj instanceof Xml) {
                obj = ((Xml)obj).toJson();
            }
            if (!(obj instanceof Json)) {
                return matched;
            }
            matched = true;
            Object rtrn = obj;
            Json inputJson = (Json)obj;
            if (this.hasPath()) {
                matched = false;
                Object results = Json.find((Json)inputJson, (String)this.getPath(), null);
                if (results != null) {
                    matched = true;
                    rtrn = results;
                }
            }
            if (matched) {
                if (this.hasChildren()) {
                    Json fromChildren = new Json();
                    Object childInput = rtrn;
                    if (childInput instanceof Json) {
                        Json rtrnJson = (Json)rtrn;
                        if (rtrnJson.isArray()) {
                            rtrnJson.values().forEach(rtrnEntry -> {
                                Json entryFromChildren = new Json();
                                this.children.forEach(child -> child.apply(rtrnEntry, (nest, out) -> {
                                    if (nest.isEmpty()) {
                                        if (out instanceof Json) {
                                            ((Json)out).forEach((k, v) -> entryFromChildren.set(k, v));
                                        } else {
                                            entryFromChildren.add(out);
                                        }
                                    } else {
                                        Json.chainSet((Json)entryFromChildren, (String)nest, (Object)out);
                                    }
                                }));
                                if (!entryFromChildren.isEmpty()) {
                                    fromChildren.add((Object)entryFromChildren);
                                }
                            });
                        } else {
                            this.children.forEach(child -> child.apply(childInput, (nest, out) -> Json.chainSet((Json)fromChildren, (String)nest, (Object)out)));
                        }
                    } else {
                        this.children.forEach(child -> child.apply(childInput, (nest, out) -> Json.chainSet((Json)fromChildren, (String)nest, (Object)out)));
                    }
                }
                if (this.hasRegex() || this.hasExp()) {
                    Consumer<Object> consumer = null;
                    Runnable cleanup = null;
                    Json newValues = new Json();
                    if (this.hasRegex()) {
                        Matcher m = Pattern.compile(this.getRegex()).matcher("");
                        List keys = StringUtil.getCaptureNames((String)this.getRegex());
                        consumer = value -> {
                            m.reset(value.toString());
                            if (m.matches()) {
                                if (!keys.isEmpty()) {
                                    Json newValuesEntry = new Json();
                                    keys.forEach(key -> newValuesEntry.set(key, (Object)m.group((String)key)));
                                    newValues.add((Object)newValuesEntry);
                                } else {
                                    newValues.add((Object)value.toString().substring(m.start(), m.end()));
                                }
                            }
                        };
                    } else if (this.hasExp()) {
                        Parser parser = new Parser();
                        parser.add(v -> newValues.add((Object)v));
                        this.getExps().forEach(parser::add);
                        consumer = value -> parser.onLine(value.toString());
                        cleanup = () -> parser.close();
                    }
                    if (rtrn instanceof Json) {
                        Json rtrnJson = (Json)rtrn;
                        if (rtrnJson.isArray()) {
                            rtrnJson.values().forEach(consumer::accept);
                        } else {
                            consumer.accept(rtrnJson);
                        }
                    } else {
                        consumer.accept(rtrn);
                    }
                    if (cleanup != null) {
                        cleanup.run();
                    }
                    if (newValues.isEmpty()) {
                        matched = false;
                    } else {
                        rtrn = newValues.size() == 1 ? newValues.get((Object)0) : newValues;
                    }
                }
            }
            if (matched && this.hasResult()) {
                Json newValues = new Json();
                if (this.getResult().startsWith("function") || this.getResult().contains("=>")) {
                    throw new UnsupportedOperationException("js function result generation is not yet supported");
                }
                if (rtrn instanceof Json) {
                    Json rtrnJson = (Json)rtrn;
                    if (rtrnJson.isArray()) {
                        rtrnJson.values().forEach(value -> {
                            String newValue = this.getResult();
                            if (value instanceof Json) {
                                try {
                                    newValue = StringUtil.populatePattern((String)this.getResult(), (Map)Json.toObjectMap((Json)((Json)value)));
                                }
                                catch (PopulatePatternException e) {
                                    e.printStackTrace();
                                }
                            }
                            newValues.add((Object)newValue);
                        });
                    } else {
                        newValues.add((Object)this.getResult());
                    }
                }
                if (!newValues.isEmpty()) {
                    rtrn = newValues;
                }
            }
            if (matched) {
                callback.accept(this.getNest(), rtrn);
            }
        } else if (Type.Xml.equals((Object)this.getType())) {
            if (!(obj instanceof Xml)) {
                return false;
            }
            XmlPath xmlPath = XmlPath.parse((String)this.getPath());
            List list = Arrays.asList((Xml)obj);
            if (this.hasPath()) {
                matched = false;
                List found = xmlPath.getMatches(list.get(0));
                if (!found.isEmpty()) {
                    matched = true;
                    list = found;
                }
            }
            if (matched && this.hasRegex()) {
                List keys = StringUtil.getCaptureNames((String)this.getRegex());
                Matcher m = Pattern.compile(this.getRegex()).matcher("");
                list.forEach(xml -> {
                    String value = xml.documentString(0, false);
                    m.reset(value);
                    if (value.contains(this.getRegex()) || m.find()) {
                        if (!keys.isEmpty() || m.groupCount() > 0) {
                            Json captured = new Json();
                            if (keys.isEmpty()) {
                                keys.forEach(key -> captured.set(key, (Object)m.group((String)key)));
                            } else {
                                for (int i = 0; i < m.groupCount(); ++i) {
                                    captured.set((Object)i, (Object)m.group(i));
                                }
                            }
                            if (this.hasResult()) {
                                try {
                                    String populated = StringUtil.populatePattern((String)this.getResult(), (Map)Json.toObjectMap((Json)captured));
                                    callback.accept(this.getNest(), populated);
                                }
                                catch (PopulatePatternException e) {
                                    e.printStackTrace();
                                }
                            } else {
                                callback.accept(this.getNest(), captured);
                            }
                        } else if (this.hasResult()) {
                            callback.accept(this.getNest(), this.getResult());
                        } else {
                            callback.accept(this.getNest(), value.substring(m.start(), m.end()));
                        }
                    }
                });
            } else if (matched) {
                if (this.hasResult()) {
                    callback.accept(this.getNest(), this.getResult());
                } else if (list.size() == 1) {
                    callback.accept(this.getNest(), ((Xml)list.get(0)).toJson());
                } else {
                    Json toReturn = new Json();
                    list.forEach(xml -> toReturn.add((Object)xml.toJson()));
                    callback.accept(this.getNest(), toReturn);
                }
            }
        }
        return matched;
    }

    public static enum Type {
        Json,
        Xml,
        Unknown;

    }
}

