/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.tools.parse.file;

import io.hyperfoil.tools.yaup.StringUtil;
import io.hyperfoil.tools.yaup.file.FileUtility;
import io.hyperfoil.tools.yaup.json.Json;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class MatchCriteria {
    private String pathPattern = "";
    private int headerLines = 0;
    private final LinkedHashSet<String> findPatterns = new LinkedHashSet();
    private final LinkedHashSet<String> notFindPatterns = new LinkedHashSet();

    public String toString() {
        return this.pathPattern + " lines=" + this.headerLines + " find=" + this.findPatterns + " avoid=" + this.notFindPatterns;
    }

    public MatchCriteria() {
    }

    public MatchCriteria(String pathPattern) {
        this.pathPattern = pathPattern;
    }

    public boolean isSet() {
        return this.hasPathPattern() || this.hasFindPatterns() || this.hasNotFindPatterns();
    }

    public MatchCriteria setPathPattern(String pattern) {
        this.pathPattern = pattern;
        return this;
    }

    public MatchCriteria addFindPattern(String pattern) {
        this.findPatterns.add(pattern);
        return this;
    }

    public MatchCriteria addNotFindPattern(String pattern) {
        this.notFindPatterns.add(pattern);
        return this;
    }

    public boolean hasPathPattern() {
        return !this.pathPattern.isEmpty();
    }

    public String getPathPattern() {
        return this.pathPattern;
    }

    public Iterator<String> getFindPatterns() {
        return this.findPatterns.iterator();
    }

    public Iterator<String> getNotFindPatterns() {
        return this.notFindPatterns.iterator();
    }

    public MatchCriteria setHeaderLines(int headerLines) {
        this.headerLines = headerLines;
        return this;
    }

    public int getHeaderLines() {
        return this.headerLines;
    }

    public boolean hasFindPatterns() {
        return !this.findPatterns.isEmpty();
    }

    public boolean hasNotFindPatterns() {
        return !this.notFindPatterns.isEmpty();
    }

    public boolean usesHeader() {
        return this.getHeaderLines() > 0 && (this.hasFindPatterns() || this.hasNotFindPatterns());
    }

    public boolean match(String input, Json state) {
        Matcher m;
        boolean rtrn = true;
        Json toMerge = new Json();
        if (this.hasPathPattern()) {
            rtrn = false;
            rtrn = input.contains(this.pathPattern);
            if (!rtrn) {
                try {
                    m = Pattern.compile(this.pathPattern).matcher(input);
                    if (m.find()) {
                        rtrn = true;
                        List keys = StringUtil.getCaptureNames((String)this.pathPattern);
                        for (String key : keys) {
                            toMerge.set((Object)key, (Object)m.group(key));
                        }
                    }
                }
                catch (PatternSyntaxException e) {
                    rtrn = false;
                }
            }
        }
        if (rtrn && this.usesHeader()) {
            Iterator<String> iter;
            String headerLines = FileUtility.readHead((String)input, (int)this.getHeaderLines());
            if (this.hasFindPatterns()) {
                rtrn = false;
                iter = this.getFindPatterns();
                while (iter.hasNext()) {
                    try {
                        String findPattern = iter.next();
                        if (headerLines.contains(findPattern)) {
                            rtrn = true;
                            break;
                        }
                        m = Pattern.compile(findPattern).matcher(headerLines);
                        if (!m.find()) continue;
                        rtrn = true;
                        List keys = StringUtil.getCaptureNames((String)findPattern);
                        for (String key : keys) {
                            toMerge.set((Object)key, (Object)m.group(key));
                        }
                        break;
                    }
                    catch (PatternSyntaxException e) {
                        rtrn = false;
                    }
                }
            }
            if (rtrn && this.hasNotFindPatterns()) {
                iter = this.getNotFindPatterns();
                while (iter.hasNext()) {
                    String notFindPattern = iter.next();
                    try {
                        if (!headerLines.contains(notFindPattern) && !(m = Pattern.compile(notFindPattern).matcher(headerLines)).find()) continue;
                        rtrn = false;
                        break;
                    }
                    catch (PatternSyntaxException patternSyntaxException) {
                    }
                }
            }
        }
        if (rtrn && !toMerge.isEmpty()) {
            state.merge(toMerge);
        }
        return rtrn;
    }
}

