/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.tools.parse.file;

import io.hyperfoil.tools.parse.Exp;
import io.hyperfoil.tools.parse.Parser;
import io.hyperfoil.tools.parse.file.FileRule;
import io.hyperfoil.tools.parse.file.Filter;
import io.hyperfoil.tools.parse.file.JbossCliConverter;
import io.hyperfoil.tools.parse.file.JsonConverter;
import io.hyperfoil.tools.parse.file.TextConverter;
import io.hyperfoil.tools.parse.file.XmlConverter;
import io.hyperfoil.tools.yaup.json.Json;
import java.util.function.Function;
import java.util.function.Supplier;

public class RuleBuilder {
    private final String name;
    private final FileRule rule;

    public RuleBuilder(String name) {
        this.name = name;
        this.rule = new FileRule(name);
    }

    public RuleBuilder path(String path) {
        this.rule.getCriteria().setPathPattern(path);
        return this;
    }

    public RuleBuilder header(int size) {
        this.rule.getCriteria().setHeaderLines(size);
        return this;
    }

    public RuleBuilder findHeader(String line) {
        this.rule.getCriteria().addFindPattern(line);
        return this;
    }

    public RuleBuilder avoidHeader(String line) {
        this.rule.getCriteria().addNotFindPattern(line);
        return this;
    }

    public RuleBuilder nest(String nest) {
        this.rule.setNest(nest);
        return this;
    }

    public FileRule asPath(Function<String, Json> converter) {
        this.rule.setConverter(converter);
        return this.rule;
    }

    public FileRule asText(Supplier<Parser> supplier) {
        this.rule.setConverter(new TextConverter().addFactory(supplier));
        return this.rule;
    }

    public FileRule asText(Exp ... exp) {
        TextConverter converter = new TextConverter();
        for (int i = 0; i < exp.length; ++i) {
            converter.addExp(exp[i]);
        }
        this.rule.setConverter(converter);
        return this.rule;
    }

    public FileRule asJbossCli() {
        this.rule.setConverter(new JbossCliConverter());
        return this.rule;
    }

    public FileRule asJbossCli(Function<Json, Json> then) {
        this.rule.setConverter(new JbossCliConverter().andThen(then));
        return this.rule;
    }

    public FileRule asJson() {
        this.rule.setConverter(new JsonConverter());
        return this.rule;
    }

    public FileRule asJson(Function<Json, Json> then) {
        this.rule.setConverter(new JsonConverter().andThen(then));
        return this.rule;
    }

    public FileRule asXml() {
        this.rule.setConverter(new XmlConverter());
        return this.rule;
    }

    public FileRule asXml(Filter ... filters) {
        XmlConverter converter = new XmlConverter();
        for (int i = 0; i < filters.length; ++i) {
            converter.addFilter(filters[i]);
        }
        this.rule.setConverter(converter);
        return this.rule;
    }
}

