/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.tools.parse.file;

import io.hyperfoil.tools.parse.Exp;
import io.hyperfoil.tools.parse.JsonConsumer;
import io.hyperfoil.tools.parse.Parser;
import io.hyperfoil.tools.yaup.file.FileUtility;
import io.hyperfoil.tools.yaup.json.Json;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class TextConverter
implements Function<String, Json> {
    private final List<Supplier<Parser>> factories = new ArrayList<Supplier<Parser>>();
    private final List<Exp> exps = new LinkedList<Exp>();

    public TextConverter addFactory(Supplier<Parser> factory) {
        this.factories.add(factory);
        return this;
    }

    public boolean hasFactory() {
        return !this.factories.isEmpty();
    }

    public List<Supplier<Parser>> getFactories() {
        return this.factories;
    }

    public boolean hasExp() {
        return !this.exps.isEmpty();
    }

    public List<Exp> getExps() {
        return this.exps;
    }

    public TextConverter addExp(Exp exp) {
        this.exps.add(exp);
        return this;
    }

    @Override
    public Json apply(String s) {
        Json rtrn = new Json();
        JsonConsumer consumer = event -> rtrn.add((Object)event);
        ArrayList<Parser> parsers = new ArrayList<Parser>();
        if (this.hasExp()) {
            Parser p = new Parser();
            this.getExps().forEach(p::add);
            parsers.add(p);
        }
        this.getFactories().forEach(factory -> parsers.add((Parser)factory.get()));
        parsers.forEach(parser -> parser.add(consumer));
        int lineNumber = 0;
        String line = null;
        try (BufferedReader inputStream = new BufferedReader(new InputStreamReader(FileUtility.getInputStream((String)s)));){
            while ((line = inputStream.readLine()) != null) {
                for (Parser parser2 : parsers) {
                    parser2.onLine(line, lineNumber);
                }
                ++lineNumber;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        parsers.forEach(Parser::close);
        return rtrn;
    }
}

