/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.tools.parse.internal;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class DropString
implements CharSequence {
    String line;
    List<Ref> references = new LinkedList<Ref>();
    List<Drop> drops = new ArrayList<Drop>();

    DropString(String line) {
        this.line = line;
    }

    public String getLine() {
        return this.line;
    }

    public Ref reference(int index) {
        Ref ref = new Ref(index);
        this.references.add(ref);
        return ref;
    }

    public void removeReference(Ref reference) {
        this.references.remove(reference);
    }

    public void clearReferences() {
        this.references.clear();
    }

    public int referenceCount() {
        return this.references.size();
    }

    public int getOriginalIndex(int currentIndex) {
        int rtrn = currentIndex;
        int idx = this.drops.size();
        for (int i = idx - 1; i >= 0; --i) {
            Drop d = this.drops.get(i);
            if (rtrn < d.getStart()) continue;
            rtrn += d.getEnd();
        }
        return rtrn;
    }

    final void updateReferences(int start, int end) {
        this.drops.add(new Drop(start, end));
        if (!this.references.isEmpty()) {
            for (Ref ref : this.references) {
                int value = ref.get();
                if (value <= start) continue;
                int newValue = start;
                newValue = value > end ? start + (value - end) : start;
                ref.set(newValue);
            }
        }
    }

    public abstract void drop(int var1, int var2);

    public static class Ref
    implements Comparable<Ref> {
        private final AtomicInteger value;

        private Ref(int index) {
            this.value = new AtomicInteger(index);
        }

        public int get() {
            return this.value.get();
        }

        private void set(int newValue) {
            this.value.set(newValue);
        }

        @Override
        public int compareTo(Ref o) {
            return Integer.compare(this.get(), o.get());
        }
    }

    public static class Drop {
        final int start;
        final int end;

        public Drop(int start, int stop) {
            this.start = start;
            this.end = stop;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }
    }
}

