/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.tools.parse.internal;

import io.hyperfoil.tools.parse.internal.IMatcher;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexMatcher
implements IMatcher {
    private static final String FIELD_PATTERN = "\\(\\?<(?!!)([^>]+)>";
    private static final String SAFE_PREFIX = "x";
    private Matcher matcher;
    ThreadLocal<Matcher> cachedMatcher;
    private final Matcher fieldMatcher = Pattern.compile("\\(\\?<(?!!)([^>]+)>").matcher("");
    private LinkedHashMap<String, String> renames;
    private String pattern;
    private String safePattern;
    private int regionStart = -1;
    private int regionStop = -1;

    public static List<String> getAllNames(String pattern) {
        ArrayList<String> rtrn = new ArrayList<String>();
        Matcher matcher = Pattern.compile(FIELD_PATTERN).matcher(pattern);
        while (matcher.find()) {
            String match = matcher.group(1);
            rtrn.add(match);
        }
        return rtrn;
    }

    public RegexMatcher(String pattern) {
        Object newPattern = pattern;
        this.renames = new LinkedHashMap();
        this.fieldMatcher.reset((CharSequence)newPattern);
        while (this.fieldMatcher.find()) {
            int start = this.fieldMatcher.start(1);
            int end = this.fieldMatcher.end(1);
            String realName = this.fieldMatcher.group(1);
            Object compName = realName.replaceAll("[\"/_ +.()\\[\\]\\- \\\\]", SAFE_PREFIX).replaceAll(" ", "");
            if (!Character.isLetter(((String)compName).charAt(0))) {
                compName = SAFE_PREFIX + (String)compName;
            }
            if (!((String)compName).equals(realName)) {
                newPattern = ((String)newPattern).substring(0, start) + (String)compName + ((String)newPattern).substring(end);
                this.fieldMatcher.reset((CharSequence)newPattern);
            }
            this.renames.put(realName, (String)compName);
        }
        this.pattern = pattern;
        this.safePattern = newPattern;
        this.cachedMatcher = new ThreadLocal();
        this.cachedMatcher.set(Pattern.compile((String)newPattern).matcher(""));
        this.matcher = Pattern.compile((String)newPattern).matcher("");
    }

    @Override
    public void reset(CharSequence input) {
        if (this.cachedMatcher.get() == null) {
            this.cachedMatcher.set(Pattern.compile(this.safePattern).matcher(""));
        }
        this.cachedMatcher.get().reset(input);
        this.matcher.reset(input);
    }

    @Override
    public boolean find() {
        if (this.cachedMatcher.get() != null) {
            return this.cachedMatcher.get().find();
        }
        return this.matcher.find();
    }

    @Override
    public boolean find(CharSequence input, int start, int end) {
        this.reset(input);
        this.region(start, end);
        return this.find();
    }

    @Override
    public void region(int start, int end) {
        this.regionStart = start;
        this.regionStop = end;
        if (this.cachedMatcher.get() != null) {
            this.cachedMatcher.get().region(start, end);
        } else {
            this.matcher.region(start, end);
        }
    }

    @Override
    public int start() {
        if (this.cachedMatcher.get() != null) {
            return this.cachedMatcher.get().start();
        }
        return this.matcher.start();
    }

    @Override
    public int end() {
        if (this.cachedMatcher.get() != null) {
            return this.cachedMatcher.get().end();
        }
        return this.matcher.end();
    }

    @Override
    public Set<String> groups() {
        return this.renames.keySet();
    }

    @Override
    public String group(String name) {
        String newName;
        String string = newName = this.renames.containsKey(name) ? this.renames.get(name) : name;
        if (this.cachedMatcher.get() != null) {
            return this.cachedMatcher.get().group(newName);
        }
        return this.matcher.group(newName);
    }
}

